<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA12.html');
?>

<div class="item2">
    <h2>1.2. Racionálne čísla</h2>

    <section>
        <h3>Historický prídavok</h3>

        <p>
            Skôr než sa pustíme do hľadania dier na racionálnej číselnej osi, budeme sa zaoberať špeciálnymi rovnicami typu
            $$\bf{a \cdot m + b \cdot n = c},$$

            kde neznáme $\bf{m, n}$, aj parametre $\bf{a, b, c}$ nadobúdajú len celočíselné hodnoty. Takýmto rovniciam s dvoma
            celočíselnými premennými, alebo sústavám $\bf{k – 1}$ takýchto rovníc s $\bf{k}$ celočíselnými premennými hovoríme
            <b>Diofantické rovnice</b> <sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Diophantus/" target="_blank"><dfn title="Diofantos.">5</dfn></a>]</sup>
            , alebo <b>sústavy diofantických rovníc</b>.
        </p>

        <p>
            Zamyslime sa nad rovnicou $\bf{a \cdot m + b \cdot n = c}$. Keby čísla $\bf{a, b, c}$ mali spoločného deliteľa,
            mohli by sme ním rovnicu predeliť, preto sa budeme zaoberať iba prípadom, keď najväčší spoločný deliteľ týchto
            troch čísel je $1$. Nezaujímavý je prípad, keď čísla $\bf{a, b}$ majú netriviálneho spoločného deliteľa $\bf{d}$,
            ale tento nie je deliteľom čísla $\bf{c}$:

            $$\bf{pd \cdot m + qd \cdot n = c}$$

            vtedy totiž rovnica v obore celých čísel zrejme nemá riešenie.

        </p>

        <p>
            Miesto dlhého teoretizovania vyriešme radšej
        </p>


        <div class="priklad">
            <h3>Príklad 2.</h3>
            <p>
                V koncertnej sále boli klavíry a stoličky. Spolu mali $104$ nôh. Koľko tam bolo klavírov a koľko stoličiek, ak vieme,
                že stoličiek bolo viac? (Predpokladáme, že každá stolička má $4$ a každý klavír $3$ nohy.)
            </p>

            <p>
                Máme teda vyriešiť rovnicu:
                $$\bf{3p + 4q = 104}$$
                pričom z kontextu úlohy  vyplýva, že oborom premenných sú nezáporné celé čísla.

            </p>

            <p>
                Rovnicu upravíme: <br>
                $\bf{3p + 3q - 102 = 2 - q}$ z čoho je zrejmé, že riešenie bude existovať len ak existuje také celé číslo $\bf{r}$, že
                $\bf{2 - q = 3r}$ odkiaľ dostávame $\bf{\bbox[lime, 5px]{q = 2 - 3r}}$
            </p>

            <p>
                Tento výsledok dosadíme do prvej rovnice a máme:<br>
                $\bf{3p + 4(2-3r) = 104}$ čo po úpravách dáva $\bf{p - 4r = 32}$, odkiaľ $\bf{\bbox[lime, 5px]{p = 32 + 4r}}$
            </p>

            <p>
                Všetky riešenia dostaneme z tabuľky:
                $$
                \begin{array}{|c|c|c|c|c|}
                \hline r & \cellcolor{magenta} \bf{-9} & \cellcolor{lime} \bf{-8} & \cellcolor{lime} \bf{-7} & \cellcolor{lime} \bf{-6} & \cellcolor{lime} \bf{-5} & \cellcolor{red} \bf{-4} & \cellcolor{red} \bf{-3} & \cellcolor{red} \bf{-2} & \cellcolor{red} \bf{-1} & \cellcolor{red} \bf{0} & \cellcolor{magenta} \bf{1} \\
                \hline p & \cellcolor{magenta} \bf{-4} & \cellcolor{lime} \bf{0} & \cellcolor{lime} \bf{4} & \cellcolor{lime} \bf{8} & \cellcolor{lime} \bf{12} & \cellcolor{red} \bf{16} & \cellcolor{red} \bf{20} & \cellcolor{red} \bf{24} & \cellcolor{red} \bf{28} & \cellcolor{red} \bf{36} & \cellcolor{magenta} \bf{40} \\
                \hline q & \cellcolor{magenta} \bf{29} & \cellcolor{lime} \bf{26} & \cellcolor{lime} \bf{23} & \cellcolor{lime} \bf{20} & \cellcolor{lime} \bf{17} & \cellcolor{red} \bf{14} & \cellcolor{red} \bf{11} & \cellcolor{red} \bf{8} & \cellcolor{red} \bf{5} & \cellcolor{red} \bf{2} & \cellcolor{magenta} \bf{-1} \\

                \hline
                \end{array}
                $$

            </p>

            <p>
                Fialové možnosti dávajú záporné výsledky, v červených prípadoch je viac klavírov ako stoličiek, preto zostávajú len zelené možnosti ako správne riešenia.
            </p>
        </div>
        <br>
        <div class="priklad">
            <h3>Príklad 3.</h3>
            <p>
                Pán Milan A. je numizmatik. Ak si svoje kremnické dukáty rozdelí do siedmich radov, zvýšia mu $4$, ak ich rozloží do jedenástich radov, zvýši mu $5$ dukátov.
                Koľko má dukátov, ak vieme že ich nemá viac ako $1000$?
            </p>

            <p>
                Máme vlastne vyriešiť rovnicu $\bf{7a + 4 = 11b + 5 \qquad (1)}$
            </p>

            <p>
                Pričom oborom premenných sú nezáporné celé čísla a $\bf{7a + 4 \lt 1000}$
            </p>

            <p>
                Podobne ako v minulom príklade rovnicu upravíme na tvar<br>
            <ol>$\bf{7a = 7b + 4b + 1}$</ol>
            z čoho je zrejmé, že riešenie bude existovať len ak existuje také $\bf{c}$, že $\bf{4b + 1 = 7c \qquad (2)}$
            </p>

            <p>
                Pre túto rovnicu zopakujme náš postup, t. j. upravme ju na tvar:<br>
            <ol>$\bf{4b = 4c + 3c - 1}$</ol>
            opäť je zrejmé, že riešenie bude existovať len ak existuje také $\bf{d}$, že
            $\bf{3c - 1 = 4d} \qquad (3)$
            </p>

            <p>
                Pre túto rovnicu opäť zopakujeme náš postup, t. j. upravíme ju na tvar:
            <ol>$\bf{3c = 3d + d + 1}$</ol>
            z ktorého je zrejmé, že riešenie bude existovať len ak existuje také $\bf{e}$, že $\bf{d + 1 = 3e \qquad (4)}$
            </p>

            <p>
                Z tejto rovnice dostávame: $\bf{d = 3e - 1}$
            </p>

            <p>
                Teraz budeme spätne dosadzovať do predchádzajúcich rovníc. Postupne budeme dostávať:
            <ol>$\begin{align}
                &c = 4e - 1 \\
                &\bbox[lime, 5px]{b = 7e - 2}\\
                &\bbox[lime, 5px]{a = 11e - 3}
                \end{align}$</ol>
            všetky vhodné riešenia dostaneme z tabuľky:

            $$
            \begin{array}{|c|c|c|c|c|}
            \hline \bf{e} & 1 & 2 & 3 & 4 & 5 & 6 \\
            \hline \bf{a} & 8 & 19 & 30 & 41 & 52 & 63 \\
            \hline \bf{b} & 5 & 12 & 19 & 26 & 33 & 40 \\
            \hline \bf{7a + 4} & \cellcolor{lime} 60 & \cellcolor{lime} 137 & \cellcolor{lime} 214 & \cellcolor{lime} 291 & \cellcolor{lime} 368 & \cellcolor{lime} 445\\

            \hline
            \end{array}
            $$
            </p>

            <p>
                Uvedomme si, že náš postup musel mať úspech. Sledujme koeficienty pri neznámych v jednotlivých rovniciach:
                $$\begin{aligned}
                &\bf{(1) \qquad 7 \; a \; 11} \\
                &\bf{(2) \qquad 4 \; a \; 7} \\
                &\bf{(3) \qquad 3 \; a \; 4} \\
                &\bf{(4) \qquad 1 \; a \; 3} \\
                \end{aligned}$$
            </p>

            <p>
                Nepripomína vám to hľadanie najväčšieho spoločného deliteľ čísiel $\bf{7}$ a $\bf{11}$ Euklidovým algoritmom?
                Oprávnene áno, čiže naše koeficienty sa neustále zmenšujú a vzhľadom na podmienku, že ich NSD je $1$, po konečnom
                počte krokov dostaneme rovnicu, v ktorej je pri jednej z premenných koeficient $1$.
            </p>
        </div>
        <br>
        <div class="priklad">
            <h3>Príklad 4.</h3>
            <p>
                Nájdite najmenšie prirodzené číslo $\bf{n}$ také, že zlomok $\bf{\frac{5n + 2}{3n + 1}}$ sa dá krátiť.
            </p>

            <h3>Riešenie:</h3>
            <p>
                Krátky experiment (pozri hárok zlomok zošitu Diofantos) nič nerieši. Máme podozrenie, že zlomok je v základnom
                tvare pre každé $\bf{n}$, to sa ale experimentom dokázať nedá. Uvažujme takto:</p>
            <p>
                <details class="detail">
                    <summary class="summary"><b>Diofantos</b></summary><br>
                    <iframe scrolling="no" title="A1.16" src="https://www.geogebra.org/material/iframe/id/zqhs4skh/width/1100/height/937/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1100px" height="937px" style="border:0px;"> </iframe>
                </details></p>

            <p>
                Ak $\bf{a / b}$ (pozri poznámku<sup><dfn title="Symbolom a/b označujeme fakt, že číslo b je násobkom čísla a, resp. že číslo a je deliteľom čísla b.">[6]</dfn></sup> )
                a $\bf{a / c}$ tak zrejme aj $\bf{a / b + c}$ a pre ľubovoľné $\bf{k}$ celé $\bf{a / k \cdot b}$.

            </p>

            <p>
                Ak teda $\bf{d / 5n + 2}$ a súčasne $\bf{d / 3n + 1}$, tak  $\bf{d / 3 \cdot (5n + 2) - 5 \cdot (3n + 1) = 1}$.
            </p>

            <p>
                Teda každý spoločný deliteľ čitateľa aj menovateľa nášho zlomku je deliteľom jednotky, presnejšie najväčší spoločný
                deliteľ čitateľa a menovateľa je jednotka, zlomok sa nikdy krátiť nedá.
            </p>




        </div>
        <p>
            Tento trik (vyjadrenie faktu, že spoločný deliteľ dvoch čísel je aj deliteľom súčtu ich ľubovoľných
            násobkov<sup><dfn title="Súčet násobkov dvoch čísel (výrazov, alebo aj iných objektov) voláme ich lineárna kombinácia.">[7]</dfn></sup> )
            použijeme aj pri nasledujúcom príklade:
        </p>

        <div class="priklad">
            <h3>Príklad 5.</h3>

            <p>
                Stojíte pred prameňom prírodnej minerálnej vody a máte k dispozícii jeden päťlitrový a jeden trojlitrový demižón.
                Dá sa len pomocou nich načapovať pri prameni presne jeden liter minerálky ?
            </p>

            <h3>Riešenie:</h3>

            <p>
                <b>Využijeme, že  $\bf{2 \cdot 5 – 3 \cdot 3 = 1}$</b>. To znamená, že budeme musieť dvakrát načapovať do plna
                päťlitrový demižón a trikrát vyliať plný trojlitrový demižón. To sa dá uskutočniť takouto postupnosťou krokov
                (<mark style="background: cyan;"> modrá</mark> znamená načapovanie, <mark style="background: red;"> červená</mark> vyliatie):
                $$(0; 0) \bbox[cyan, 5px]{\spadesuit} (5; 0) \spadesuit (2; 3) \bbox[red, 5px]{\spadesuit} (2; 0) \spadesuit (0;2)
                \bbox[cyan, 5px]{\spadesuit} (5; 2) \spadesuit (4; 3) \bbox[red, 5px]{\spadesuit} (4; 0) \spadesuit (1; 3) \bbox[red, 5px]{\spadesuit} (1; 0)$$
            </p>

        </div>
        <br>
        <div class="uloha">
            <h3>Úlohy</h3>
            <ol start="10">
                <li>
                    <p>
                        Nájdite všetky trojciferné čísla, ktoré pri delení s číslom $\bf{33}$ dávajú zvyšok $\bf{10}$ a pri delení
                        s číslom $\bf{28}$ zvyšok $\bf{6}$. (Pomôžte si 1. hárkom zošitu Diofantos. Pomocou neho skontrolujte aj
                        výsledok posledného príkladu.)
                    </p>
                    <p>
                        <details class="detail">
                            <summary class="summary"><b>Diofantos</b></summary><br>
                            <iframe scrolling="no" title="A1.16" src="https://www.geogebra.org/material/iframe/id/zqhs4skh/width/1100/height/937/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1100px" height="937px" style="border:0px;"> </iframe></details></p>


                </li>

                <li>
                    <p>
                        Nájdite najmenšie prirodzené číslo $\bf{a}$, pre ktoré má rovnica
                        $$\bf{30x + 42y = 100 + a}$$
                        riešenie v množine prirodzených čísel.
                    </p>
                </li>
            </ol>
        </div>


    </section>

    <div class="pagination">
        <a href="A12_3.php">&laquo;</a>
        <a href="A12_1.php">1</a>
        <a href="A12_2.php">2</a>
        <a href="A12_3.php">3</a>
        <a class="active" href="A12_4.php">4</a>
        <a href="A12_1.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
