<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA13.html');
?>

<div class="item2">
    <h2>1.3 Diery v číselnej osi alebo iracionálne čísla</h2>

    <section>
        <div class="priklad">
            <h3>Príklad 1.</h3>
            <div class="center2"><img src="photo/p23.png" alt="obrazky"></div>

            <p>
                Zostrojme na číselnej osi bod <b>u</b>, ktorý má od začiatku vzdialenosť rovnú dĺžke uhlopriečky štvorca,
                ktorého strana má dĺžku 1.
            </p>

            <p>
                Otázka znie, <b>je to obraz niektorého racionálneho čísla?</b>
            </p>

            <p>
                Vďaka Pytagorovej vete vieme, že $\bf{u^2 = 2}$. Preto číslo $\bf{u}$ leží medzi číslami $\bf{1}$
                a $\bf{2}$. Keby sme sa pozreli z bližšia (pozrite si 1. list zošitu UHLOPRIEČKA), dostávali by sme pre číslo
                $\bf{u}$ (teda pre dĺžku skúmanej uhlopriečky štvorca s jednotkovou stranou) postupne tieto ohraničenia:
                $$\bf{1.4 \lt u \lt 1.5}$$
                $$\bf{1.41 \lt u \lt 1.42}$$
                $$\bf{1.414 \lt u \lt 1.415}$$
            </p>

            <p>
                <details class="detail">
                    <summary class="summary"><b>UHLOPRIEČKA</b></summary><br>
                    <div class="center2"><iframe scrolling="no" title="A1.17a" src="https://www.geogebra.org/material/iframe/id/xdetadjy/width/1000/height/700/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1000px" height="700px" style="border:0px;"> </iframe>
                    </div></details></p>

            <p>
                V praxi s meraním obvykle končíme, keď dosiahneme požadovanú presnosť, respektíve, keď nám používané náčinie
                neumožňuje pokračovať. Experimentovanie v Exceli(jeho možnosti sú ohraničené presnosťou reprezentácie reálnych
                čísel v pamäti počítača) sme skončili pri čísle $\bf{1.414213562373}$.
            </p>

            <p>
                Vzniká vážne podozrenie, že keby sme pokračovali ľubovoľne dlho, nikdy by sme nezískali desatinné číslo,
                ktorého druhá mocnina sa rovná dvom. Žiaľ, toto podozrenie sa pokračovaním vo výpočte nedá dokázať (je totiž
                možné, že po ďalšom výpočte by sa začali cifry periodicky opakovať).
            </p>

            <p>
                Týmto problémom sa zaoberali grécki matematici, súčasníci Pytagora. Oni riešili problém:<br>
                <b>"Existuje štvorec
                    <sup><dfn title="Mysleli štvorec, t.j. druhú mocninu prirodzeného čísla.">[1]</dfn></sup>
                    , ktorý je súčtom dvoch rovnakých štvorcov?"</b>
            </p>

            <p>
                V našej terminológii: Existujú také prirodzené čísla $\bf{a, b}$, že $\bf{a^2 = b^2 + b^2}$ ? <b>(*)</b>
            </p>

            <p>
                Uvažovali asi takto. Nech také dvojice prirodzených čísel, ktoré spĺňajú vzťah <b>(*)</b> existujú. Potom je
                jedna z nich, napríklad $\bf{m, n}$ iste najmenšia. Teda $\bf{m^2 = n^2 + n^2}$.
            </p>

            <p>
                Uvažujme čísla $\bf{p = m - n, q = 2n - m}$. Ukážeme, že tiež spĺňajú vzťah <b>(*)</b>. Naozaj,
                $$\bf{q^2 = (2n - m)^2 = 4n^2 - 4nm + m^2 = 4n^2 - 4nm + 2n^2 = 6n^2 - 4mn}$$
                $$\bf{2 \cdot p^2 = 2(m - n)^2 = 2m^2 - 4mn + 2n^2 = 6n^2 - 4mn}$$
                Ale dvojica $\bf{p, q}$ je už menšia ako dvojica $\bf{m, n (p + q = n)}$, <b>preto predpoklad, že existujú
                    také dvojice prirodzených čísel, ktoré spĺňajú vzťah (*) je falošný, vedie ku sporu.</b>
            </p>

            <p>
                Tvrdenie (*) je ekvivalentné s tvrdením, že existuje také racionálne číslo $\bf{u}$, pre ktoré platí:

                $$\bf{u^2 = 2}$$
            <ol>lebo</ol>
            $$\bf{a^2 = b^2 + b^2 \iff a^2 = 2 \cdot b^2 \iff \biggl ( \frac{a}{b} \biggr )^2 = 2}$$
            </p>

            <p>
                Týmto spôsobom sme zistili, že ten bod číselnej osi, ktorého vzdialenosť od začiatku je rovná dĺžke uhlopriečky
                jednotkového štvorca, <b>nie je obrazom žiadneho racionálneho čísla</b>, alebo inak povedané "racionálna"
                číselná os má "diery". Takých "dier" v racionálnej číselnej osi je nespočetne mnoho. Napríklad neexistujú
                také racionálne čísla, ktorých druhá mocnina $\bf{3}$, alebo $\bf{5, 6, 7, 8, 10,}$ ...
            </p>
        </div>





    </section>

    <div class="pagination">
        <a href="A13_5.php">&laquo;</a>
        <a class="active" href="A13_1.php">1</a>
        <a href="A13_2.php">2</a>
        <a href="A13_3.php">3</a>
        <a href="A13_4.php">4</a>
        <a href="A13_5.php">5</a>
        <a href="A13_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
