<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA13.html');
?>

<div class="item2">
    <h2>1.3 Diery v číselnej osi alebo iracionálne čísla</h2>

    <section>

        <div>
            <h3><mark>Poznámka</mark></h3>

            <p>
                Vzťahy $\bf{p = m - n, q = 2n - m}$ sú zaujímavé. Otvorte si zošit SQRT(2), sú v ňom dve postupnosti,
                $\bf{a(n)}$ a $\bf{b(n)}$ definované takto:

                $$\bf{a(n + 1) = b(n) - a(n),}$$ $$\bf{b(n + 1) = 2 \cdot a(n) - b(n)}$$
            </p>

            <p>
                <details class="detail">
                    <summary class="summary"><b>SQRT(2)</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A1.18" src="https://www.geogebra.org/material/iframe/id/ckpaj78w/width/944/height/916/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="916px" style="border:0px;"> </iframe>
                    </div> </details></p>

            <p>
                Zaujímavé je, že bez ohľadu na to, ako zvolíte prvé členy týchto postupností, číslo
                $\bf{\biggl | \frac{a(n)}{b(n)} \biggr |}$ sa bude vždy približovať (už pre malé $n$) k druhej odmocnine
                z dvoch.
            </p>
        </div>
        <br>
        <div class="priklad">
            <h3>Príklad 2.</h3>

            <p>
                Ukážeme ešte jeden dôkaz tvrdenia, že neexistuje také racionálne číslo $\bf{u}$, pre ktoré platí
                $\bf{u^2 = 2}$.
            </p>

            <p>
                Podobne, ako v predchádzajúcom príklad použijeme tzv. dôkaz sporom: <br>
                Predpokladajme, že také racionálne číslo $\bf{u}$ existuje, t.j. existujú také prirodzené čísla $\bf{a, b}$,
                pre ktoré platí: $\bf{\biggl (\frac{a}{b} \biggr )^2 = 2}$ a súčasne sú čísla $\bf{a, b}$ nesúdeliteľné.
                (Proste zo všetkých zlomkov požadovanej vlastnosti vyberieme ten, ktorý sa už nedá krátiť.) Potom ale
                $\bf{a^2 = 2 \cdot b^2}$, čiže číslo $\bf{a^2}$ je párne. Z toho ale vyplýva, že aj $\bf{a}$ musí byť
                párne<b><sup><dfn title="Keby nebolo, keby neexistovalo také prirodzené číslo k, že: a = 2k + 1, potom
            a^2 = 4k^2 + 4k + 1, teda aj a^2 by bolo nepárne.">[2]</dfn></sup></b>, teda $\bf{a = 2 \cdot c}$. Ak to dosadíme
                do predchádzajúcej rovnice dostaneme $\bf{4 \cdot c^2 = 2 \cdot b^2}$, alebo po úprave
                $\bf{b^2 = 2 \cdot c^2}$ čiže aj číslo $\bf{b}$ je párne. Teda zlomok $\bf{\frac{a}{b}}$ sa dá krátiť, čo
                je v spore s predpokladom.
            </p>
        </div>
        <br>
        <div class="uloha">
            <h3>Úlohy</h3>
            <ol>
                <li>
                    <p>
                        Dokážte, že neexistuje také racionálne číslo $\bf{b}$, pre ktoré platí $\bf{b^2 = p}$ (kde $\bf{p}$
                        je ľubovoľné prvočíslo). (Použite tvrdenie z príkladu 6 z kapitoly 1.1)
                    </p>
                </li>
            </ol>
        </div>
        <br>
        <div class="priklad">
            <h3>Príklad 3.</h3>

            <p>
                Jedným z klasických problémov gréckej matematiky bola tzv. <b>duplicita kocky</b>. Možno ho zjednodušene
                vysloviť takto - zostrojte kocku, ktorej objem je dvojnásobok objemu jednotkovej kocky. Našimi slovami -
                <b>nájdite také číslo $a$, ktorého tretia mocnina je $2$</b>.
            </p>
            <p>
                <details class="detail">
                    <summary class="summary"><b>Grécki matematici na to používali nástroj zvaný križiak, ktorého virtuálnu
                            podobu nájdete tu.</b></summary><br>
                    <div id="xgc34jzb"></div>
                </details></p>

            <p>
                Z podobnosti trojuholníkov vyplýva, že odvesny všetkých trojuholníkov sú v pomere $\bf{1:a}$.
            <div class="center2"><img src="photo/p30.png" alt="kriziak"></div>
            </p>

            <p>
                Otvorte si výkres Križiak a pomocou neho vypočítajte $\bf{\sqrt[3]{2}}$ s presnosťou na desať desatinných miest.
            </p>
            <p><details class="detail">
                    <summary class="summary"><b>križiak</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A1 05" src="https://www.geogebra.org/material/iframe/id/xgc34jzb/width/1280/height/609/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="1280px" height="609px" style="border:0px;"> </iframe>
                    </div> </details></p>

            <p>
                Pri riešení ďalších klasických problémov, ako boli <b>kvadratúra kruhu a rektifikácie kružnice</b>, starí Gréci
                zistili, že čísla vyjadrujúce pomer obsahu kruhu ku obsahu jednotkového štvorca a tiež pomer obvodu kružnice
                k jej priemeru nie sú (v našom označovaní) racionálne.
            </p>
        </div>
        <br>
        <div class="uloha">
            <h3>Úlohy</h3>

            <ol start="2">
                <li>
                    <p>
                        Otvorte si zošit Uhlopriečka a upravte podmienené formátovanie buniek $B5$ až $B15$ tak, aby ste pomocou tohto
                        zošitu mohli demonštrovať postupné spresňovanie výpočtu druhej odmocniny z ľubovoľného prirodzeného čísla.
                        (Ak sa Vám to nepodarí, pozrite si List2.)


                    </p>
                    <p>
                        <details class="detail">
                            <summary class="summary"><b>Uhlopriečka</b></summary><br>
                            <div class="center2"><iframe scrolling="no" title="A1.17a" src="https://www.geogebra.org/material/iframe/id/xdetadjy/width/1000/height/700/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1000px" height="700px" style="border:0px;"> </iframe>
                            </div></details></p>

                    <p>
                        <details class="detail">
                            <summary class="summary"><b>List2</b></summary><br>
                            <div class="center2">
                                <iframe scrolling="no" title="A1.17b" src="https://www.geogebra.org/material/iframe/id/vncd9evt/width/944/height/916/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="916px" style="border:0px;"> </iframe>
                            </div></details></p>



                </li>

                <li>
                    <p>
                        Pomocou zošitu Uhlopriečka vypočítajte druhé odmocniny z prirodzených čísel do $10$ s presnosťou na
                        $10$ desatinných miest.
                    </p>
                    <p>
                        <details class="detail">
                            <summary class="summary"><b>Uhlopriečka</b></summary><br>
                            <div class="center2">
                                <iframe scrolling="no" title="A1.17c" src="https://www.geogebra.org/material/iframe/id/xhzyyabb/width/944/height/400/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="400" style="border:0px;"> </iframe>                                                                                    </div></details></p>
                </li>

                <li>
                    <p>
                        Pomocou Cabri výkresu Križiak vypočítajte s presnosťou na $10$ desatinných miest tretie odmocniny
                        z prirodzených čísel do $10$.
                    </p>
                    <p><details class="detail">
                            <summary class="summary"><b>križiak</b></summary><br>
                            <div class="center2">
                                <iframe scrolling="no" title="A1 05" src="https://www.geogebra.org/material/iframe/id/xgc34jzb/width/1280/height/609/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="1280px" height="609px" style="border:0px;"> </iframe>
                            </div> </details></p>
                </li>

                <li>
                    <p>
                        Doplňte výkres Križiak o ďalší podobný trojuholník tak, aby ste pomocou neho mohli počítať štvrté
                        odmocniny.
                    <p><details class="detail">
                            <summary class="summary"><b>križiak</b></summary><br>
                            <div class="center2">
                                <iframe scrolling="no" title="A1 05" src="https://www.geogebra.org/material/iframe/id/xgc34jzb/width/1280/height/609/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="1280px" height="609px" style="border:0px;"> </iframe>
                            </div> </details></p>
                    </p>
                </li>
            </ol>
        </div>

    </section>

    <div class="pagination">
        <a href="A13_1.php">&laquo;</a>
        <a href="A13_1.php">1</a>
        <a class="active" href="A13_2.php">2</a>
        <a href="A13_3.php">3</a>
        <a href="A13_4.php">4</a>
        <a href="A13_5.php">5</a>
        <a href="A13_3.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"xgc34jzb", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('xgc34jzb');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
