<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA13.html');
?>

<div class="item2">
    <h2>1.3 Diery v číselnej osi alebo iracionálne čísla</h2>

    <section>

        <p>
            Predchádzajúce príklady nás presviedčajú o tom, že <b>racionálne čísla nepostačujú na meranie dĺžok</b>. Inak
            povedané, existujú úsečky, ktorých dĺžka nie je racionálne číslo. Otázka je ako má vyzerať tá množina čísel,
            pomocou ktorej sa dá odmerať ľubovoľná dĺžka. Návod poskytuje grafické sčitovanie a grafické násobenie (pozri
            Q++ a Qx). Tam je výsledok závislý iba na polohe sčítancov (či súčiniteľov) na číselnej osi a nezávisí na tom,
            či sú tieto body (t.j. sčítance, resp. súčinitele) obrazmi racionálnych čísel, alebo nie. Preto hľadaná
            množina čísel by mala byť rovnocenná s množinou <b>všetkých</b> bodov priamky. (T.j. každé číslo by malo práve
            jeden obraz na priamke a každý bod priamky by bol obrazom práve jedného čísla.)
        </p>

        <p>
            <details class="detail">
                <summary class="summary"><b>Q++</b></summary><br>
                <div class="center2" id="ch48w9gu"></div>
            </details></p>

        <p>
            <details class="detail">
                <summary class="summary"><b>Qx</b></summary><br>
                <div class="center2" id="gzsefwhx"></div>
            </details></p>


        <p>
            Takéto intuitívne ponímanie nových čísel dlho postačovalo matematikom na to, aby dosahovali významné objavy.
            Tie čísla, ktoré sa dajú vyjadriť ako zlomok, teda také, ktoré sa dajú vyjadriť ako konečné desatinné číslo,
            alebo nekonečné ale periodické desatinné číslo sú <b>racionálne</b> čísla a čísla, ktoré sa nedajú vyjadriť
            ako zlomok, teda také, ktorých desatinný rozvoj nie je konečný a ani nekonečný periodický, dostali názov
            <b>iracionálne</b>. Nová množina čísel, skladajúca sa z racionálnych aj iracionálnych čísel dostala názov
            <b>reálne čísla</b>. Pojem reálneho čísla matematici
            <sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Dedekind/" target="_blank">
                    <dfn title="Richard Dedekind">1</dfn></a>,
                <a href="https://mathshistory.st-andrews.ac.uk/Biographies/Cantor/" target="_blank"><dfn title='Georg Cantor
           Pozri tiež Štefan Znám a kol.: "Pohľad do dejín matematiky".'>1</dfn></a>
                ]</sup> presne formulovali až v XIX storočí. O tom si povieme
            niečo viac v kapitole <b>Limitné procesy</b>.
        </p>
        <div class="priklad">
            <h3>Príklad 4.</h3>

            <p>
                Otvorme si zošit Uhlopriečka list 1. a zapisujme postupne čoraz menšie intervaly, ktoré ohraničujú číslo,
                ktorého druhá mocnina je 5. Postupným zjemňovaním kroku dostávame: $$\bf{(2 \, ; \, 3), \, (2.2 \, ; \, 2.3),
                \, (2.23 \, ; \,2.24),}$$ $$\bf{(2.236 \, ; \, 2.237), \, (2.2360 \, ; \, 2.2361), \, (2.23606 \, ; \, 2.23607),
                \, ...}$$</p>

            <p>
                <details class="detail">
                    <summary class="summary"><b>Uhlopriečka list 1</b></summary><br>
                    <div class="center2"><iframe scrolling="no" title="A1.17a" src="https://www.geogebra.org/material/iframe/id/xdetadjy/width/1000/height/700/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1000px" height="700px" style="border:0px;"> </iframe>
                    </div></details></p>


            <p>
                Aby sme teda mohli hovoriť o druhej odmocnine (z ľubovoľného čísla, nielen z piatich), musí platiť:
                <b>V množine reálnych čísel existuje jediné číslo, ktoré patrí do všetkých takýmto spôsobom získaných
                    intervalov.</b>
            </p>
        </div>

        <h3>Poznámka 1.</h3>

        <p>
            Posledná vlastnosť je práve tou vlastnosťou, ktorá odlišuje množinu všetkých reálnych čísel (označujeme ju
            $\mathbb{R}$) od množiny $\mathbb{Q}$. Táto vlastnosť nám zaručuje napríklad existenciu ľubovoľnej odmocniny
            z ľubovoľného kladného reálneho čísla:

            $$\bbox[yellow, 5px] {\bf{\forall \, a, b \in \mathbb{R}^+ \forall \, q \in \mathbb{N} : b = \sqrt[q]{a}
            \iff b^q = a \qquad{(DO)}}}$$
        </p>

        <div class="priklad">
            <h3>Príklad 5.</h3>

            <p>
                Spôsob, ako postupne spresňovať hodnotu druhej odmocniny z ľubovoľného kladného čísla realizovaný v zošite
                Uhlopriečka je nešikovný a zdĺhavý. Uvedieme niekoľko ďalších. Vypočítať $\bf{\sqrt{a}}$ znamená vyriešiť
                rovnicu $\bf{x ^ 2 - a = 0}$ (na obrázku sme zvolili $\bf{a = 5}$)

            </p>

            <div class="center2"><img src="photo/p31.png" alt="kriziak"></div>

            <p>
                Najprv zvolíme 1. odhad $\bf{(a_0, b_0)}$ intervalu, v ktorom sa nachádza koreň rovnice $\bf{f(x) = 0}$, (t.j.
                bod, v ktorom graf funkcie $\bf{y = f(x)}$ pretína os $\bf{x}$). Dbáme o to, aby v krajných bodoch nadobúdala
                funkcia hodnoty opačných znamienok, napr. $\bf{f(a_0) \lt 0}$ a $\bf{f(b_0) > 0}$. Interval rozpolíme, vypočítame
                hodnotu v jeho strede a z intervalov $\bf{(a_0,(a_0 + b_0) / 2), ((a_0 + b_0) / 2, b_0)}$ vyberieme ten,
                v ktorého koncových bodoch nadobúda funkcia opačné znamienko. Takto pokračujeme dovtedy, kým nedosiahneme
                požadovanú presnosť. Prvé kroky tejto metódy vidíme na obrázku, priebeh môžeme sledovať v Exceli v 1. liste
                zošitu Odmocnina.


            </p>

            <p>
                <details class="detail">
                    <summary class="summary"><b>Odmocnina list 1</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A1.19a" src="https://www.geogebra.org/material/iframe/id/ekdksvaa/width/1100/height/916/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1100px" height="916px" style="border:0px;"> </iframe>
                    </div></details></p>

        </div>
    </section>

    <div class="pagination">
        <a href="A13_2.php">&laquo;</a>
        <a href="A13_1.php">1</a>
        <a href="A13_2.php">2</a>
        <a class="active" href="A13_3.php">3</a>
        <a href="A13_4.php">4</a>
        <a href="A13_5.php">5</a>
        <a href="A13_4.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
