<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA13.html');
?>

<div class="item2">
    <h2>1.3 Diery v číselnej osi alebo iracionálne čísla</h2>

    <section>
        <div class="priklad">
            <h3>Príklad 6.</h3>
            <p>
                Zaujímavý je nasledovný spôsob výpočtu druhej odmocniny, ktorý je zrejmý z tabuľky:
                $$\begin{array}{|c|c|c|c|}
                \hline \bf{Výpočet \; druhej \; odmocniny \; priemerovaním} \\
                \hline \bf{a =} & \cellcolor{cyan}\bf{12} \\
                \hline \bf{x(0)} & \cellcolor{cyan} \bf{3} & \bf{y(0) = \frac{a}{x(0)} =} & \bf{4} \\
                \hline \bf{x(1) = \frac{x(0) + y(0)}{2} =} & \bf{3.5} & \bf{y(1) = \frac{a}{x(1)} =} & \bf{3.4285714} \\
                \hline \bf{x(2) = \frac{x(1) + y(1)}{2} =} & \bf{3.4642857} & \bf{y(2) = \frac{a}{x(2)} =} & \bf{3.4639175} \\
                \hline \bf{...} & \bf{3.4641016} & \bf{...} & \bf{3.4641016} \\
                \hline \bf{x(n + 1) = \frac{x(n) + y(n)}{2} =} & \bf{3.4641016} & \bf{y(n + 1) = \frac{a}{x(n)} =} & \bf{3.4641016} \\ \hline


                \end{array}$$
            </p>

            <p>
                Začíname s ľubovoľným odhadom $\bf{x(0)}$ druhej odmocniny z $\bf{a}$. Algoritmus má dve pravidlá:
                $$\bf{y(n) = \frac{a}{x(n)} \qquad x(n + 1) = \frac{x(n) + y(n)}{2}}$$
            </p>

            <p>
                Tento algoritmus<b><sup><dfn title="Pozri J. Kukal:  „Myšlením k algoritmům“.">[4]</dfn></sup></b> zarážajúco rýchlo speje k žiadanému výsledku.
            </p>

            <p>
                <details class="detail">
                    <summary class="summary"><b>Pozrite 2. list zošitu Odmocnina</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A1.19b" src="https://www.geogebra.org/material/iframe/id/mh8nj4f7/width/944/height/600/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="600px" style="border:0px;"> </iframe>
                    </div></details></p>

        </div><br>

        <div class="priklad">
            <h3>Príklad 7.</h3>

            <p>
                Jeden, vám iste známy anglický fyzik a matematik Isaac Newton<sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Newton/" target="_blank"><dfn title="Isaac Newton.">5</dfn></a>]</sup>,
                uvažoval asi takto:
            <ol>
                Vypočítať $\bf{\sqrt{a}}$ znamená vyriešiť rovnicu: $\bf{x^2 = a \qquad (1)}$
            </ol>
            </p>

            <p>
                Snažme sa ju vyriešiť tým spôsobom, že budeme postupne „vyrábať“ čísla, ktoré sa čím ďalej, tým menej líšia od želaného
                výsledku. Nech $\bf{x_n}$ je n-té priblíženie sa k výsledku. Ďalšie, lepšie priblíženie $\bf{x_{n + 1}}$ budeme hľadať
                v tvare $\bf{x_{n+1} = x_n + \varepsilon}$, kde $\bf{\varepsilon}$ je malé reálne číslo.
            </p>



            <p>
                Ak $\bf{x_{n + 1}}$ dosadíme za $\bf{x}$ do $(1)$ postupne dostávame:
            <ol>$\bf{(x_n + \varepsilon)^2 = a \qquad x_n^2 + 2 \cdot x_n \varepsilon + \varepsilon^2 = a \qquad (2) }$</ol>
            </p>

            <p>
                Keďže sa chceme vyhnúť odmocňovaniu a stačí nám približné riešenie, ale lepšie ako $\bf{x_n}$ a vzhľadom na to,
                že $\varepsilon$ je malé číslo, môžeme posledného sčítanca zanedbať. Potom dostávame:
            <ol>$\bf{\varepsilon = \frac{a - x_n^2}{2 \cdot x_n} }$ resp. $\bf{x_{n+1} = \bbox[yellow, 5px]{\frac{x_n^2 + a}{2 \cdot x_n}}
                \qquad (3)}$<sup><dfn title="Takémuto vzťahu hovoríme rekurentný (od gréckeho rekurere = bežať dozadu).">[6]</dfn></sup></ol>
            </p>

            <p>
                Postupný výpočet približnej hodnoty druhej odmocniny z nezáporného reálneho čísla $\bf{a}$ podľa tohto rekurentného
                vzťahu môžeme sledovať pomocou 1. hárku zošitu odmocnina 2. Pravdepodobne vás prekvapí rýchlosť, s akou
                sa tento algoritmus približuje k výsledku.
            </p>
            <p>
                <details class="detail">
                    <summary class="summary"><b>1. hárok zošitu odmocnina 2</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A1.20a" src="https://www.geogebra.org/material/iframe/id/uy6pf795/width/944/height/600/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="600px" style="border:0px;"> </iframe>
                    </div></details></p>

            <p>
                Túto Newtonovu metódu používa aj vaša kalkulačka pri použití tlačidla SQRT.
            </p>
        </div>
        <br>

        <div class="priklad">
            <h3>Príklad 8. </h3>
            <p>
                Postup uvedený v predchádzajúcom príklade je taký zaujímavý, že si ho prispôsobíme na výpočet 3. odmocniny.
            </p>

            <p>
                Vypočítať $\bf{\sqrt[3]{a} }$ znamená vyriešiť rovnicu: $\bf{x^3 = a \; (a \in R) \qquad (4)}$
            </p>

            <p>
                Opäť budeme postupne „vyrábať“ čísla, ktoré sa čím ďalej, tým menej líšia od želaného výsledku.
                Nech $\bf{x_n}$ je n-té priblíženie sa k výsledku. Ďalšie, lepšie priblíženie $\bf{x_{n+1}}$ budeme hľadať v tvare
                $\bf{x_{n+1} = x_n + \varepsilon}$, kde $\varepsilon$ je malé reálne číslo.
            </p>

            <p>
                Ak $\bf{x_{n+1}}$ dosadíme za $\bf{x}$ do $(1)$ dostávame:
            <ol>$\bf{(x_n + \varepsilon)^3 = x_n^3 + 3 \cdot x_n^2 \varepsilon + \bbox[lime, 5px]{\varepsilon^2} (3 \cdot x_n + \varepsilon) = a \qquad (5)}$</ol>
            </p>

            <p>
                Keďže sa chceme vyhnúť odmocňovaniu a stačí nám približné riešenie, ale lepšie ako $\bf{x_n}$ a vzhľadom na to,
                že $\varepsilon$ a tobôž $\bbox[lime, 5px]{\varepsilon^2}$ je malé číslo, môžeme sčítance obsahujúce mocniny čísla
                $\varepsilon$ s exponentom väčším ako $1$ zanedbať. Potom dostávame: <br>
                $$\bf{\varepsilon = \frac{a - x_n^3}{3 \cdot x_n^2} } \; resp. \; \bf{x_{n+1} = \bbox[yellow, 5px]{\frac{2 \cdot x_n^3 + a}{3 \cdot x_n^2}} \qquad (6) }$$
            </p>

            <p>
                Postupný výpočet približnej hodnoty tretej odmocniny z nezáporného reálneho čísla $\bf{a}$ podľa tohto rekurentného vzťahu
                môžete sledovať pomocou EXCELU v 2. hárku zošitu odmocnina 2. Aj tento algoritmus sa približuje k výsledku veľkou rýchlosťou.
            </p>

            <p>
                <details class="detail">
                    <summary class="summary"><b>2. hárok zošitu odmocnina 2</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A1.20b" src="https://www.geogebra.org/material/iframe/id/zxrqvqbj/width/944/height/600/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="600px" style="border:0px;"> </iframe>
                    </div></details></p>

            <p>
                Vašou úlohou bude zovšeobecniť tento postup na výpočet ľubovoľnej odmocniny.
            </p>

        </div>

    </section>

    <div class="pagination">
        <a href="A13_3.php">&laquo;</a>
        <a href="A13_1.php">1</a>
        <a href="A13_2.php">2</a>
        <a  href="A13_3.php">3</a>
        <a class="active" href="A13_4.php">4</a>
        <a href="A13_5.php">5</a>
        <a href="A13_5.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
