<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA13.html');
?>

<div class="item2">
    <h2>1.3 Diery v číselnej osi alebo iracionálne čísla</h2>

    <section>
        <div class="uloha">
            <h3>Úlohy</h3>

            <ol start="6">
                <li>
                    <p>
                        Podľa postupu popísaného v predchádzajúcich dvoch príkladoch sa pokúste nájsť rekurentný vzťah pre výpočet
                        q – tej odmocniny, podobný vzťahom $(3)$ a $(6)$. Pomocou takto získaného vzorca v zošite odmocnina 2.
                        urobte v 3. hárku postup na výpočet ľubovoľnej odmocniny z ľubovoľného kladného čísla. (Kto je lenivý a
                        chce prísť o zážitok z vlastnej práce, môže si to pozrieť v 4. hárku tohto zošitu.)
                    </p>

                    <p>
                        <details class="detail">
                            <summary class="summary"><b>3. hárok zošitu odmocnina 2</b></summary><br>
                            <div class="center2">
                                <iframe scrolling="no" title="A1.20c" src="https://www.geogebra.org/material/iframe/id/js7dtrrx/width/1200/height/600/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1200px" height="600px" style="border:0px;"> </iframe>
                            </div></details></p>
                </li>

                <li>
                    <p>
                        Otvorte si zošit Výpočet mocniny a pomocou neho urobte postupné odhady čísla $\bf{(\sqrt{3})^\sqrt{2}}$.

                        <br><br>
                        <a href="excel/A1.21.xlsx" download="excel/A1.21.xlsx">Výpočet mocniny - na stiahnutie</a>
                    </p>

                </li>

                <li>
                    <p>
                        Lepšie si všimnite algoritmy na výpočet 2. odmocniny popísané v príkladoch 6. a 7. Dokážte, že sú zhodné
                        (t. j. dávajú pri rovnakých vstupoch rovnaké postupné výsledky).
                    </p>
                </li>
            </ol>
        </div>

        <h3><mark>Poznámka 2.</mark></h3>
        <p>
            Hĺbavý matematik by sa nemal uspokojiť s tým, že vzťah $\bf{x_{n+1} = \bbox[yellow, 5px]{\frac{x_n^2 + a}{2 \cdot x_n}}}$
            v každom sledovanom prípade vedie rýchle k „výsledku“. Čo vlastne zaručuje, že napr. pri výpočte odmocniny
            z čísla $5$ postupnosť čísel ktorá začína napr. číslom $\bf{5}$ a pokračuje $\bf{3, \frac{7}{3}, \frac{47}{21}, ...}$
            sa čím ďalej tým viac približuje k nejakému konkrétnemu číslu?
        </p>

        <h3><mark>Poznámka 3.</mark></h3>
        <p>
            Množstvo ďalších zaujímavostí o odmocninách a nielen o nich sa môžete dozvedieť na www stránke:
        <ol><a href="http://mathforum.org/dr.math/" target="_blank">http://mathforum.org/dr.math/</a></ol>

        </p>

        <div class="priklad">
            <h3>Príklad 9. (O presnosti výpočtov.)</h3>
            <p>
                Moja kalkulačka zobrazuje maximálne 8 cifier vloženého, alebo vypočítaného čísla. Za koľko cifier výsledku výpočtu
                $\bf{(\pi + \sqrt{2})^3}$ môžem ručiť ?
            </p>

            <h3>Riešenie:</h3>
            <p>
                Fakt $\bf{\pi \sim 3.1415927}$ znamená, že $\bf{\pi \in \langle 3.1415927 - 0.00000005; 3.1415927 + 0.00000005 \rangle}$
            </p>

            <p>
                <b>Fakt $\bf{\sqrt{2} \sim 1.4142136 }$ znamená, že</b>
                $$\bf{\sqrt{2} \in \langle 1.4142136 - 0.00000005; 1.4142136 + 0.00000005 \rangle }$$
            </p>

            <p>
                Preto $\bf{\pi + \sqrt{2} \in \langle 4.5558063 - 0.0000001; 4.5558063 + 0.0000001 \rangle }$
            </p>

            <p>
                Podobne ak $\bf{a = a_0 \pm \Delta}$, tak $\bf{a^3 = (a_0 \pm \Delta)^3 = a_0^3 \pm 3 \Delta a_0^2 + \bbox[yellow, 5px]{3 \Delta^2a_0 \pm \Delta^3}}$ teda
            </p>

            <p>
                $\bf{a^3 = a_0^3 \pm 3 \Delta a_0^2}$, tak $\bf{a^3 = a_0^3 \pm 3 \Delta a_0^2 }$ lebo žlto podfarbené číslo možno pre jeho nepatrnosť zanedbať.
            </p>

            <p>
                Preto $\bf{(\pi + \sqrt{2})^3 = 94.55745 \pm 0.0000062}$. Za poslednú cifru nemožno ručiť, lebo chyba je viac ako polovica nasledujúcej jednotky, takže
                $\bf{(\pi + \sqrt{2})^3 \sim 94.5575 }$ (pritom kalkulačka dala výsledok $\bf{94.557445}$)
            </p>
        </div>

        <h3><mark>Poznámka.</mark></h3>
        <p>
            Toto by bola pravda, keby sme z kalkulačky (alebo z tabuliek ako kedysi) odpísali hodnoty $\bf{\pi a \sqrt{2}}$ a
            potom už pokračovali vo výpočte ručne. Dobré kalkulačky si pamätajú o cca 3 cifry čísla viac, než zobrazia na displeji
            a preto im možno „väčšinou“ veriť. Prečo iba „väčšinou“? Zvoľte si číslo $\bf{1,000001}$, potom z neho urobte desiatu
            odmocninu (zobrazí sa vám 1) a potom výsledok umocnite na desiatu. Ak bude konečný výsledok $\bf{1}$ a nie $\bf{1,000001}$
            , usvedčili ste svoju kalkulačku z nepresnosti.
        </p>

    </section>

    <div class="pagination">
        <a href="A13_4.php">&laquo;</a>
        <a href="A13_1.php">1</a>
        <a href="A13_2.php">2</a>
        <a  href="A13_3.php">3</a>
        <a href="A13_4.php">4</a>
        <a class="active" href="A13_5.php">5</a>
        <a href="A13_1.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
