<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA14.html');
?>

<div class="item2">
    <h2>1.4 Bombelli<sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Bombelli/" target="_blank">
                <dfn title="Rafael Bombelli">1</dfn></a>]</sup>
        alebo komplexné čísla</h2>

    <section>
        <p>
            Existuje jeden didaktický problém. Patrí poučenie o komplexných číslach do tej časti stredoškolskej matematiky,
            ktorú majú poznať všetci žiaci? V reálnom živote ich budú potrebovať len profesionálni matematici (vrátane
            niektorých učiteľov matematiky) a špičkoví výskumní pracovníci. Pozrime sa stručne na históriu vzniku
            komplexných čísel, možno tam nájdeme odpoveď na našu otázku.
        </p>

        <p>
            Riešenie rovníc tretieho stupňa dnes už málokto považuje za problém. Ak máme vyriešiť napríklad rovnicu:
            $$\bf{x^3 + 6 \cdot x^2 + 6 \cdot x + 5 = 0} \qquad{(1)}$$
            a stačí nám približné riešenie, máme viacero možností:
        </p>

        <li>
            otvoriť EXCEL, pripraviť si Hornerovu schému pre výpočet hodnôt polýnomu 3. stupňa: dosadiť za $\bf{x}$
            ľubovoľnú hodnotu a pomocou nástroja "riešiteľ" nájsť takú hodnotu premennej $\bf{x}$, pre ktorú bude
            hodnota poslednej bunky rovná nule
            <p>
                <details class="detail">
                    <summary class="summary"><b>pozrite si Bombelli</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A1.22" src="https://www.geogebra.org/material/iframe/id/shqt6ywg/width/944/height/400/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="944px" height="400px" style="border:0px;"> </iframe>
                    </div> </details></p>
        </li>

        <li>


            Pomocou vhodného kresliča grafov, si môžeme nakresliť graf funkcie
            $\bf{y = x^3 + 6 \cdot x^2 + 6 \cdot x + 5}$ a nájsť jeho priesečník s osou x.



            <p><details class="detail">
                    <summary class="summary"><b>pozrite si G01</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="G01" src="https://www.geogebra.org/material/iframe/id/uhbucmcv/width/1280/height/609/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1280px" height="609px" style="border:0px;"> </iframe>
                    </div> </details></p>


        </li>

        <p>
            Pokúsme sa sledovať, ako riešili kubické rovnice talianski matematici na prelome 15. a 16. storočia.
        </p>

        <p>
            Najprv sa snažili odstrániť kvadratický člen. Namiesto premennej $\bf{x}$ vložili novú premennú, t.j. použili
            substitúciu.

            $$\bf{x = y + a}\qquad{(K)}$$

            a to takú, aby nový výraz s premennou $\bf{y}$ už neobsahoval kvadratický člen. Po úpravách výrazu na ľavej
            strane rovnice dostaneme:

            $$\bf{(y + a)^3 + 6 \cdot (y + a)^2 + 6 \cdot (y + a) + 5 =}$$
            $$\bf{y^3 + 3a \cdot y^2 + 3a^2 \cdot y + a^3 + 6 \cdot y^2 + 12a \cdot y + 6a^2 + 6\cdot y + 6a + 5 =}$$
            $$\bf{y^3 + (3a + 6) \cdot y^2 + (3a^2 + 12a + 6) \cdot y + a^3 + 6a^2 + 6a + 5}$$
        </p>

        <p>
            Ak položíme $\bf{a = - 2}$, tak po substitúcii
            <mark style="background-color: yellow"> $\bf{x = y - 2}$</mark>
            dostávame novú rovnicu:

            $$\bf{y^3 - 6 \cdot y + 9 = 0} \qquad{(2)}$$

            ktorá už neobsahuje kvadratický člen.
        </p>

        <p>
            Komu ako prvému prišla na um myšlienka urobiť ďalšiu substitúciu:

            $$\bf{y = u + v} \qquad{(S1)}$$

            už asi nezistíme, ale po tejto, zatiaľ "neurčitej" substitúcii (neurčitej preto, že síce poskytuje možnosť
            zo známych hodnôt $\bf{u, v}$ vypočítať hodnotu $\bf{y}$, ale nie naopak) postupne dostávame:

            $$\bf{(u + v)^3 - 6(u + v) + 9 = 0}$$
            $$\bf{u^3 + v^3 + 3u^2v + 3uv^2 - 6(u + v) + 9 = 0}$$
            $$\bf{u^3 + v ^3 + 3uv(u + v) - 6(u + v) + 9 = 0}$$
            $$\bf{u^3 + v ^3 + (3uv - 6)(u + v) + 9 = 0 \qquad{(3)}}$$
        </p>

        <p>
            Teraz využijeme fakt, že substitúcia $S1$ nebola úplná. Doplníme ju o ďalšiu podmienku pre premenné $\bf{u, v}$
            a to tak, aby sa rovnica $3$ čo najviac zjednodušila. Pretože položíme
            $$\bf{3uv = 6 \qquad{(S2)}}$$

        <ol>

            takže dostávame rovnicu:

            $$\bf{u^3 + v^3 = -9 \qquad{(4)}}$$
        </ol>
        </p>

        <p>
            Všimnime si posledné dve rovnice. Možno by z nich šlo vypočítať neznáme $\bf{u, v}$. Stačí rovnice napísať
            v tvare:

            $$\bf{u^3 \cdot v^3 = 8}$$
            $$\bf{u^3 \cdot v^3 = - 9}$$

        <ol>
            a vidíme, že čísla $\bf{u^3, v^3}$ sú koreňmi kvadratickej rovnice:

            $$\bf{t^2 + 9t + 8 = 0 \qquad{(R)}}$$
        </ol>
        </p>

        <p>
            Jej diskriminant je $\bf{49}$ a hľadané korene sú: $\bf{u^3 = -1, \, v^3 = -8}$. Teda $\bf{u = -1, \, v = -2}$ a
            $\bf{y = u + v = -3}$
        </p>

        <p>
            Pôvodná rovnica $(1)\, \bf{x^3 + 6 \cdot x^2 + 6 \cdot x + 5 = 0}$ má koreň $\bf{x = y - 2 = -5}$ o čom sa môžeme
            presvedčiť pomocou Hornerovej schémy:

            $$\begin{array}
            {|c|c|}
            \hline & 1 & 6 & 6 & 5 \\
            \hline -5 & 1 & 1 & 1 & 0\\
            \hline
            \end{array}$$
        </p>

        <p>
            Navyše sme zistili, že $\bf{x^3 + 6 \cdot x^2 + 6 \cdot x + 5  = (x + 5) \cdot (x^2 + x + 1)}$, takže číslo
            $\bf{-5}$ je jediným reálnym koreňom rovnice $(1)$.
        </p>

        <p>
            Pre vtedajších matematikov tento spôsob riešenia bol "ars magna", čiže "veľké umenie" a starostlivo si ho
            strážili.
        </p>

        <p>
            Navyše nie vždy fungoval. Boli také rovnice ako napríklad:

            $$\bf{x^3 - 12 \cdot x + 16 = 0 \qquad(5)}$$

            kde po substitúcii $\bf{x = u + v}$ vznikla rovnica:

            $$\bf{(u + v)^3 - 12(u + v) + 16 = 0}$$
            $$\bf{u^3 + v^3 + 3u^2v + 3uv^2 - 12(u+v) + 16 = 0}$$
            $$\bf{u^3 + v^3 + (3uv - 12)(u + v) + 16 = 0}$$
        </p>

        <p>
            Po doplnení o ďalšiu podmienku pre premenné $\bf{u, v}$

            $$\bf{3uv = 12}$$

            Dostávame rovnicu:

            $$\bf{u^3 + v^3 = -16}$$

            Ak posledné dve rovnice napíšeme v tvare:

            $$\bf{u^3 \cdot v^3 = 64}$$
            $$\bf{u^3 + v^3 = - 16}$$

            vidíme, že čísla $\bf{u^3, v^3}$ sú koreňmi kvadratickej rovnice:

            $$\bf{t^2 + 16t + 64 = 0}$$

            Jej diskriminant je $\bf{0}$ a hľadané korene sú: $\bf{u^3 = v^3 = -8}$.
            Teda $\bf{u = v = -2}$ a $\bf{x = u + v = -4}$
        </p>

    </section>

    <div class="pagination">
        <a href="A14_3.php">&laquo;</a>
        <a class="active" href="A14_1.php">1</a>
        <a href="A14_2.php">2</a>
        <a  href="A14_3.php">3</a>

        <a href="A14_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
