<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA14.html');
?>

<div class="item2">
    <h2>1.4 Bombelli<sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Bombelli/" target="_blank">
                <dfn title="Rafael Bombelli">1</dfn></a>]</sup>
        alebo komplexné čísla</h2>

    <section>
        <p>
            Ak použijeme Hornerovu schému:

            $$\begin{array}
            {|c|c|}
            \hline & 1 & 0 & -12 & 16 \\
            \hline -4 & 1 & -4 & 4 & 0\\
            \hline
            \end{array}$$

            Tak zisťujeme, že

            $$\bf{x^3 - 12 \cdot x + 16 = (x + 4) \cdot (x^2 - 4x + 4) = (x + 4) \cdot (x - 2) \cdot (x - 2)}$$

            čiže číslo $\bf{-4}$ nie je jediným koreňom rovnice. Aj číslo $\bf{2}$ je koreňom rovnice $(5)$, dokonca tzv.
            dvojnásobným.

        <p><details class="detail">
                <summary class="summary"><b>pozrite si G02</b></summary><br>
                <div class="center2">
                    <iframe scrolling="no" title="G02" src="https://www.geogebra.org/material/iframe/id/h3jxksgz/width/1280/height/609/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1280px" height="609px" style="border:0px;"> </iframe>
                </div> </details></p>

        <div id="h3jxksgz"></div>

        </p>

        <p>
            Neriešiteľným sa zdal prípad, keď rovnica očividne mala riešenie, ale hore uvedený spôsob viedol do slepej
            uličky. Pozrime sa na rovnicu:

            $$\bf{x^3 - 6 \cdot x + 4 = 0 \qquad (6)}$$
        </p>

        <p>
            Po substitúcii $\bf{x = u + v}$ už zaužívaným spôsobom dostávame:

            $$\bf{u^3 + 3uv(u + v) + v^3 - 6 (u + v) + 4 = 0}$$
            $$\bf{3uv - 6 = 0, uv = 2}$$
            $$\bf{u^3 + v^3 = -4}$$
            $$\bf{u^3 \cdot v^3 = 8}$$
        </p>

        <p>
            Teda čísla $\bf{u^3, v^3}$ sú koreňmi kvadratickej rovnice $\bf{t^2 + 4 \cdot t + 8 = 0}$ tá však nemá riešenie,
            lebo jej diskriminant je záporný ($\bf{-16}$). Napriek tomu ale rovnica $(6)$ očividne má korene, ak si všimneme
            graf G03 funkcie $\bf{y = x^3 - 6 \cdot x + 4}$ bezprostredne vidíme, že jeden koreň je číslo $2$.
        <p><details class="detail">
                <summary class="summary"><b>pozrite si G03</b></summary><br>
                <div class="center2">
                    <iframe scrolling="no" title="G03" src="https://www.geogebra.org/material/iframe/id/fuzgwx9x/width/1280/height/609/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1280px" height="609px" style="border:0px;"> </iframe>
                </div> </details></p>
        Použitím
        Hornerovej schémy dostávame:

        $$\begin{array}
        {|c|c|}
        \hline & 1 & 0 & -6 & 4 \\
        \hline 2 & 1 & 2 & -2 & 0\\
        \hline
        \end{array}$$
        </p>

        <p>
            Tak zisťujeme, že

            $$\bf{x^3 - 6 \cdot x + 4 = (x - 2) \cdot (x^2 + 2x - 2) =}$$
            $$\bf{= (x - 2) \cdot (x + 1 + \sqrt{3}) \cdot (x + 1 - \sqrt{3})}$$

            čiže rovnica $(6)$ napriek tomu, že náš spôsob riešenia naznačuje, že nemá riešenie, má tri rôzne korene.
        </p>

        <p>
            Pozrime sa na tento problém všeobecne. Ak riešime rovnicu

            $$\bf{x^3 + p \cdot x + q = 0 \qquad (7)}$$

            tak po substitúcii $\bf{x = u + v}$ dostávame:

            $$\bf{u^3 + v^3 + (3uv + p)(u + v) + q = 0}$$

            ak dodatočne určíme substitúciu vzťahom $\bf{uv = - \frac{p}{3}}$ dostaneme dve rovnice:

            $$\bf{u^3 + v^3 = -q,}$$
            $$\bf{u^3v^3 = - \biggl (\frac{p}{3} \biggr )^3}$$

            takže čísla $\bf{u^3, v^3}$ sú koreňmi kvadratickej rovnice:

            $$\bf{t^2 + q \cdot t - \biggl (\frac{p}{3} \biggr )^3 = 0}$$
        </p>

        <p>
            Ak je diskriminant $\bf{q^2 + 4 \cdot (\frac{p}{3})^3 }$ nezáporný, dostávame:
            $$\bf{u^3, v^3 = \frac{-q \pm \sqrt{q^2 + \biggl(\frac{p}{3}\biggr)^3}}{2} = \bbox[lime, 5px]{- \frac{q}{2} \pm \sqrt{\biggl(\frac{q}{2}\biggr)^2 + \biggl(\frac{p}{3}\biggr)^3 }  } }$$
            čo je známe pod názvom <b>Cardanov<sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Cardan/" target="_blank"><dfn title="Girolamo Cardano.">2</dfn></a>]</sup> vzorec</b>.
        </p>

    </section>

    <div class="pagination">
        <a href="A14_1.php">&laquo;</a>
        <a href="A14_1.php">1</a>
        <a class="active"  href="A14_2.php">2</a>
        <a  href="A14_3.php">3</a>

        <a href="A14_3.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
