<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA14.html');
?>

<div class="item2">
    <h2>1.4 Bombelli<sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Bombelli/" target="_blank">
                <dfn title="Rafael Bombelli">1</dfn></a>]</sup>
        alebo komplexné čísla</h2>

    <section>
        <p>
            Zaujímavé je, že ak je výraz $\bf{\Bigl(\frac{q}{2}\Bigr)^2 + \Bigl(\frac{p}{3}\Bigr)^3 }$:

            <ul>
                <li>
        <p>
            kladný, tak rovnica $(7)$ má jediný (reálny) koreň,
        </p>
        </li>

        <li>
            <p>
                nulový, tak rovnica $(7)$ má dva korene, z toho jeden tzv. dvojnásobný,
            </p>
        </li>

        <li>
            <p>
                záporný, tak rovnica $(7)$ má tri rôzne reálne korene.
            </p>
        </li>
        </ul>



        <p>
            Svedčia o tom naše konkrétne ukážky, ale neskôr dokážeme že graf funkcie:

        <ol>$\bf{y = x^3 + p \cdot x + q}$</ol>

        pretne os x v troch rôznych bodoch práve vtedy, ak má táto funkcia dva lokálne extrémy a funkčné hodnoty
        v nich majú opačné znamienko.
        </p>

        <p>
            Ak by sme v našom poslednom príklade rovnice
        <ol>$\bf{x^3 - 6 \cdot x + 4 = 0}$</ol>
        použili Cardanove vzorce, dostali by sme:
        <ol>$\bf{u^3, v^3 = -2 \pm \sqrt{-4} = -2 \pm 2 \sqrt{-1} \qquad (8) }$</ol>
        </p>

        <p>
            Tento prípad (nazvali ho „casus irreducibilis“) bol pre našich predkov nevysvetliteľný. Pri riešení
            rovníc, ktoré mali očividne tri korene, narazili na výrazy, ktoré nemajú zmysel, konkrétne na odmocniny
            zo záporných čísel. Až <b>Rafael Bombelli</b> dostal podobný nápad ako Kolumbus (keď mal tento postaviť
            vajce na stôl tak, aby pevne stálo, tresol s ním o stôl, takže sa rozbilo, ale stálo):
        </p>

        <p>
            <b>„Ak sa pri riešení rovníc 3. stupňa nemôžeme zaobísť bez používania výrazov, ktoré nemajú zmysel, tak treba tieto výrazy používať“.</b>
        </p>

        <p>
            Vo svojej knihe „Algebra“, ktorá vyšla až v roku 1572, rok pred jeho  smrťou, prvý popísal ako sčitovať a
            násobiť tieto „výrazy bez zmyslu“.
        </p>

        <p>
            Aby nás odmocniny zo záporných čísel zbytočne „nedráždili“, začal <b>L. Euler</b><sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Euler/" target="_blank"><dfn title="Leonhard Euler.">3</dfn></a>]</sup> používať pre $\bf{\sqrt{-1}}$
            používať symbol $\bf{i}$, (od slova imaginárny, obrazný) a výrazy typu $\bf{a + b \cdot i}$
            (kde $\bf{a, b}$ sú reálne čísla) dostali názov <b>komplexné čísla</b>. S výrazmi $\bf{a + b \cdot i}$
            sa narábalo ako s normálnymi reálnymi číslami, len pre narábanie s výrazom $\bf{i}$ platilo:
        <ol>$\bf{i \cdot i = -1}$</ol>
        </p>

        <p>
            Teda $\bf{(a + b \cdot i) + (c + d \cdot i) = (a + b) + (c + d) \cdot i}$
        <ol> $\bf{(a + b \cdot i) \cdot
            (c + d \cdot i) = (ac - bd) + (ad + bc) \cdot i}$ </ol>

        </p>

        <p>
            Náš problém daný vzťahom $(8)$ je nájsť také čísla  $\bf{u, v}$, pre ktoré $\bf{u^3, v^3 = -2 \pm 2i}$
        </p>

        <p>
            Ak skúsime umocňovanie na „vhodných“ príkladoch:
            $$\begin{align}
            &\bf{(1 + i)^2 = 1 + 2i + i^2 = 2i} \\
            &\bf{(1 + i)^3 = 2i \cdot (1 + i) = 2i + 2i^2 = -2 + 2i} \\
            &\bf{(1 - i)^2 = 1 - 2i + i^2 = -2i} \\
            &\bf{(1 - i)^3 = -2i \cdot (1 - i) = -2i + 2i^2 = -2 -2i}
            \end{align}$$

            vidíme, že riešením problému (pozri $(8)$ z predchádzajúcej strany) sú čísla $\bf{u = 1 + i, v = 1 – i}$,
            teda jedným koreňom rovnice
        <ol>$\bf{x^3 - 6 \cdot x + 4 = 0}$</ol>
        je číslo $\bf{x = u + v = (1 + i) + (1 - i) = 2}$, čo je v zhode s tým, čo sme získali požitím technológií.
        </p>

        <p>
            V závere ukážeme len myšlienku dvoch ľudí, <b>C. F. Gaussa</b> a <b>J. R. Arganda <sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Argand/" target="_blank">
                        <dfn title="Jean Argand">4</dfn></a>]</sup></b> – znázorňovať komplexné
            čísla ako body roviny. Presnejšie, komplexnému číslu $\bf{a + b \cdot i}$ priradíme bod roviny, ktorého
            súradnice sú $\bf{[a ; b]}$. Ako vyzerá v tejto interpretácii sčitovanie a násobenie komplexných čísel,
            si môžete pozrieť v cabri výkresoch C, + a C, x.
            <details class="detail">
                <summary class="summary"><b>C, +</b></summary><br>
                <div class="center2" id="ryzhputj"></div>
            </details>

            <details class="detail">
                <summary class="summary"><b>C, x</b></summary><br>
                <div class="center2" id="rnsu8pvm"></div>
            </details>

        </p>

        <p>
            Mohli by sme ukázať ako pokračoval vývoj pojmu komplexného čísla, ukazovať príklady použitia komplexných čísel
            na popis zhodných a podobných zobrazení v rovine, ukázať aplikácie komplexných čísel v elektrotechnike pri riešení
            obvodov so striedavými prúdmi, v aerodynamike (schopnosť používať konformné zobrazenia pri transformácii
            aerodynamických profilov), pri riešení problémov konvergencie nekonečných radov, či určovaní okrajových podmienok
            pri riešení diferenciálnych rovníc<sup><dfn title="Všetko nájdete v skvelej knihe Budden: „Complex Numbers and their Applications“.">[5]</dfn></sup>.
            Avšak to už je určené len veľmi úzkej skupine ľudí.
        </p>

        <p>
            Ale komplexné čísla, presnejšie história ich vzniku, sú aj ukážkou schopností ľudského ducha. Objav komplexných
            čísel je o to pozoruhodnejší, že komplexné čísla sa vymykajú z bežného chápania pojmu čísla, pretože, ľudovo
            povedané, sa nimi nič nemeria. Nepatrí objav komplexných čísel, história ich vzniku tak isto do pokladnice
            svetovej kultúry ako dielo Bombelliho súčasníka Michelangela Buonarottiho? Iste patrí, obe diela obohatili pojem
            „človek“ o novú kvalitu. Takže, preto sa patrí niečo vedieť o komplexných číslach.
        </p>

    </section>

    <div class="pagination">
        <a href="A14_2.php">&laquo;</a>
        <a href="A14_1.php">1</a>
        <a href="A14_2.php">2</a>
        <a class="active" href="A14_3.php">3</a>

        <a href="A14_1.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ryzhputj", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"rnsu8pvm","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ryzhputj');
        applet2.inject('rnsu8pvm');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
