<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA21.html');
?>

<div class="item2">
    <h2>2.1 Premenná</h2>

    <section>
        <p>
            Jazyk matematiky <sup><dfn title='Termínom jazyk tu rozumieme ľubovoľný systém znakov, prostredníctvom ktorých
                    sa uskutočňuje myslenie a komunikácia(Milan Hejný a kolektív:"Teória vyučovania matematiky 2.")'>[1]</dfn></sup>
            sa vyvíja a etapy jeho vývoja sú aj etapami vývoja matematiky <sup><dfn title='Pozri Ladislav Kvasz:
                    "Gramatika zmeny".'>[2]</dfn></sup>. Cesta viedla od primitívneho záznamu nejakého množstva najprv pomocou
            vrypov, alebo kôpok kamienkov, až po zápis čísla pomocou číslic v pozičnej číselnej sústave, cez jazyk receptov
            na výpočet plôch a objemov v Mezopotámii a v Egypte, cez starogrécky jazyk geometrie, čiže zostrojovanie
            úsečiek, ktorých dĺžka je závislá od dĺžok daných úsečiek, cez prvé pokusy označovať neznámu veličinu
            písmenom <b>r</b> (od prvého písmena latinského slova <b>res</b> - po slovensky vec), až po <b>Viétovu</b>
            <sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Viete/" target="_blank">
                    <dfn title="Francois Viéte">3</dfn></a>]</sup>
            ideu používať písmená aj pre označovanie ľubovoľných čísel. To posledné oddelilo <b>aritmetiku</b>
            (narábanie s číslami) od <b>algebry</b> (narábanie so symbolmi).
        </p>

        <p>
            Označovanie neznámej (<b>premennej</b>) veličiny písmenom a <b>Descartesov</b> objav používať čísla
            (respektíve dvojice či trojice čísel) na určovanie polohy, rozviazali matematikom ruky pri vyjadrovaní
            vzťahov a závislostí medzi veličinami reálneho sveta. Dôležitosť tohto faktu trvá aj dnes v dobe rozvoja
            najrôznejších technológií. Počítač s pomocou vhodného softvéru je účinný nástroj pri riešení rovníc, vie
            znázorniť priebeh ľubovoľnej závislosti (dvoch alebo i viacero) veličín, ale objaviť túto závisloť,
            vyjadriť hľadaný vzťah medzi veličinami ako nejakú funkciu, zostaviť rovnicu, ktorú treba vyriešiť, to
            dokáže (i keď mnohokrát tiež s pomocou počítačov) len človek.
        </p>

        <p>
            V nasledujúcich príkladoch a úlohách vás chceme presvedčiť, že schopnosť vyjadriť hľadanú závislosť,
            schopnosť vhodne si zvoliť premennú, patrí v dobe informačných a komunikačných technológií medzi
            najdôležitejšie kompetencie (matematicky) vzdelaného človeka.
        </p>

        <div class="priklad">
            <h3>Príklad 1.</h3>
            <p>
                Na obrázku vidíme obdĺžnik $\bf{ABCD}$ s rozmermi $\bf{AB = a}$, $\bf{AD = b}$ a úsečku $\bf{XY}$,
                ktorá prechádza bodom $\bf{C}$ a jej koncové body ležia na polpriamkach $\bf{AB}$ a $\bf{AD}$.
                Vyjadrite dĺžku úsečky $\bf{XY}$.
            </p>
            <div class="center2"><img src="photo/p33.png" alt="obrazky"></div>

            <p>Ako vhodné premenné na vyjadrenie dĺžky úsečky $\bf{XY}$ sa núkajú:
            <ol>
                <li>Dĺžka ${x}$ úsečky $\bf{BX}$</li>
                <li>Veľkosť $\bf{\varphi}$ uhla $\bf{AXY}$</li>
            </ol>
            </p>

            <p>
                V 1. prípade ak označíme ${|DY| = y}$, tak z podobnosti trojuholníkov $BXC$ a $DCY$ dostávame:

                $$\bf{\frac{y}{a} = \frac{b}{x} \Rightarrow y = \frac{ab}{x}}$$

                a odtiaľ

                $$\bf{|XY| = |XC| + |CY| = \bbox[yellow, 5px]{\sqrt{x^2 + b^2} + \sqrt{\biggl( \frac{ab}{x} \biggr )^2 + a^2}}}$$

            </p>

            <p>
                V 2. prípade máme $\bf{\frac{b}{|XC|} = \sin\varphi, \frac{a}{|CY|} = \cos\varphi}$ a z toho dostávame:

                $$\bbox[aqua, 5px]{\bf{|XY| = \frac{a}{\cos\varphi} + \frac{b}{\sin\varphi} }}$$
            </p>

            <p>
                Treba poznamenať, že v 1. prípade je $x$ ľubovoľné kladné číslo a v 2. prípade je uhol $\bf{AXY}$ vždy ostrý,
                čiže $\bf{\varphi \in (0; \frac{\pi}{2})}$.
            </p>

            <p>
                Nájdené vyjadrenia sa dosť líšia. Odpovedať na otázku, ktoré je vhodnejšie, má zmysel až potom, keď budeme
                vedieť na čo tieto vyjadrenia použijeme.
            </p>
        </div>
        <br>

        <div class="priklad">
            <h3>Príklad 2.</h3>

            <p>
                Vyjadrite obsah pravouholníka $\bf{ABCD}$ s obvodom $\bf{4d}$ pomocou:

            <ol type="a">
                <li>
                    dĺžky $\bf{x}$ dlhšej strany
                </li>

                <li>
                    pomeru $\bf{k}$ dĺžok jeho strán
                </li>

                <li>
                    dĺžky $\bf{u}$ jeho uhlopriečky
                </li>

                <li>
                    rozdielu $\bf{\Delta}$ dĺžok jeho strán
                </li>
            </ol>

            vo všetkých prípadoch určite obor pemennej.
            </p>

            <p>
                Prípad <b>a.</b> je zrejmý (pozri Obsah a), obsah $\bf{P(x) = \bbox[yellow, 5px]{x \cdot (2d - x)},
                x \in \langle d ; 2d )}$.

                <details class="detail">
                    <summary class="summary"><b>Obsah a</b></summary><br>
                    <div class="center2" id="nrjugwq6"></div>
                </details>
            </p>

            <p>
                V prípade <b>b.</b> (pozri Obsah b) dostávame $\bf{a + k \cdot a = 2d}$, odkiaľ máme:
                <details class="detail">
                    <summary class="summary"><b>Obsah b</b></summary><br>
                    <div class="center2" id="x2trh8dw"></div>
                </details>

                $$\bf{a = \frac{2d}{k + 1}, b = \frac{2d \cdot k}{k + 1}}$$

                a obsah

                $$\bf{P(k) = a \cdot b = \bbox[yellow, 5px]{d^2 \frac{4k}{(k + 1)^2}}, k \in (0; 1 \rangle}.$$

                (Ak si chcete pozrieť priebeh funkcie $\bf{y = \frac{4x}{(x + 1)^2}}$, pozrite si G04.)

                <details class="detail">
                    <summary class="summary"><b>G04</b></summary><br>
                    <div class="center2" id="yaurwnbb"></div>
                </details>




            </p>

            <p>
                Zaujímavý je prípad <b>c.</b> Nebudeme sa tu púšťať do riešenia úlohy ako zostrojiť obdĺžnik, keď poznáme jeho
                obvod a dĺžku uhlopriečky (ale zamyslenie sa nad výkresom Obsah c môže byť poučné). Stačí, keď si uvedomíme, že:

                $$\bf{u^2 = a^2 + b^2, \, 2d = a + b \Rightarrow}$$
                $$\bf{4d^2 = a^2 + 2ab + b^2 = u^2 + 2 \cdot P(u) \Rightarrow}$$
                $$\bf{P(u) = \bbox[yellow, 5px]{2d^2 - \frac{u^2}{2}}}.$$

                <details class="detail">
                    <summary class="summary"><b>Obsah c</b></summary><br>
                    <div class="center2" id="csevxfrk"></div>
                </details>
            </p>

            <p>
                Musíme si uvedomiť, že $\bf{u \in \langle \sqrt{2} \cdot d; 2d)}$.
            </p>

            <p>
                Pre riešenie prípadu <b>d.</b> nepotrebujeme ilustráciu. Zo sústavy rovníc:

                $$\bf{a - b = \Delta, \, a + b = 2d}$$

                dostávame

                $$\bf{a = d + \frac{\Delta}{2}, \, b = d - \frac{\Delta}{2}},$$

                takže pre obsah dostávame vzťah:

                $$\bf{P(\Delta) = \bbox[yellow, 5px]{d^2 - \frac{\Delta^2}{4}}, \Delta \in \langle 0; 2d )}$$
            </p>

            <p>
                Odpovedať na otázku, ktorá z volieb premennej bola najvhodnejšia, má zmysel len ak vieme čo sme chceli takýmto
                vyjadrením obsahu dosiahnuť. Prípad <b>d.</b> je napríklad najvhodnejší pri riešení problému, kedy je obsah
                maximálny.
            </p>
        </div>

    </section>

    <div class="pagination">
        <a href="A21_3.php">&laquo;</a>
        <a class="active" href="A21_1.php">1</a>
        <a href="A21_2.php">2</a>
        <a  href="A21_3.php">3</a>
        <a href="A21_4.php">4</a>
        <a href="A21_5.php">5</a>

        <a href="A21_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"nrjugwq6", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"x2trh8dw","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"yaurwnbb", "width":"1400", "height":"600"};
    var applet3 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"csevxfrk","width":"1400", "height":"600"};
    var applet4 = new GGBApplet(parameters, '5.0', views);


    window.onload = function() {
        applet1.inject('nrjugwq6');
        applet2.inject('x2trh8dw');
        applet3.inject('yaurwnbb');
        applet4.inject('csevxfrk');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
