<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA21.html');
?>

<div class="item2">
    <h2>2.1 Premenná</h2>

    <section>


        <div class="priklad">
            <h3>Príklad 3.</h3>

            <p>
                Z kruhového výseku kruhu s polomerom $1$ zostrojíme plášť kužeľa (pozri obr.). Vyjadrite objem tohto kužeľa
                pomocou veľkosti stredového uhla výseku.

            <div class="center2"><img src="photo/p34.png" alt="obrazky"></div>
            </p>

            <p>
                Obvod podstavy hľadaného kužeľa je zrejme $\bf{\varphi = 2 \pi \cdot r \Rightarrow r = \frac{\varphi}{2\pi}}$
                a podľa Pytagora pre výšku $\bf{v}$ hľadaného kužeľa platí: $\bf{v = \sqrt{1 - r^2} = \sqrt{1 -
                \bigg(\frac{\varphi}{2\pi} \biggr )^2}}$. Použijúc vzorec pre objem kužeľa dostávame:

                $$\bf{V(\varphi) = \bbox[yellow, 5px]{\frac{\pi}{3} \cdot \biggl (\frac{\varphi}{2\pi} \biggr )^2 \cdot
                \sqrt{1 - \biggl (\frac{\varphi}{2\pi} \biggr )^2}}}$$
            </p>

            <p>
                Vidíme, že nae vyjadrenie obsahu by bolo výrazne jednoduchšie, keby sme ako premennú neuvažovali veľkosť
                stredového uhla $\bf{\varphi}$ kruhového výseku, ale pomer $\bf{k = \frac{\varphi}{2\pi}}$. Potom by pre objem
                platilo:

                $$\bf{V(k) \bbox[yellow, 5px] {\frac{\pi}{3} \cdot k^2 \cdot \sqrt{1 - k^2}}}$$

                (Môžete si pozrieť výkres Objem kužeľa.)

                <details class="detail">
                    <summary class="summary"><b>Objem kužeľa</b></summary><br>
                    <div class="center2" id="k9zecpzg"></div>
                </details>
            </p>
        </div>
        <br>

        <div class="priklad">
            <h3>Príklad 4.</h3>

            <p>
                Na rovine je položená guľa s jednotkovým polomerom. Treba ju prikryť plášťom kužeľa tak aby guľa bola vpísaná
                do kužeľa. Vyjadrite povrch plášťa pomocou:

            <ol>
                <li>
                    polomeru $\bf{r}$ podstavy kužeľa
                </li>

                <li>
                    výšky $\bf{v}$ kužeľa
                </li>

                <li>
                    veľkosť uhla $\bf{\alpha}$, ktorý zvierajú povrchové priamky kužeľa s jeho osou.
                </li>
            </ol>
            </p>

            <p>
                Na obrázku na ďalšej strane máte prierez kužeľa a rozvinutý plášť kužeľa v príslušnej mierke. Obrázok si tiež
                môžete pozrieť na výkrese Plášť kužeľa. V tomto výkrese môžete meniť myšou polohu vrcholu $\bf{V}$ kužeľa
                a sledovať ako sa menia ostatné veličiny, vrátane rozvinutého plášťa.

                <details class="detail">
                    <summary class="summary"><b>Plášť kužeľa</b></summary><br>
                    <div class="center2" id="">pracuje sa na tom</div>
                </details>
            </p>

            <p>
                Pre povrch $\bf{P}$ plášťa kužeľa, ktorého podstava má polomer $\bf{r}$ zrejme platí:

                $$\bf{P = \pi s^2 \cdot \frac{2 \pi r}{2 \pi s} = \pi r s}$$
            </p>
            <div class="center2"><img src="photo/p26.png" alt="obrazky"></div>

            <p>
                Z podobnosti trojuholníkov $\bf{OTV}$ a $\bf{ASV}$ dostávame vzťahy:
                $$\bf{\bbox[yellow, 5px]{\frac{1}{r} =
                \frac{s - r}{|SV|} = \frac{|SV| - 1}{s}} \qquad (1)}$$
            </p>

            <p>
                Z nich sa pokúsime vyjadriť povrch plášťa kužeľa:
                <ol>
                    <li>
            <p>
                pomocou $\bf{r}$
            </p>
            </li>

            <li>
                <p>
                    pomocou $\bf{v = |SV|}$
                </p>
            </li>

            <li>
                <p>
                    pomocou $\bf{\alpha}$
                </p>
            </li>
            </ol>
            </p>

            <ol>
                <li>
                    <p>
                        Z (1) $\Rightarrow \bf{s = r \cdot v - r}$ (2) a tiež $\bf{v = r \cdot s - r^2}$ (3). Ak do (2)
                        dosadíme za $\bf{v}$ z (3), dostávame $\bf{s = r(rs - r^2) - r}$ $\bf{ \Rightarrow s = r^2s - r^3 - r
                        \Rightarrow r^3 + r = (r^2 - 1)s \Rightarrow s = \frac{r^3 + r}{r^2 - 1}}$
                        Odtiaľ pre povrch plášťa dostávame: $\bf{P(r) = \pi r s = \bbox[yellow, 5px]{\pi r^2 \frac{r^2 + 1}{r^2 - 1}},
                        r \in (1; \infty) \qquad (4)}$
                    </p>
                </li>

                <li>
                    <p>
                        Ak do (3) dosadíme za $\bf{s}$ zo vzťahu (2), dostávame: $\bf{v = r(rv - r) - r^2 \Rightarrow v = r^2 v -2r^2}$.

                    </p>
                    <p>
                        Z tohto vzťahu určíme $\bf{r^2 = \frac{v}{v-2}}$ 2.a toto dosadíme do (4). Postupne dostávame:
                        $$\bf{P(v) = \pi \frac{v}{v-2} \frac{\frac{v}{v - 2} + 1 }{\frac{v}{v - 2} -1 } = \pi \frac{v}{v-2}
                        \frac{v + v - 2}{v - v + 2} = \bbox[yellow, 5px]{\pi \frac{v (v-1)}{v-2}} v \in (2; \infty) \qquad (5) }$$
                    </p>
                </li>

                <li>
                    <p>
                        Z trojuholníka $\bf{OTV}$ máme $\bf{\sin \alpha = \frac{1}{v - 1} (6) }$ a z trojuholníka $\bf{ASV}$
                        máme $\bf{\cos \alpha = \frac{v}{s} (7)}$
                        $$\bf{(6) \Rightarrow v - 1 = \frac{1}{\sin \alpha} \Rightarrow v = \frac{1}{\sin \alpha} + 1 = \frac{\sin \alpha + 1}{\sin \alpha} },$$
                        $$\bf{(7) \Rightarrow s = \frac{v}{\cos \alpha} = \frac{\sin \alpha + 1}{\sin \alpha \cos \alpha}}.$$
                        Z posledných dvoch vzťahov dostávame:
                        $$\bf{P(\alpha) = \pi r s = \bbox[yellow, 5px]{\pi \frac{(\sin \alpha + 1)^2}{\sin \alpha \cos^2 \alpha} \; \alpha \in \biggl(0; \frac{\pi}{2}\biggr) } \qquad (8) }$$
                    </p>
                </li>
            </ol>

            <p>
                Definičné obory premenných sú zrejmé. Získané vyjadrenia sú prekvapujúco málo podobné. Ak si pozriete grafy
                G05a, G05b, G05c, pomocou ikony „Calculate“ a voľby „Find extrema“ zistíte, čo je od voľby premennej nezávislé.
                <details class="detail">
                    <summary class="summary"><b>G05a</b></summary><br>
                    <div class="center2" id="hj2bhwy2"></div>
                </details>

                <details class="detail">
                    <summary class="summary"><b>G05b</b></summary><br>
                    <div class="center2" id="qzczamsx"></div>
                </details>
                <details class="detail">
                    <summary class="summary"><b>G05c</b></summary><br>
                    <div class="center2" id="nq7hkk4f"></div>
                </details>
            </p>
        </div>

    </section>

    <div class="pagination">
        <a href="A21_1.php">&laquo;</a>
        <a  href="A21_1.php">1</a>
        <a class="active" href="A21_2.php">2</a>
        <a  href="A21_3.php">3</a>
        <a href="A21_4.php">4</a>
        <a href="A21_5.php">5</a>

        <a href="A21_3.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"hj2bhwy2", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"qzczamsx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"nq7hkk4f","width":"1400", "height":"600"};
    var applet3 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"k9zecpzg","width":"1400", "height":"600"};
    var applet4 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"nq7hkk4f","width":"1400", "height":"600"};
    var applet5 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('hj2bhwy2');
        applet2.inject('qzczamsx');
        applet3.inject('nq7hkk4f');
        applet4.inject('k9zecpzg');
        applet5.inject('nq7hkk4f');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
