<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA21.html');
?>

<div class="item2">
    <h2>2.1 Premenná</h2>

    <section>

        <p>
            Ďalšou oblasťou kde je rozhodujúcou schopnosť <b>„vhodne“</b> zvoliť premennú sú problémy, ktoré vedú k vyriešeniu
            nejakej rovnice. V školskej matematike tomu hovorievame <b>„slovné úlohy“</b>.
        </p>


        <div class="priklad">
            <h3>Príklad 5.</h3>

            <p>
                Na obrázku vpravo je „kríž“ vpísaný do jednotkovej kružnice. Kríž je zjednotením obdĺžnika s jeho obrazom
                v otočení o 90°.
            </p>


            <ol type="a">
                <li>
                    <p>
                        Vyjadrite obsah kríža pomocou premennej $\bf{x}$ resp $\bf{\alpha}$.
                    </p>
                </li>

                <li>
                    <p>
                        Nájdite takú hodnotu premenných $\bf{x}$ resp. $\bf{\alpha}$, pre ktorú je obsah kríža rovný
                        polovici obsahu kruhu.
                    </p>
                </li>
            </ol><div class="center2"><img src="photo/p35.png" float="right" alt="obrazky"></div>

            <h3>Riešenie</h3>
            <ol type="a">
                <li>
                    <p>
                        Ak použijeme ako premennú polovičnú šírku $\bf{x}$ vpísaných obdĺžnikov a označíme polovicu druhého rozmeru
                        týchto obdĺžnikov ako $\bf{y}$,  dostávame:

                        $\bf{x^2 + y^2 = 1 \Rightarrow \bbox[yellow, 5px]{P(x)} = 2x \cdot 2y + 2x \cdot 2y - 2x \cdot 2x =}$
                        $\bf{4x(2y - x) = \bbox[yellow, 5px]{4x(2\sqrt{1 - x^2} - x)} }$
                    </p>

                    <p>
                        Ak použijeme ako premennú uhol $\bf{\alpha}$ dostávame :
                        $\bf{x = \sin \alpha, \; y = \cos \alpha \Rightarrow \bbox[yellow, 5px]{P(\alpha) = 4 \cdot sin \alpha (2 \cdot \cos \alpha - \sin \alpha)} }$
                    </p>
                </li>

                <li>
                    <p>
                        Príslušné hodnoty premenných $\bf{x}$ resp. $\bf{\alpha}$ sú riešeniami rovníc
                        <sup><dfn title="Týmto rovniciam sa budeme venovať v kapitole A 3.1">[4]</dfn></sup>:
                        $$\bf{\bbox[cyan, 5px]{4x(2\sqrt{1 - x^2} - x) \frac{\pi}{2} }, \; resp. \bbox[yellow, 5px]{4 \cdot \sin \alpha (2 \cdot \alpha - \sin \alpha) = \frac{\pi}{2} } }$$
                    </p>
                </li>
            </ol>

            <p>
                Treba konštatovať, že zo zadania je zrejme $\bf{x \in (0; 1), \alpha \in (0; \frac{\pi}{2})}$
            </p>

            <p>
                Mnohokrát je súčasťou úlohy niekoľko „parametrov“, t. j. veličín, ktoré sú z hľadiska riešenia problému
                konštantné, ale ktorých konkrétna hodnota ovplyvňuje kvalitu riešenia, alebo aj spôsob riešenia.
            </p>


        </div><br>

        <div class="priklad">
            <h3>Príklad 6.</h3>
            <p>
                Vyjadrite pomocou premennej $\bf{x}$ a parametrov $\bf{a, b, d}$ súčet vzdialeností:
                $$\bf{s(x) = |AM| + |MB|}$$
            </p>

            <h3>Riešenie </h3>
            <p>
                Bezprostredne z Pytagorovej vety dostávame
                $$\bf{s(x) = \bbox[yellow, 5px]{\sqrt{x^2 + a^2} + \sqrt{(d - x)^2 + b^2} }}$$
            </p>

            <p>
                Treba si uvedomiť, že parametre $\bf{a, b, d}$ môžu nadobúdať ľubovoľnú kladnú hodnotu a ak
                predpokladáme že bod $\bf{M}$  je bodom úsečky $\bf{A*B*}$, tak oborom premennej $\bf{x}$ je
                interval $\bf{(0 ; d)}$.
            </p>
            <div class="center2"><img src="photo/p36.png" float="right" alt="obrazky"></div>
        </div><br>

        <div class="priklad">
            <h3>Príklad 7.</h3>
            <p>
                Pomocou premennej $\bf{x}$ a parametrov $\bf{a, b, d}$ vyjadrite čas potrebný na prejdenie dráhy z bodu
                $\bf{A}$ do bodu $\bf{M}$ rýchlosťou $\bf{v_a}$ a potom z bodu $\bf{M}$ do bodu $\bf{B}$ rýchlosťou $\bf{v_b}$.
            <div class="center2"><img src="photo/p37.png" float="right" alt="obrazky"></div>
            </p>

            <h3>Riešenie </h3>
            <p>
                Z Pytagorovej vety a z vlastností rovnomerného priamočiareho pohybu dostávame:

                $$\bf{t(x) = \bbox[yellow, 5px]{\frac{\sqrt{x^2 + a^2}}{v_a} + \frac{\sqrt{(d - x)^2} + b^2}{v_b}}}$$

                oborom premennej $\bf{x}$ je interval $\bf{0; d}$
            </p>

        </div><br>

        <div class="priklad">
            <h3>Príklad 8.</h3>

            <p>
                Zostavte rovnicu, z ktorej vypočítate pre ktorú hodnotu premennej $x$ bude platiť

                $$\bf{\sin \alpha : \sin \beta = 1 : 2}$$
            <div class="center2"><img src="photo/p38.png" float="right" alt="obrazky"></div>
            </p>

            <h3>Riešenie </h3>
            <p>
                Máme nájsť také $x$, pre ktoré je $\bf{\sin \beta  = 2 \cdot \sin \alpha}$
            </p>

            <p>
                Z Pytagorovej vety a zo zhodnosti striedavých uhlov dostávame:

                $$\bf{\frac{d - x}{\sqrt{(d - x)^2 + b^2}} = 2 \cdot \frac{x}{\sqrt{x^2 + a^2}}}$$
                oborom premennej $\bf{x}$ je interval $\bf{0; d}$.
            </p>

        </div>

    </section>

    <div class="pagination">
        <a href="A21_3.php">&laquo;</a>
        <a  href="A21_1.php">1</a>
        <a  href="A21_2.php">2</a>
        <a href="A21_3.php">3</a>
        <a class="active" href="A21_4.php">4</a>
        <a href="A21_5.php">5</a>

        <a href="A21_5.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
