<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA21.html');
?>

<div class="item2">
    <h2>2.1 Premenná</h2>

    <section>

        <div class="priklad">
            <h3>Príklad 9.</h3>

            <p>
                V mestskom divadle je spolu $\bf{800}$ miest. Existuje $\bf{5}$ druhov miest a teda $\bf{5}$ rôznych
                cien lístkov. Najdrahšie lístky sú druhu $\bf{A}$, cena lístka každého ďalšieho druhu je vždy o $\bf{100 \; SK}$
                nižšia. Úhrnné ceny v jednotlivých druhoch miest udáva druhý riadok tabuľky. Zostavte rovnicu, z ktorej
                vypočítate aké sú ceny lístkov v jednotlivých kategóriách.
            </p>

            $$\begin{array}{|c|c|c|c|}
            \hline Druh & \bf{A} & \bf{B} & \bf{C} & \bf{D} & \bf{E} \\
            \hline Úhrnná \; cena \; lístkov \; v \; Sk & \bf{16 800} & \bf{75 650} & \bf{104 000} & \bf{33 750} & \bf{15 000} \\
            \hline Cena \; lístku & \bf{x + 200} & \bf{x + 100} & \bf{x} & \bf{x - 100} & \bf{x - 200} \\
            \hline Počet \; miest \; daného \; druhu & \bf{\frac{16 800}{x + 200}} & \bf{\frac{75 650}{x + 100}} & \bf{\frac{104 000}{x}}
            & \bf{\frac{33 750}{x - 100}} & \bf{\frac{15 000}{x - 200}} \\ \hline
            \end{array}$$



            <h3>Riešenie</h3>
            <p>
                Doplnili sme tabuľku o riadok, v ktorom sú neznáme ceny lístkov a o riadok, v ktorom uvádzame počet predaných
                lístkov. Zostavíme rovnicu pre počet miest:

                $$\bf{\bbox[yellow, 5px]{\frac{15000}{x - 200} + \frac{33750}{x - 100} + \frac{104000}{x} + \frac{75650}{x + 100}
                + \frac{16800}{x + 200} = 800 } }$$

            </p>

        </div> <br>

        <div class="uloha">
            <h3>Úlohy</h3>
            <ol start="5">
                <li>
                    <p>
                        <b>Prémia!</b> Do kružnice s polomerom $5$ je vpísaný obdĺžnik $\bf{ABCD}$, jeho strany sú v pomere
                        $\bf{2 : 1}$. Jeho otočením okolo stredu $\bf{S}$ o uhol $\bf{\alpha}$ vznikol obdĺžnik $\bf{KLMN}$.
                        <details class="detail">
                            <summary class="summary"><b>Pozrite si Ot4u</b></summary><br>
                            <div class="center2" id="reyzzctj"></div>
                        </details>
                        Vyjadrite pomocou premennej $\bf{\alpha}$ obsah prieniku a obsah zjednotenia obdĺžnikov
                        $\bf{ABCD}$ a $\bf{KLMN}$. Za obor premennej $\bf{\alpha}$ zvoľte interval $\bf{(0^\circ; 90^\circ)}$.
                    <div class="center2"><img src="photo/p39.png" alt="obrazky"></div>


                    </p>
                </li>

                <li>
                    <p>
                        Máme rovnostranný trojuholník $\bf{ABC}$ s obsahom $\bf{30 \; cm^2}$. Jeho otočením okolo stredu
                        $\bf{S}$ o uhol $\bf{\alpha}$ vznikol trojuholník $\bf{KLM}$.

                        <details class="detail">
                            <summary class="summary"><b>Pozrite si Ot3u</b></summary><br>
                            <div class="center2" id="qkyhjcs3"></div>
                        </details>

                        Vyjadrite pomocou premennej $\bf{\alpha}$ pomer obsahu prieniku trojuholníkov $\bf{ABC}$ a $\bf{KLM}$
                        ku obsahu trojuholníka $\bf{ABC}$. Za obor premennej  zvoľte interval  $\bf{(0^\circ; 120^\circ)}$.
                    </p>
                    <div class="center2"><img src="photo/p40.png"  alt="obrazky"></div>
                </li>

                <li>
                    <p>
                        Pomocou premennej $\bf{k \in (0; 1)}$ a parametrov $\bf{a, b, d, v_a , v_b}$  vyjadrite:
                        <ul>
                            <li>
                    <p>
                        súčet vzdialeností $\bf{s(k) = |AM| + |MB|}$
                    </p>
                </li>

                <li>
                    <p>
                        čas potrebný na prejdenie dráhy z bodu $\bf{A}$ do bodu $\bf{M}$ rýchlosťou $\bf{v_a}$
                        a potom z bodu $\bf{M}$ do bodu $\bf{B}$ rýchlosťou $\bf{v_b}$.
                    </p>
                </li>

                <li>
                    <p>
                        pomer $\bf{\frac{\sin \alpha}{\sin \beta} }$
                    </p>
                </li>
                </ul>
                <div class="center2"><img src="photo/p41.png"  alt="obrazky"></div>

                </p>
                </li>

                <li>
                    <p>
                        Pán Konček spotreboval za roky $\bf{2002, 2003}$ a $\bf{2004}$ spolu $\bf{5000 \; m^3}$ zemného plynu.
                        V uvedené roky platil za plyn $\bf{13\,880 \; Sk, 15\,143 \; Sk}$ a $\bf{16\,710 \; Sk}$. Zostavte rovnicu,
                        z ktorej určíte ceny za $\bf{1 \; m^3}$ a spotrebu plynu v týchto rokoch ak viete, že v roku $\bf{2003}$
                        sa cena za $\bf{1 \; m^3}$ plynu zvýšila o $\bf{1.5 \; Sk}$ a v roku $\bf{2004}$ o ďalších $\bf{0.5 \; Sk}$.
                        (Dobrá rada, za neznámu si zvoľte cenu plynu v r. $\bf{2003}$.)
                    </p>
                </li>
            </ol>
        </div>

        <p>
            Na záver ukážka toho, že vyjadrenie jednej veličiny pomocou druhej nás niekedy donúti zmobilizovať
            poznatky z rôznych častí matematiky:
        </p>

        <div class="priklad">
            <h3>Príklad 10.</h3>

            <p>
                Prúžok papiera šírky $\bf{p}$ preložíme pozdĺž úsečky $\bf{DE}$ tak, aby bod $\bf{B}$ prešiel do bodu $\bf{C}$.
                Vyjadrite dĺžku $\bf{d}$ záhybu len pomocou uhlu $\bf{\alpha}$.
            </p>
            <div class="center2"><img src="photo/p42.png" alt="obrazky"></div>

            <h3>Riešenie:</h3>
            <p>
                Uhly $\bf{\angle \, BAC}$ a $\bf{\angle \, DBE}$ sú zhodné, lebo sú to uhly s ramenami na seba kolmými. Uhol
                $\bf{\angle \, AEC}$ má veľkosť $\bf{2 \alpha}$, lebo trojuholník $\bf{BCE}$ je rovnoramenný. Zrejme platia vzťahy:

                $$\bf{d = \frac{p - y}{\sin \alpha}, \; y = \frac{x}{\tan 2 \alpha}, \; x = p \cdot \tan \alpha}, $$
                ak si uvedomíme, že $$\bf{\tan 2 \alpha = \frac{2 \cdot \tan \alpha}{1 - \tan^2 \alpha}}$$ tak
                postupným dosadzovaním dostaneme: $$\bf{d(\alpha) = \frac{p}{2 \cdot \sin \alpha \cdot \cos^2 \alpha} }$$
            </p>
        </div>

        <p>
            Na záver uvedieme jeden problém pre čitateľov.
        </p>

        <h3>Problém</h3>
        <p>
            Dobre si všimnite obrázok a vyjadrite súradnice bodov $\bf{P, Q}$ pomocou uhla $\bf{\alpha}$.
        <div class="center2"><img src="photo/p43.png" alt="obrazky"></div>
        </p>


    </section>

    <div class="pagination">
        <a href="A21_4.php">&laquo;</a>
        <a  href="A21_1.php">1</a>
        <a  href="A21_2.php">2</a>
        <a href="A21_3.php">3</a>
        <a href="A21_4.php">4</a>
        <a class="active" href="A21_5.php">5</a>

        <a href="A21_6.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"reyzzctj", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"qkyhjcs3","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('reyzzctj');
        applet2.inject('qkyhjcs3');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
