<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA22.html');
?>

<div class="item2">
    <h2>2.2 Úpravy výrazov</h2>

    <section>
        <p>Porovnajte nasledujúce výrazy:</p>
        <ol type="A">
            <li><p>&emsp; $\bf{4 \cdot x^2 - 16 \cdot x + 7}$</p></li>
            <li><p>&emsp; $\bf{((4) \cdot x - 16) \cdot x + 7}$</p></li>
            <li><p>&emsp; $\bf{4 \cdot (x - 2)^2 - 9}$</p></li>
            <li><p>&emsp; $\bf{4 \cdot (x - 0.5) \cdot (x - 3.5)}$</p></li>
        </ol>

        <p>
            Ako ľahko nahliadnete, sú to iba rôzne podoby toho istého výrazu. Stačí výrazy B, C a D trochu "upraviť".
        </p>

        <p>
            Tvar A je najjednoduchší v tom zmysle, že je vhodný ak chceme podobné výrazy napríklad sčitovať, násobiť,
            porovnávať a podobne.
        </p>

        <p>
            Tvar B je vhodný na výpočet hodnôt daného výkazu. Stačia na to dve násobenia. Vedieť upraviť mnohočlen do tohto
            tvaru je rozumné, ak chceme poznať jeho hodnoty pre viacero hodnôt premennej $x$.
        </p>

        <p>
            Z tvaru C vidieť, že náš výraz nadobúda svoju minimálnu hodnotu $\bf{-9}$ vtedy, keď $\bf{x = 2}$.
        </p>

        <p>
            Z tvaru D zasa vidíme, že náš výraz je rovný nule, keď $\bf{x = 0.5}$, alebo keď $\bf{x = 3.5}$.
        </p>

        <p>
            Z tohto príkladu je dostatočne zrejmé, že <b>výrazy upravujeme
                <sup><dfn title="Upravovať výrazy dokážu čiastočne aj niektoré matematické softvéry ako napríklad
                        Mathematica, alebo Derive 6, ktorý pre väčšinu stredných škôl v SR zakúpilo MŠ v rámci projektu Infovek.">
                        [1]</dfn></sup> podľa potreby</b>, t.j. do takého tvaru, ktorý je pre daný účel najvhodnejší.
            Za zmienku stojí fakt, že z tvarov B,C a D sa k tvaru A dostaneme "prirodzene", jednoduchou úpravou, ale
            schopnosť získať z tvaru A tvar C a najmä tvar D už musí byť predmetom cieľavedomého výcviku.
        </p>

        <div class="priklad">
            <h3>Príklad 1.</h3>

            <ol type="a">
                <li>
                    <p>
                        Upravme na tvar <b>C</b> výraz $\bf{x^2 + 4x + 9}$. Z rovnosti $\bf{x^2 + 4x + 9 = (x - u)^2 + v}$
                        bezprostredne vyplýva:

                        $$\bf{x^2 + 4x + 9 = x^2 - 2ux + u^2 + v \Rightarrow}$$
                        $$\bf{4 = - 2u \land 9 = u^2 + v \Rightarrow}$$
                        $$\bf{u = -2 \land v = 5}$$

                        a preto: $\bf{x^2 + 4x + 9 = (x + 2)^2 + 5}$
                    </p>
                </li>

                <li>
                    <p>
                        Upravme na tvar <b>C</b> výraz $\bf{2x^2 + 6x + 9}$. Z rovnosti $\bf{2x^2 + 6x + 9 = 2(x - u)^2 + v}$
                        bezprostredne vyplýva:

                        $$\bf{2x^2 + 6x + 9 = 2x^2 - 4ux + 2u^2 + v \Rightarrow}$$
                        $$\bf{6 = -4u \land 9 = 2u^2 + v \Rightarrow}$$
                        $$\bf{u = - \frac{3}{2} \land v = \frac{9}{2}}$$

                        a preto: $\bf{2x^2 + 6x + 9 = 2 \Bigl(x + \frac{3}{2} \Bigr)^2 + \frac{9}{2}}$
                    </p>
                </li>
            </ol>
        </div><br>

        <div class="priklad">
            <h3>Príklad 2.</h3>

            <p>
                Vo všeobecnosti zrejme platí:

                $$\bf{a \cdot x^2 + b \cdot x + c =}$$
                $$\bf{a \Biggl[x^2 + \frac{b}{a}x \Biggr] + c = a \Biggl[\biggl(x + \frac{b}{2a} \biggr)^2 - \frac{b^2}{4a^2}
                \Biggr] + c =}$$
                $$\bf{a \biggl(x + \frac{b}{2a} \biggr)^2 - \frac{b^2}{4a} + c = a \biggl(x - \frac{-b}{2a} \biggr)^2 +
                \frac{4ac - b^2}{4a}}$$
            </p>

            <p>
                Otvorte si zošit Dopĺňanie a zadajte vzorec pre výpočet hodnôt buniek D7 a E7.
                <details class="detail">
                    <summary class="summary"><b>Dopĺňanie</b></summary><br>
                    <div class="center2" >
                        <iframe scrolling="no" title="A2.01" src="https://www.geogebra.org/material/iframe/id/krdqtqgt/width/944/height/500/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="500px" style="border:0px;"> </iframe>
                    </div>
                </details>
            </p>


            <p>
                Zaujímavý je aj tvar B. V nasledujúcom príklade budeme postupovať podobne ako v jednom príklade z kapitoly
                o číslach.
            </p>
        </div>
    </section>

    <div class="pagination">
        <a href="A22_3.php">&laquo;</a>
        <a class="active" href="A22_1.php">1</a>
        <a href="A22_2.php">2</a>
        <a  href="A22_3.php">3</a>
        <a href="A22_4.php">4</a>
        <a href="A22_5.php">5</a>

        <a href="A22_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
