<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA22.html');
?>

<div class="item2">
    <h2>2.2 Úpravy výrazov</h2>

    <section>
        <div class="priklad">
            <h3>Príklad 3.</h3>

            <p>
                Vypočítajte hodnotu mnohočlena $\bf{2 \cdot x^7 + x^6 - 2 \cdot x^4 - x^3 + 2}$ pre $\bf{x \in
                \{-3, \, -2, \, -1, \, 0, \, 1, \, 2, \, 3\}}$. Mnohočlen doplníme o tie mocniny premennej, kde boli
                koeficientmi nuly. Dostaneme:

                $$\bf{2 \cdot x^7 + 1 \cdot x ^6 + 0 \cdot x^5 - 2 \cdot x^4 - 1 \cdot x^3 + 0\cdot x^2 + 0 \cdot x + 2}$$
            </p>

            <p>
                Tento zápis <b>vhodne</b> (postupným vynímaním pred zátvorku) upravíme. Dostaneme:

                $$\begin{aligned}
                \bf 2 \cdot x^7 + 1 \cdot x ^6 + 0 \cdot x^5 - 2 \cdot x^4 - 1 \cdot x^3 + 0\cdot x^2 + 0 \cdot x + 2 & = \\
                \bf (2 \cdot x^6 + 1 \cdot x ^5 + 0 \cdot x^4 - 2 \cdot x^3 - 1 \cdot x^2 + 0\cdot x + 0) x + 2 & = \\
                \bf ((2 \cdot x^5 + 1 \cdot x ^4 + 0 \cdot x^3 - 2 \cdot x^2 - 1 \cdot x^1 + 0)x + 0) x + 2 & = \\
                \bf (((2 \cdot x^4 + 1 \cdot x ^3 + 0 \cdot x^2 - 2 \cdot x^1 - 1)x + 0)x + 0) x + 2 & = \\
                \bf ((((2 \cdot x^3 + 1 \cdot x ^2 + 0 \cdot x^1 - 2)x - 1)x + 0)x + 0) x + 2 & = \\
                \bf (((((2 \cdot x^2 + 1 \cdot x ^1 + 0)x - 2)x - 1)x + 0)x + 0) x + 2 & = \\
                \bf ((((((2 \cdot x + 1)x + 0)x - 2)x - 1)x + 0)x + 0) x + 2 & = \\
                \bf (((((((2)x + 1)x + 0)x - 2)x - 1)x + 0)x + 0) x + 2 & \qquad (H)
                \end{aligned}$$
            </p>

            <p>
                Vidíme tu sústavu do seba uzavretých zátvoriek. Pre lepšiu orientáciu napíšeme obsahy týchto zátvoriek od
                najvnútornejšej až po celý výraz:

                $$\begin{aligned}
                &\bf{(0) \qquad 2} \\
                &\bf{(1) \qquad (2) \cdot x + 1} \\
                &\bf{(2) \qquad ((2) \cdot x + 1) \cdot x + 0} \\
                &\bf{(3) \qquad (((2) \cdot x + 1) \cdot x + 0) \cdot x - 2} \\
                &\bf{(4) \qquad ((((2) \cdot x + 1) \cdot x + 0) \cdot x - 2) \cdot x - 1} \\
                &\bf{(5) \qquad (((((2) \cdot x + 1) \cdot x + 0) \cdot x - 2) \cdot x - 1) \cdot x + 0} \\
                &\bf{(6) \qquad ((((((2) \cdot x + 1) \cdot x + 0) \cdot x - 2) \cdot x - 1) \cdot x + 0) \cdot x + 0} \\
                &\bf{(7) \qquad (((((((2) \cdot x + 1) \cdot x + 0) \cdot x - 2) \cdot x - 1) \cdot x + 0) \cdot x + 0)
                \cdot x + 2}
                \end{aligned}$$
            </p>

            <p>
                Vidíme, že obsah nulterj zátvorky je prvý koeficient nášho mnohočlena a že obsah ľubovoľnej zátvorky dostaneme
                tak, že obsah predchádzajúcej vynásobíme príslušnou hodnotou premennej a pripočítame ďalší koeficient
                mnohočlena. Tento spôsob zápisu nás inšpiruje vypočítať hodnotu mnohočlena pre ľubovoľnú hodnotu premennej
                $\bf{x}$ pomocou tabuľky takto:



                $$\begin{array}

                {|c|c|}
                \hline x & 2 & 1 & 0 & -2 & -1 & 0 & 0 & 2 \\
                \hline 3 & 2 & 7 & 21 & 61 & 182 & 546 & 1638 & 4916 \\
                \hline 2 & 2 & 5 & 10 & 18 & 35 & 70 & 140 & 282 \\
                \hline 1 & 2 & 3 & 3 & 1 & 0 & 0 & 0 & 2 \\
                \hline 0 & 2 & 1 & 0 & -2 & -1 & 0 & 0 & 2 \\
                \hline -1 & 2 & -1 & 1 & -3 & 2 & -2 & 2 & 0 \\
                \hline -2 & 2 & -3 & 6 & -14 & 27 & -54 & 108 & -214 \\
                \hline -3 & 2 & -5 & 15 & -47 & 140 & -420 & 1260 & -3778 \\
                \hline
                \end{array}$$
            </p>

            <p>
                Vo vodorovnom záhlaví sú koeficienty mnohočlena a výrazy $\bf{0}$ až $\bf{7}$ detailne popisujú tvorbu obsahu
                buniek v riadkoch tabuľky. Vo zvislom záhlaví sú hodnoty premennej, pre ktoré počítame hodnotu mnohočlena.
                Pripomeňme si, že tento spôsob výpočtu hodnoty polýnomu sa volá <b>Hornerova schéma</b>. Pozrite si tiež
                Excelovský zošit Horner.

                <details class="detail">
                    <summary class="summary"><b>Horner list 1</b></summary><br>
                    <div class="center2" >
                        <iframe scrolling="no" title="A2.02a" src="https://www.geogebra.org/material/iframe/id/az6udcyr/width/944/height/500/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="500px" style="border:0px;"> </iframe>
                    </div>
                </details>

                <details class="detail">
                    <summary class="summary"><b>Horner list 2</b></summary><br>
                    <div class="center2" >
                        <iframe scrolling="no" title="A2.02b" src="https://www.geogebra.org/material/iframe/id/fvz5bf4n/width/944/height/500/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="500px" style="border:0px;"> </iframe>
                    </div>
                </details>
            </p>

        </div><br>

        <div class="uloha">
            <h3>Úlohy:</h3>

            <ol>
                <li>
                    <p>
                        Pomocou Hornerovej schémy vypočítajte hodnoty mnohočlena

                        $\bf{2x^5 + x^4 - 14x^3 - 7x^2 + 20x + 10}$, pre $\bf{x \in \{-3, \, -2, \, -1, \, 0, \, 1, \, 2, \, 3
                        \}}$.
                    </p>


                </li>
            </ol>
        </div>



    </section>

    <div class="pagination">
        <a href="A22_1.php">&laquo;</a>
        <a  href="A22_1.php">1</a>
        <a class="active" href="A22_2.php">2</a>
        <a  href="A22_3.php">3</a>
        <a href="A22_4.php">4</a>
        <a href="A22_5.php">5</a>

        <a href="A22_3.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
