<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA22.html');
?>

<div class="item2">
    <h2>2.2 Úpravy výrazov</h2>

    <section>
        <p>
            Dôležitou zručnosťou pri úprave výrazov je schopnosť vydeliť mnohočlen mnohočlenom. Tento algoritmus
            je analógiou delenia viacciferného čísla viacciferným číslom. Najlepšie to pochopíme na príklade:
        </p>

        <div class="priklad">
            <h3>Príklad 4.</h3>

            <p>
                Vydeľte mnohočlen $\bf{7x^4 - 3x^3 + 5x^2 - 4x + 3}$ mnohočlenom $\bf{x + 1}$.

                $$\begin{array} {cccccc}
                ( & 7x^4 & - & 3x^3 & + & 5x^2 & - & 4x & + & 3 & ) & : & (x + 1) = 7x^3 - 10x^2 + 15x - 19 \\
                & \color{red}{7x^4} & \color{red}{+} &  \color{red}{7x^3} \\
                && - & 10x^3 & + & 5x^2 & - & 4x & + & 3 \\
                && \color{red}- & \color{red}{10x^3} & \color{red}{-} & \color{red}{10x^2} \\
                &&&&& 15x^2 & - & 4x & + & 3 \\
                &&&&& \color{red}{15x^2} & \color{red}+ & \color{red}{15x} \\
                &&&&&& - & 19x & + & 3 \\
                &&&&&& \color{red}- & \color{red}{19x} & \color{red}- & \color{red}{19} \\
                &&&&&&&& \color{lime}+ & \color{lime}{22} \\
                \end{array}$$
            </p>

            <p>
                "Červené" riadky sme odčitovali od riadkov nad nimi. Výsledok delenia znamená, že:

                $$\bf{7x^4 - 3x^3 + 5x^2 - 4x + 3 = (x + 1) \cdot (7x^3 - 10x^2 + 15x - 19) + 22}$$
            </p>
        </div>

        <br>
        <div class="uloha">
            <h3>Úlohy:</h3>

            <ol start="2">
                <li>
                    <p>
                        Vydeľte mnohočlen $\bf{2 \cdot x^7 + x^6 - 2 \cdot x^4 - x^3 + 2}$ výrazmi $\bf{x - x_0, x_0 \in
                        \{-3, -2, -1, 0, 1, 2, 3\}}$. Výsledky porovnajte s riadkami Hornerovej schémy v príklade 3.
                        Sformulujte hypotézu o vzťahu medzi delením mnohočlena výrazom $\bf{x - x_0}$ a výpočtom hodnoty
                        mnohočlena v čísle $\bf{x_0}$ podľa Hornerovej schémy.
                    </p>
                </li>

                <li>
                    <p>
                        Pozorne si preštudujte 1.hárok excelovského zošitu Delenie polynómov. Umožňuje deliť ľubovoľný
                        polynóm najviac 4. stupňa polynómom 1. stupňa. Podľa neho dokončite delenie v 2. hárku a pokúste sa
                        v 3. hárku zabezpečiť delenie ľubovoľného polynómu najviac 5. stupňa ľubovoľným polynómom najviac
                        4. stupňa.

                        <details class="detail">
                            <summary class="summary"><b>Delenie polynómov - 1.hárok</b></summary><br>
                            <div class="center2" >
                                <iframe scrolling="no" title="A2.03a" src="https://www.geogebra.org/material/iframe/id/pdcvnxkv/width/1400/height/600/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="1400px" height="600px" style="border:0px;"> </iframe>
                            </div>
                        </details>


                        <details class="detail">
                            <summary class="summary"><b>Delenie polynómov - 2.hárok</b></summary><br>
                            <div class="center2" >
                                <iframe scrolling="no" title="A2.03b" src="https://www.geogebra.org/material/iframe/id/hpuuhfxd/width/1400/height/600/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="1400px" height="600px" style="border:0px;"> </iframe>
                            </div>
                        </details>


                        <details class="detail">
                            <summary class="summary"><b>Delenie polynómov - 3.hárok</b></summary><br>
                            <div class="center2" >
                                <iframe scrolling="no" title="A2.03c" src="https://www.geogebra.org/material/iframe/id/tucnkhk5/width/1400/height/600/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="1400px" height="600px" style="border:0px;"> </iframe>
                            </div>
                        </details>
                    </p>
                </li>
            </ol>
        </div><br>

        <div class="priklad">
            <h3>Príklad 5.</h3>

            <p>
                Dokážte, že pre všetky reálne čísla $\bf{a, b, c}$ platí:

                $$\bf{a^2 + b^2 + c^2 - ab - bc - ca \geq 0}$$
            </p>

            <h3>Riešenie:</h3>

            <p>
                Ak výraz na ľavej strane nerovnosti <b>vhodne</b> upravíme, dostaneme:

                $$\bf{a^2 + b^2 + c^2 - ab - bc - ca = \frac{1}{2}(a - b)^2 + \frac{1}{2}(b - c)^2 + \frac{1}{2}(c - a)^2}$$
            </p>

            <p>
                Z tvaru pravej strany je očividné, že náš výraz je vždy nezáporný, pretože je súčtom štvorcov a navyše je
                zrejmé, že sa bude rovnať nule práve vtedy, keď bude $\bf{a = b = c}$.
            </p>

            <p>
                Z tohto príkladu plynie ponaučenie, že je užitočné mať dobre vyvinutý cit pre to, čo je <b>vhodná</b> úprava
                výrazu. Tento cit sa dá vypestovať usilovným tréningom.
            </p>
        </div>





    </section>

    <div class="pagination">
        <a href="A22_2.php">&laquo;</a>
        <a  href="A22_1.php">1</a>
        <a  href="A22_2.php">2</a>
        <a class="active"  href="A22_3.php">3</a>
        <a href="A22_4.php">4</a>
        <a href="A22_5.php">5</a>

        <a href="A22_4.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
