<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA22.html');
?>

<div class="item2">
    <h2>2.2 Úpravy výrazov</h2>

    <section>

        <div class="priklad">
            <h3>Príklad 6.</h3>

            <p>
                Daný je výraz:

                $$\bf{V = -a^4 - b^4 - c^4 + 2a^2b^2 + 2b^2c^2 + 2c^2a^2}$$

                Oborom premenných $\bf{a, b, c}$ sú kladné reálne čísla. Určte, pre ktoré hodnoty premenných $\bf{a, b, c}$
                nadobúda výraz $\bf{V}$ kladné hodnoty.
            </p>

            <h3>Riešenie:</h3>
            <p>
                Rozumné je najprv experimentovať :
                $$\begin{array}{lll}
                1. \; pokus & \bf{a = b = c = 1} && \qquad & Hodnota \; výrazu:  & \bf{3} \\
                2. \; pokus & \bf{a = b = 1,}  & \bf{c = 2} & \qquad & Hodnota \; výrazu:  & \bf{0} \\
                3. \; pokus & \bf{a = b = 1,}  & \bf{c = 3} & \qquad & Hodnota \; výrazu:  & \bf{-45} \\
                \end{array}$$
            </p>

            <p>
                Dokazovať nezápornosť nemá zmysel. (Ďalšie experimentovanie s hodnotou výrazu $V$ pre rôzne hodnoty premenných
                $\bf{a, b, c}$ si môžete vyskúšať pomocou EXCELU v zošite Výraz V).
                <details class="detail"><summary class="summary"><b>Výraz V</b></summary><br>
                    <div class="center2" >
                        <iframe scrolling="no" title="A2.04" src="https://www.geogebra.org/material/iframe/id/srgwam4a/width/944/height/400/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="400px" style="border:0px;"> </iframe>
                    </div>
                </details>

                Pokúsme sa výraz $\bf{V}$ rozložiť na
                <b>súčin lineárnych výrazov</b>. Výraz $\bf{V}$ môžeme považovať za kvadratický trojčlen premennej
                $\bf{a^2}$ a tento doplníme na úplný štvorec. Dostávame:

                $$\begin{aligned}
                \bf{V} &\bf{= - a^4 - b^4 - c^4 + 2a^2b^2 + 2b^2c^2 + 2c^2a^2 = - [(a^2)^2 - 2(b^2+c^2)a^2 + (b^2-c^2)^2] =} \\
                &\bf{= - {[a^2 - (b^2 + c^2)]^2 - (b^2+c^2)^2 + (b^2 - c^2)^2} = - [(a^2 - b^2 - c^2)^2 - (2bc)^2] =}  \\
                &\bf{= - (a^2 - b^2 - 2bc - c^2)(a^2 - b^2 +2bc - c^2) = [a^2 - (b+c)^2][a^2-(b-c)^2] =} \\
                &\bf{= -[(a-b-c)(a+b+c)(a-b+c)(a+b-c) =} \\
                &\bf{= (a+b+c)(-a+b+c)(a-b+c)(a+b-c) \qquad \qquad (^*)}

                \end{aligned}$$

            </p>

            <p>
                Z posledného tvaru je vidieť, že náš výraz nadobúda kladné hodnoty práve vtedy, keď existuje trojuholník,
                ktorého strany majú dĺžky $\bf{a, b, c}$.
            </p>

            <p>
                Tento príklad svedčí o tom, že vhodnou úpravou výrazu môžeme získať významnú informáciu.
            </p>
        </div>

        <h3><mark>Poznámka.</mark></h3>
        <p>
            Tvar $\bf{(^*)}$ svedčí o tom, že keby sme výraz  $\bf{- a^4 – b^4 – c^4 + 2a^2b^2 + 2b^2c^2 + 2c^2a^2}$
            delili výrazmi $\bf{a + b + c, – a + b + c,  a – b + c,  a + b – c}$ dostávali by sme nulové zvyšky.
        </p>

        <div class="priklad">
            <h3>Príklad 7.</h3>
            <p>
                Vieme, že: $\bf{a^2 – b^2 = (a – b)(a + b)}$ a $\bf{a^3 – b^3 = (a – b)(a^2 + ab + b^2)}$. Vyslovte
                hypotézu o deliteľnosti výrazu $\bf{a^n – b^n}$ výrazom $\bf{a – b}$ a dokážte ju matematickou indukciou.
            </p>

            <h3>Riešenie:</h3>
            <p>
                Najprv rozložíme výraz $\bf{a^4 – b^4}$.

                $$\bf{a^4 - B^4 = (a^2-b^2)(a^2+b^2) = (a-b)(a+b)(a^2+b^2) = (a - b)(a^3+a^2b + ab^2 + b^3)}$$
            </p>

            <p>
                Odtiaľto je už len krôčik k hypotéze:

                $$\bf{\bbox[yellow, 5px]{\forall n \in N: a^n - b^n = (a-b)(a^{n-1} + a^{n -2}b + ... + ab^{n-2}+b^{n-1})} \qquad (H) }$$
            </p>

            <p>
                Hypotézu $(H)$ dokážeme matematickou indukciou:
                <br>
                Výraz v 2.zátvorke označme $\bf{D_n}$. Teda $\bf{D_n = \sum_{k = 0}^{n-1}a^{n-1-k}b^k }$
            </p>

            <p>
                Naša hypotéza má teraz podobu:
                $$\bf{\forall n \in N: a^n - b^n = (a - b)D_n \qquad (H)}$$
            </p>

            <p>
                Uvedomme si, že pre každé $m$ väčšie ako $1$ platí: $\bf{a \cdot D_m + b^m = D_{m+1}}$
                <ol>
                    <li>
            <p>
                Hypotéza $(H)$ pre $n = 2$ zrejme platí.
            </p>
            </li>

            <li>
                <p>
                    Nech $\bf{a^m – b^m = (a – b)D_m}$ (indukčný predpoklad). Potom:
                    $$\bf{a^{m+1} - b^{m+1} = a^{m+1} -ab^m + ab^m - b^{m+1} = a(a^m - b^m) + b^m(a-b)=}$$
                    $$\bf{a(a-b)D_m + b^m(a-b) = (a-b)(aD_m + b^m) = (a-b)D_{m+1} }$$
                    čo sme chceli dokázať.
                </p>
            </li>
            </ol>

            </p>
        </div>


    </section>

    <div class="pagination">
        <a href="A22_3.php">&laquo;</a>
        <a  href="A22_1.php">1</a>
        <a  href="A22_2.php">2</a>
        <a   href="A22_3.php">3</a>
        <a class="active" href="A22_4.php">4</a>
        <a href="A22_5.php">5</a>

        <a href="A22_5.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
