<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA22.html');
?>

<div class="item2">
    <h2>2.2 Úpravy výrazov</h2>

    <section>

        <div class="priklad">
            <h3>Príklad 8.</h3>

            <p>
                Sčítajte zlomky: $\bf{\frac{1}{x+1} + \frac{2}{x-2} + \frac{3}{x+3} + \frac{4}{x-4}}$


            </p>

            <h3>Riešenie:</h3>
            <p>
                I keď to znie paradoxne, pre naše účely bude vhodnejšie vyriešiť nie túto konkrétnu úlohu, ale
                všeobecnejšiu úlohu, sčítať zlomky:
                $$\bf{\frac{A}{x-a} + \frac{B}{x-b} + \frac{C}{x-c} + \frac{D}{x-d}}$$
            </p>

            <p>
                Po úprave na spoločného menovateľa dostávame :
                $$\bf{\frac{A(x-b)(x-c)(x-d) + B(x-a)(x-c)(x-d) + C(x-a)(x-b)(x-d) + D(x-a)(x-b)(x-c)}{(x-a)(x-b)(x-c)(x-d)}}$$

            </p>

            <p>
                Po roznásobení by sme v čitateli dostali polynóm 3.stupňa:
                $$\bf{K_3x^3 + K_2x^2 + K_1x + K_0}$$
            </p>

            <p>
                Skúsme bez otrockého roznásobovania priamo vyjadriť jeho koeficienty:
                $$\bf{K_3 = A + B + C + D}$$
                $$\bf{K_2 = - [A(b+c+d) + B(a+c+d) + C(a+b+d) + D(a+b+c)]}$$
                $$\bf{K_1 = A(bc+cd+db) + B(ac+cd+da) + C(ab+bd+da) + D(ab+bc+ca)}$$
                $$\bf{K_0 = - (Abcd + aBcd + abCd + abcD)}$$
            </p>

            <p>
                „Elegancia“ výrazov $\bf{K_i}$ by pri riešení konkrétneho príkladu dostatočne nevynikla.
                Roznásobením činiteľov v menovateli dostávame:
                $$\bf{(x-a)(x-b)(x-c)(x-d) = }$$
                $$\bf{= x^4 - (a+b+c+d)x^3 + (ab+ac+ad+bc+bd+cd)x^2 - (abc+abd+acd+bcd)x+abcd}$$
            </p>

            <p>
                Dôležitosť poslednej rovnosti, t. j. vzťahy medzi koreňmi a koeficientmi polynomickej rovnice od čias
                pána Vieta netreba zdôrazňovať.
            </p>

            <p>
                Ak teraz do všeobecných výsledkov dosadíme konkrétne údaje z nášho príkladu, dostaneme:
                $$\bf{\frac{1}{x+1} + \frac{2}{x-2} + \frac{3}{x+3} + \frac{4}{x-4} = \frac{10x^3 - 10x^2 - 50x}{x^4 - 2x^3 - 13x^2 + 14x + 24}}$$
            </p>
        </div>

        <br>
        <div class="uloha">
            <h3>Úlohy</h3>
            <ol start="4">
                <li>
                    <p>
                        Vydeľte $\bf{(-a^4 - b^4 - c^4 + 2a^2b^2 + 2b^2c^2 + 2c^2a^2) : (a+b+c)}$
                    </p>
                </li>

                <li>
                    <p>
                        Dokážte, že $\bf{\forall a,b,c \in R^+: \frac{3}{\frac{1}{a} + \frac{1}{b} + \frac{1}{c}} \leq \sqrt[3]{abc} \leq \frac{a + b + c}{3} }$
                    </p>

                    <p>
                        (Jednotlivé výrazy voláme <b>harmonický, geometrický a aritmetický</b> priemer troch čísel.)
                    </p>
                </li>

                <li>
                    <p>
                        Dokážte, že $\bf{\forall a,b,c \in R: a^2b^2 + b^2c^2 + c^2a^2 - a^2bc - ab^2c - abc^2 \geq 0}$
                    </p>
                </li>

                <li>
                    <p>
                        Všimnite si, že platí: $\bf{\forall a,b \in R: a^3 + b^3 = (a+b)(a^2 - ab + b^2)}$ Vyslovte hypotézu
                        o deliteľnosti výrazu $\bf{a^{2k-1} + b^{2k-1}$ výrazom $\bf{a + b}$ a dokážte ju matematickou indukciou.
                    </p>
                </li>

                <li>
                    <p>
                        Nájdite také reálne čísla $\bf{A, B, C, D,}$ aby platilo:
                        $$\bf{\frac{10x^3 - 70x^2 + 150x - 96}{(x-1)(x-2)(x-3)(x-4)} = \frac{A}{x-1} + \frac{B}{x-2} + \frac{C}{x-3} + \frac{D}{x-4} }$$
                    </p>
                </li>
            </ol>

        </div>

        <p>
            Na záver tejto kapitoly si pozrime jednu tabuľku:
            $$\bbox[lightgray, 5px]{f(n) = a \cdot n^3 + b \cdot n^2 + c \cdot n + d}$$
            $$\begin{array}{|c|c|}
            \hline \cellcolor{#e8eeec} & \cellcolor{#e8eeec}{a = 1.00} &  \cellcolor{#e8eeec}{b = 1.00} &  \cellcolor{#e8eeec}{c = 1.00} &  \cellcolor{#e8eeec}{d = 1.00} \\
            \hline \cellcolor{lightgray}n &  \cellcolor{lightgray} f(n) &  \cellcolor{lightgray} \Delta &  \cellcolor{lightgray} \Delta \Delta &  \cellcolor{lightgray} \Delta \Delta \Delta \\
            \hline \cellcolor{#e8eeec} 0 & \cellcolor{#e8eeec} 1 & \cellcolor{#e8eeec} 3 & \cellcolor{#e8eeec} 8 & \cellcolor{#e8eeec} 6 \\
            \hline \cellcolor{lightgray}1 & \cellcolor{lightgray}4 & \cellcolor{lightgray}11 & \cellcolor{lightgray}14 & \cellcolor{lightgray}6 \\
            \hline \cellcolor{#e8eeec} 2 & \cellcolor{#e8eeec} 15 & \cellcolor{#e8eeec} 25 & \cellcolor{#e8eeec} 20 & \cellcolor{#e8eeec} 6 \\

            \hline \cellcolor{lightgray}3 & \cellcolor{lightgray}40 & \cellcolor{lightgray}45 & \cellcolor{lightgray}26 & \cellcolor{lightgray}6 \\
            \hline \cellcolor{#e8eeec} 4 & \cellcolor{#e8eeec} 85 & \cellcolor{#e8eeec} 71 & \cellcolor{#e8eeec} 32 & \cellcolor{#e8eeec} 6 \\

            \hline \cellcolor{lightgray}5 & \cellcolor{lightgray}156 & \cellcolor{lightgray}103 & \cellcolor{lightgray}38 & \cellcolor{lightgray}6 \\
            \hline \cellcolor{#e8eeec} 6 & \cellcolor{#e8eeec} 259 & \cellcolor{#e8eeec} 141 & \cellcolor{#e8eeec} 44 & \cellcolor{#e8eeec} 6 \\

            \hline \cellcolor{lightgray}7 & \cellcolor{lightgray}400 & \cellcolor{lightgray}185 & \cellcolor{lightgray}50 & \cellcolor{lightgray}6 \\
            \hline \cellcolor{#e8eeec} 8 & \cellcolor{#e8eeec} 585 & \cellcolor{#e8eeec} 235 & \cellcolor{#e8eeec} 56 & \cellcolor{#e8eeec} \\

            \hline \cellcolor{lightgray}9 & \cellcolor{lightgray}820 & \cellcolor{lightgray}291 & \cellcolor{lightgray} & \cellcolor{lightgray} \\
            \hline \cellcolor{#e8eeec} 10 & \cellcolor{#e8eeec} 1111 & \cellcolor{#e8eeec}  & \cellcolor{#e8eeec}  & \cellcolor{#e8eeec}  \\ \hline
            \end{array}$$
        </p>

        <p>
            Je to výňatok z väčšej tabuľky, ktorú nájdete v zošite Diferencie.
            <details class="detail"><summary class="summary"><b>Diferencie</b></summary><br>
                <div class="center2" >
                    <iframe scrolling="no" title="A2.05" src="https://www.geogebra.org/material/iframe/id/spcprjmt/width/1000/height/916/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="1000px" height="916px" style="border:0px;"> </iframe>
                </div>
            </details>

            Sú v nej v 2. stĺpci hodnoty mnohočlena 3. stupňa,
            ktorého koeficienty $\bf{a, b, c, d}$ sú v záhlaví. V 3. stĺpci sú rozdiely (diferencie) hodnôt 2. stĺpca, v 4. stĺpci
            sú diferencie hodnôt z 3. stĺpca (čiže diferencie z diferencií, alebo diferencie 2. rádu) a v poslednom stĺpci
            sú diferencie 3. rádu. Otvorte si tento zošit, voľte si rôzne hodnoty koeficientov polynómu a sledujte zmeny.
            Na záver vyriešte tieto úlohy:
        </p>

        <div class="uloha">
            <ol start="9">
                <li>
                    <p>
                        V zošite Diferencie zvoľte koeficienty $\bf{a, b, c, d}$ polynómu tak, aby tabuľka dostala tvar
                        uvedený v stĺpcoch $K, L, M$ a $N$.
                    </p>
                </li>

                <li>
                    <p>
                        Zmena koeficientov spôsobuje zmenu len v niektorých stĺpcoch tabuľky. Popíšte v ktorých.
                    </p>
                </li>

                <li>
                    <p>
                        Označme $\bf{f(n) = a \cdot n^3 + b \cdot n^2 + c \cdot n + d, \; \Delta f(n) = f(n+1)-f(n), \;}$
                        $\bf{\Delta \Delta f(n) = \Delta f(n+1) - \Delta f(n), \; \Delta \Delta \Delta f(n) = \Delta \Delta f(n+1) - \Delta \Delta f(n)}$
                    </p>

                    <p>
                        Určte koeficienty všetkých týchto mnohočlenov a výsledky použite pri experimentovaní s tabuľkou
                        v zošite Diferencie.
                    </p>
                </li>
            </ol>
        </div>


    </section>

    <div class="pagination">
        <a href="A22_4.php">&laquo;</a>
        <a  href="A22_1.php">1</a>
        <a  href="A22_2.php">2</a>
        <a   href="A22_3.php">3</a>
        <a  href="A22_4.php">4</a>
        <a class="active" href="A22_5.php">5</a>

        <a href="A22_1.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
