<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA23.html');
?>

<div class="item2">
    <h2>2. Riešenia úloh</h2>

    <section>

        <h3>Úlohy z kapitoly 2.2</h3>
        <div class="uloha">

            <ol start="7">

                <li>
                    <p>
                        Hypotéza: $\bf{\bbox[yellow, 3px]{\forall k \in N, : a^{2k-1} + b^{2k-1} = (a+b)(a^{2k-2} - a^{2k-3}b + ... - ab^{2k-3}+b^{2k-2})} \qquad (H^*) }$
                    </p>

                    <p>
                        Hypotézu (H) dokážeme matematickou indukciou:
                    </p>

                    <p>
                        Výraz v 2. zátvorke (má $\bf{2k - 1}$ členov) označme $\bf{D_k}$. Teda $$\bf{D_k = \sum_{i = 0}^{k-1}(-1)^i a^{2k-2+i}b^i }$$
                    </p>

                    <p>
                        Naša hypotéza má teraz podobu:
                        $$\bf{\forall k \in N: a^{2k - 1} + b^{2k - 1} = (a + b)D_k \qquad (H^{**}) }$$
                    </p>
                    <p>
                        Uvedomme si, že pre každé $\bf{k \gt 1}$ platí:  $\bf{a^2 \cdot D_k – b^{2k-1}a + b^{2k} = D_{k+1}}$
                        <ol>
                            <li>
                    <p>
                        Hypotéza $(H)$ pre $n = 2$ zrejme platí.
                    </p>
                </li>

                <li>
                    <p>
                        Nech $\bf{a^{2k-1} + b^{2k-1} = (a + b)D_k}$ (indukčný predpoklad). Potom:
                        $$\begin{aligned}
                        &\bf{a^{2k - 1} + b^{2k + 1} = a^{2 k + 1} + a^2b^{2k-1} - a^2b^{2k-1} + b^{2k+1} = a^2(a^{2k-1}+b^{2k-1}) - a^2b^{2k-1} + b^{2k+1} = }\\
                        &\bf{= a^2(a+b)D_k - \bbox[yellow, 3px]{a^2b^{2k-1}} \bbox[lime, 3px]{-ab^{2k}} + \bbox[yellow, 3px]{ab^{2k}} + \bbox[lime, 3px]{b^{2k + 1}} = }\\
                        &\bf{= a^2(a+b)D_k + \bbox[yellow, 3px]{a(-ab^{2k-1} + b^{2k})} + \bbox[lime, 3px]{b(-ab^{2k-1} + b^{2k})} = a^2(a+b)D_k + (a+b)(-ab^{2k-1} + b^{2k}) = }\\
                        &\bf{= (a+b)(a^2 \cdot D_k - b^{2k-1} a + b^{2k}) = (a+b)D_{k+1}}
                        \end{aligned}$$
                        čo sme chceli dokázať.
                    </p>
                </li>
            </ol>
            </p>
            </li>

            <li>
                <p>
                    Podľa 8. príkladu súčet zlomkov
                    $$\bf{\frac{A}{x-a} + \frac{B}{x-b} + \frac{C}{x-c} + \frac{D}{x-d} }$$
                    Je rovný zlomku, ktorého čitateľ je $\bf{K_3x^3 + K_2x^2 + K_1x + K_0}$, pričom platí:
                    $$\begin{aligned}
                    &\bf{K_3 = A + B + C + D}\\
                    &\bf{K_2 = - [A(b+c+d) + B(a+c+d) + C(a+b+d) + D(a+b+c)]}\\
                    &\bf{K_1 = A(bc+cd+db) + B(ac+cd+da) + C(ab+bd+da) + D(ab+bc+ca)}\\
                    &\bf{K_0 = - (Abcd + aBcd + abCd + abcD)}
                    \end{aligned}$$
                </p>

                <p>
                    Ak dosadíme naše konkrétne hodnoty dostávame sústavu lineárnych rovníc:
                    $$\begin{aligned}
                    &\bf{K_3 = A + B + C + D = 10}\\
                    &\bf{K_2 = -9A - 8B - 7C - 6D = -70}\\
                    &\bf{K_1 = 26A + 19B + 14C + 11D = 150}\\
                    &\bf{K_0 = -24A -12B -8C -6D = -96}
                    \end{aligned}$$
                    Ktorá je vyriešená v 2. príklade kapitoly 3.2.
                </p>
            </li>

            <li>
                <p>
                    Po neúspešných pokusoch v zošite Diferencie sme došli k tomu, že koeficienty $\bf{a, b, c, d}$
                    polynómu $\bf{P(n) = a \cdot n^3 + b \cdot n^2 + c \cdot n + d}$ určíme z podmienok:
                    $$\begin{array}{cc}
                    \bf{P(0) =} & & & & & & & \bf{d=} & \bf{-1}\\
                    \bf{P(1) =} & \bf{a} &\bf{+} & \bf{b} & \bf{+} & \bf{c} & \bf{+} & \bf{d=} & \bf{0} \\
                    \bf{P(2) =} & \bf{8a} & \bf{+} & \bf{4b} & \bf{+} & \bf{2c} & \bf{+} & \bf{d=} & \bf{4}\\
                    \bf{P(3) =} & \bf{27a} & \bf{+} & \bf{9b} & \bf{+} & \bf{3c} & \bf{+} & \bf{d=} & \bf{13}\\
                    \end{array}$$
                </p>

                <details class="detail"><summary class="summary"><b>Diferencie</b></summary><br>
                    <div class="center2" >
                        <iframe scrolling="no" title="A2.05" src="https://www.geogebra.org/material/iframe/id/spcprjmt/width/1000/height/916/border/888888/sfsb/true/smb/true/stb/true/stbh/true/ai/true/asb/true/sri/true/rc/true/ld/true/sdz/true/ctl/true" width="1000px" height="916px" style="border:0px;"> </iframe>
                    </div>
                </details>
            </li>

            <li>
                <p>
                    Zmena koeficientu $\bf{a}$ spôsobuje zmenu vo všetkých stĺpcoch tabuľky, $\bf{b}$ nemá vplyv
                    na posledný stĺpec, $\bf{c}$ nemení posledné dva stĺpce a $\bf{d}$ mení len 1. stĺpec.
                </p>
            </li>

            <li>
                <p>
                    Ak $\bf{f(n) = a \cdot n^3 + b \cdot n^2 + c \cdot n + d}$, potom $\bf{\Delta f(n) = 3a \cdot n^2
                    + (3a+2b) \cdot n + (a+b+c)}$, $\bf{\Delta \Delta f(n) = 6a \cdot n + (8a +2b), \; \Delta
                    \Delta \Delta f(n) = 6a}$
                </p>
            </li>

            </ol>
        </div>
    </section>

    <div class="pagination">
        <a href="A23_3.php">&laquo;</a>
        <a href="A23_1.php">1</a>
        <a   href="A23_2.php">2</a>
        <a  href="A23_3.php">3</a>
        <a class="active" href="A23_4.php">4</a>


        <a href="A23_1.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
