<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA31.html');
?>

<div class="item2">
    <h2>3.1 Riešenie rovníc</h2>


    <section>
        <p>
            Vyriešiť (jednu) rovnicu s (jednou) neznámou $\bf{x}$ (ktorá nadobúda hodnoty z nejakej množiny $\bf{D}$,
            tzv. "oboru premennej
            <b><sup><dfn title="Ak to nieje uvedené, alebo to nevyplýva z kontextu úlohy, tak sa oborom premnnej chápe
                   množina všetkých reálnych čísel.">[1]</dfn>
                </sup></b>"), znamená nájsť všetky také hodnoty premennej (takzvané "korene" rovnice), pre ktoré
            platí:
        <ol>$\bf{Ľ(x) = P(x) \land x \in D}$, kde $\bf{Ľ(x)}$ aj $\bf{P(x)}$ sú výrazy premennej $\bf{x}$.</ol>
        </p>

        <p>
            V minulosti (kým neexistovali prostriedky výpočtovej techniky), matematici sa snažili vypracovať také metódy
            na riešenie rovníc, aby sa korene rovnice dali vyjadriť pomocou vzorcov obsahujúcich len koeficienty rovnice
            (a konštanty), v ktorých sa používajú len operácie sčitovania, násobenia, delenia a symboly odmocnín.
            Ich úsilie bolo korunované úspechom pre niektoré špeciálne rovnice. Napríklad poznáme vzorce na riešenie
            niektorých <b>polynomických</b> rovníc, t.j. rovníc typu:

        <ol>
            $\bbox[yellow, 5px]{\bf{a_nx^n + a_{n-1}x^{n-1}+...+ a_1x + a_0=0}}$, pokiaľ je $\bf{n \leq 4}$.
        </ol>
        </p>

        <p>
            Prípadom $\bf{n = 1}$ t.j. tzv. <b>lineárnymi</b> rovnicami a ich sústavami sa budeme zaoberať
            v nasledujúcich kapitolách.
        </p>

        <p>
            Všimnime si prípad $\bf{n = 2}$, t.j. riešenie ľubovoľnej <b>kvadratickej</b> rovnice:

        <ol>
            $\bbox[yellow, 5px]{\bf{a \cdot x^2 + b \cdot x + c = 0}}$
        </ol>
        </p>

        <p>
            Ak upravíme (spomeňme si na kapitolu II.2) pravú stranu (predpokladáme $\bf{a \neq 0}$):

            $$\bf{a \Biggl [ x^2 + \frac{b}{a}x \Biggr ] + c = a \Biggl [ \biggl( x + \frac{b}{2a} \biggr ) ^2
            - \frac{b^2}{4a^2} \Biggr ] + c =}$$
            $$\bf{a \biggl (x + \frac{b}{2a} \biggr )^2 - \frac{b^2}{4a} + c = a \biggl (x + \frac{b}{2a} \biggr )^2
            + \frac{4ac - b^2}{4a}}$$
        </p>

        <p>
        <ol>Dostávame rovnicu:</ol>

        $$\bf{\biggl (x + \frac{b}{2a} \biggr )^2 = \frac{b^2 - 4ac}{4a^2}}$$

        <ol>Ak je výraz <b><sup><dfn title="Voláme ho tiež diskriminant kvadratickej rovnice -> ax^2 + bx + c = 0">[2]
                    </dfn></sup></b>$\bf{b^2 - 4a \geq 0}$ môžeme písať</ol>

        $$\bf{\biggl (x + \frac{b}{2a} \biggr ) = \Biggl (\frac{\sqrt{b^2 - 4ac}}{2a} \Biggr )^2}$$

        <ol>Z čoho dostávame známy vzorec:</ol>

        $$\bbox[yellow, 5px]{\bf{x_{1,2} = \frac{-b \pm \sqrt{b^2 - 4ac}}{2a}}}$$
        </p>

        <p>
            Vidíme, že ak je $\bf{b^2 - 41 = 0}$, existuje len jeden koreň $\bf{\frac{-b}{2a}}$, ak je výraz
            $\bf{b^2 - 4a}$ záporný, rovnica nemá riešenie (v obore reálnych čísel). Ako môžete vidieť v zošite Qvzorec,
            vyriešiť kvadratickú rovnicu dokáže aj plechová škatuľa (počítač).
        </p>

        <details class="detail">
            <summary class="summary"><b>Qvzorec</b></summary><br>
            <div class="center2">
                <iframe scrolling="no" title="A3.01" src="https://www.geogebra.org/material/iframe/id/kznshdmn/width/944/height/400/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="400px" style="border:0px;"> </iframe>

            </div>
        </details>

        <p>
            Pripomeňme si, že vzorce na riešenie polynomických rovníc 3. stupňa (tzv. Cardanove) sme uviedli v kapitole I.4
            v súvislosti s históriou vzniku komplexných čísel, vzorce pre rovnice 4. stupňa môžete nájsť na
            <a href="http://mathworld.wolfram.com/QuarticEquation.html" target="_blank">
                http://mathworld.wolfram.com/QuarticEquation.html</a>.
        </p>

        <h3><mark>Poznámka 1.</mark></h3>

        <p>
            V prípade rovnice, pre ktorú nie je známy "recept" na bezprostredné vyjadrenie koreňov pomocou koeficientov
            rovnice, sa používajú tzv. <b>úpravy rovnice</b>. Presnejšie povedané, proces riešenia rovnice znamená
            zostrojenie takej postupnosti rovníc $\bf{Ľ_i(x) = P_i(x)}$, ktorá začína danou rovnicou a končí rovnicou,
            na ktorej riešenie už existuje štandardný postup. Pritom pre vzťah medzi jednotlivými členmi tejto postupnosti
            platí:

            $$\bf{Ľ_i(x) = P_i(x) \Rightarrow Ľ_{i+1}(x) = P_{i+1}(x)}$$
        <ol>alebo</ol>
        $$\bf{Ľ_i(x) = P_i(x) \iff Ľ_{i+1}(x) = P_{i+1}(x)}$$
        </p>

        <p>
            V prvom prípade hovoríme, že sme použili "dôsledkovú úpravu", v druhom prípade hovoríme o "ekvivalentnej
            úprave". Ak sme v procese riešenia rovnice použili čo len jednu neekvivalentnú úpravu, musíme urobiť
            tzv. skúšku, t.j. presvedčiť sa, či korene výslednej rovnice $\bf{Ľ_n(x) = P_n(x)}$ sú koreňmi danej rovnice
            $\bf{Ľ(x) = P(x)}$
        </p>

        <div class="priklad">
            <h3>Príklad 1<b><sup><dfn title="Pozri príklad 9. z kapitoly II.1.">[3]</dfn>
                    </sup></b>.</h3>

            <p>
                Tridsaťštyri žiakov 1.B si kúpilo lístky do kina. Za lacnejšie zaplatili spolu $\bf{1470 Sk}$ a za drahšie
                (každý bol drahší o $\bf{30 Sk}$) $\bf{1300 Sk}$. Určte koľko stáli oba druhy lístkov a koľko žiakov si ich
                kúpilo.
            </p>

            <h3>Riešenie: </h3>

            <p>
                Rovnicu ľahko zostavíme, ak si vstupné údaje zoradíme do tabuľky:

                $$\begin{array} {|c|c|c|c|}
                \hline & \bbox[yellow]{Lacnejšie} & O \: 30 \: Sk \: drahšie & Spolu \\
                \hline Jednotková \: cena & \bf{x} & \bf{x + 30} & \bf{\emptyset} \\
                \hline Cena \: spolu & \bf{1470} & \bf{1300} & \bf{247} \\
                \hline Počet \: lístkov & \bf{\frac{1470}{x}} & \bf{\frac{1300}{x + 30}} & \bf{34} \\
                \hline
                \end{array}$$
            </p>

            <p>
                Dostávame rovnicu $\bf{\frac{1470}{x} + \frac{1300}{x + 30} = 34}$, alebo po úprave
                $\bf{17x^2 - 875x - 22 050 = 0}$.
            </p>

            <p>
                Posledná rovnica má dva korene, vzhľadom na kontext úlohy nás zaujíma iba kladný a ten je $\bf{70}$
                <b><sup><dfn title="Každý kladný koreň poslednej rovnice je aj
                              koreňom pôvodnej rovnice, preto sme skúšku nerobili.">[4]</dfn>
                    </sup></b>. Po dosadení za $\bf{x}$ do tabuľky dostávame, že drahšie lístky boli za $\bf{100 Sk}$ a kúpilo
                si ich $\bf{13}$ žiakov, kým lacnejšie si kúpilo $\bf{21}$ žiakov.
            </p>
        </div>

        <h3><mark>Poznámka 2.</mark></h3>

        <p>
            O riešení rovníc typu $\bf{Ľ(x) = 0}$, kde $\bf{Ľ(x)}$ je výraz obsahujúci nejakú špeciálnu funkciu (napr.
            exponenciálnu, logaritmickú, goniometrickú) budeme hovoriť v kapitolách zaoberajúcich sa týmito funkciami.
        </p>

        <p>
            V prípade polynomických rovníc viac ako 4. stupňa vzorec na určenie koreňov neexistuje. Nie preto, že by sme ho
            dosiaľ nepoznali, ale preto že existovať nemôže
            <sup>[<a href="https://mathshistory.st-andrews.ac.uk/Biographies/Galois/" target="_blank">
                    <dfn title="Ako to dokázal mladý francúzsky matematik Evariste Galois už v roku 1830.">
                        5</dfn></a>]</sup>. Rovnako pri riešení mnohých reálnych problémov ich matematizácia vedie
            k rovnici, na riešenie ktorej nepoznáme žiaden algoritmus, ktorý by po konečnom počte úprav viedol k rovnici,
            ktorej riešenie sa dá "presne" vyjadriť. Na niekoľkých príkladoch ukážeme niektoré metódy, pomocou ktorých sa
            dajú nájsť približné riešenia takýchto rovníc. Spoločnou črtou týchto metód je to, že hľadané riešenie môžeme
            vypočítať s ľubovoľnou presnosťou.
        </p>



    </section>

    <div class="pagination">
        <a href="A31_3.php">&laquo;</a>
        <a class="active" href="A31_1.php">1</a>
        <a href="A31_2.php">2</a>
        <a  href="A31_3.php">3</a>



        <a href="A31_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
