<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA31.html');
?>

<div class="item2">
    <h2>3.1 Riešenie rovníc</h2>


    <section>
        <h3><mark>Poznámka 4.</mark></h3>
        <p>
            Nájdite reálne číslo, ktorého štvorec zväčšený o trojnásobok tohto čísla je rovný číslu $1$, t. j.
            vyriešte rovnicu: $x^2 + 3x = 1$. Výsledkom „presného“ riešenia sú čísla
            $$\bf{x_{1,2} = \frac{-3 \pm \sqrt{13}}{2}} \qquad (^*).$$
        </p>

        <p>
            Že je to „presné“ riešenie je iba klam. Vzťah $(^*)$ nehovorí nič iné, iba to, že „hľadané číslo vynásobené
            dvoma a zväčšené o $3$ dá po umocnení na druhú číslo $13$“. My sme iba daný problém previedli na problém
            „nájsť číslo, ktorého druhá mocnina je $13$“. A ten sa nedá vyriešiť „presne“ žiadnym konečným spôsobom výpočtu.
            Preto odpor voči približným riešeniam, ktorý majú niektorí matematici – na rozdiel od fyzikov a inžinierov,
            je zbytočný.
        </p>

        <h3><mark>Poznámka 5.</mark></h3>
        <p>
            <mark style="background-color:cyan">„Není hodno výtečných mužů, aby mařili celé hodiny jako otroci výpočetní dřinou, která by mohla být
                bezpečně svěřena komukoli jinému, kdyby se používaly stroje.“</mark>
        </p>

        <p>
            Týmito slovami zdôvodňoval Gottfried Wilhelm von Leibniz
            v roku 1672 svoje pokusy o zostrojenie mechanického kalkulátora.  Zoberme si poučenie z jeho slov a ponechajme
            strojom to, čo patrí strojom a ľuďom to, čo patrí ľuďom. Toho čo môže urobiť (zatiaľ?) len človek je aj tak
            stále dosť. Preto nepovažujeme za vhodné drezírovať žiakov v riešení najrôznejších druhov rovníc, ale za podstatnú
            matematickú kompetenciu považujeme schopnosť matematizovať daný problém, schopnosť zostaviť rovnicu, ktorej
            korene sú riešením problému, resp. nájsť funkciu, ktorej optimálne (pre daný účel) hodnoty sú riešením problému.
            Toto chceme zdôrazniť aj v nasledovných príkladoch.
        </p>

        <div class="priklad">
            <h3>Príklad 3.</h3>
            <p>
                (pozri Príklad 3. z kapitoly II.1)
            </p>

            <p>
                Z kruhového výseku kruhu s polomerom $\bf{R}$ zostrojíme plášť kužeľa (pozri obr.). Určte pre akú veľkosť
                $\bf{\varphi}$ stredového uhla tohto výseku bude objem zostrojeného kužeľa rovný $$\bf{\biggl(\frac{R}{2}\biggr)^3}$$
            <div class="center2"><img src="photo/p49.png" alt="obrazky"></div>
            </p>

            <p>
                Obvod podstavy hľadaného kužeľa je zrejme $\bf{r = \frac{\varphi R}{2 \pi} }$ a podľa Pytagora pre výšku $\bf{v}$
                hľadaného kužeľa platí:
                $$\bf{v = \sqrt{R^2 - r^2} = \sqrt{R^2 - \biggl(\frac{\varphi R}{2 \pi}\biggr)^2} }$$
                Použijúc vzorec pre objem kužeľa dostávame :
                $$\bf{V(\varphi) = \bbox[yellow, 3px]{\frac{\pi}{3} \cdot \biggl(\frac{\varphi R}{2 \pi}\biggr)^2 \cdot \sqrt{R^2 - \biggl(\frac{\varphi R}{2 \pi}\biggr)^2}}}$$
            </p>

            <p>
                Keď ako premennú použijeme pomer $\bf{k = \frac{\varphi}{2 \pi} }$, dostaneme:
                $$\bf{V(k) = \bbox[yellow, 3px]{\frac{\pi}{3} \cdot R^3 k^2 \cdot \sqrt{1 - k^2} } }$$
                a máme rovnicu :
                $$\bf{\bbox[yellow, 3px]{\frac{\pi}{3} \cdot k^2 \cdot \sqrt{1-k^2}} = \bbox[yellow, 3px]{\biggl(\frac{1}{2}\biggr)^3} k \in (0;1) }$$
            </p>

            <p>
                Lepšie je upraviť pôvodnú rovnicu na tvar $\bf{\bbox[yellow, 3px]{8\pi \cdot k^2 \cdot \sqrt{1-k^2} - 3 = 0 } }$.
            </p>

            <p>
                Pohľad na graf
            <div class="center2"><img src="photo/p50.png" alt="obrazky"></div>
            nás upozorňuje na dve riešenia, ktoré môžeme získať ako nulový bod grafu funkcie, ktorá je ľavou stranou rovnice.
            Ak si otvoríte  G11, program DeadLine  Vám ponúkne riešenie
            $\bf{k_1 = 0,35751013, k_2 = 0,99263493}$, čo je prevedení na stupne $\bf{\varphi_1 = 128,7^\circ, \varphi_2 = 357,336^\circ}$ .
            </p>

            <details class="detail">
                <summary class="summary"><b>G11</b></summary><br>
                <div class="center2" id="bfaw9mda"></div>
            </details>

            <p>
                Druhé riešenie je pomerne nečakané.
            </p>
        </div>

        <h3>Problém.</h3>
        <p>
            Máme k dispozícii kartón v tvare kruhu s polomerom $1 \; dm$. Porovnajme dve možnosti:

            <ul>
                <li>
        <p>
            kartón rozdelíme na dva polkruhy a z každého urobíme kornútik, t. j. nádobu tvaru kužeľa (pozri predchádzajúci príklad),
        </p>
        </li>

        <li>
            <p>
                do kruhu vpíšeme pravidelný n–uholník, a z neho urobíme (vystrihnutím deltoidov z jeho rožkov
                a ohnutím prečnievajúcich častí) škatuľku tvaru pravidelného n–bokého hranola, ako vidíme na
                obr. dolu. Deltoidy vystrihneme tak, aby podstava vzniknuvšieho hranola bola rozmerovo dve
                tretiny z pôvodného pravidelného n–uholníka.

            </p>
        </li>
        </ul>
        <div class="center2"><img src="photo/p51.png" alt="obrazky"></div>
        </p>

        <p>
            Otázka znie. Môže byť objem takto vzniknuvšieho pravidelného hranola väčší ako súčet objemov kornútikov?
            Ak áno, tak pre aké $n$?
        </p>

        <p>
            (Uvedomte si, že jedinou premennou v našom probléme je $\bf{n}$.)
        </p>

        <div class="uloha">
            <h3>Úlohy</h3>
            <ol>
                <li>
                    <p>
                        Určte pomer strán pravouholníka, ak pre jeho obvod $\bf{o}$ a obsah $\bf{P}$ platí: $\bf{o^2 = 32 \cdot P}$
                    </p>
                </li>

                <li>
                    <p>
                        Na rovine je položená guľa s jednotkovým polomerom. Je prikrytá plášťom kužeľa tak že guľa
                        je vpísaná do kužeľa. Určte:

                        <ol start="a">
                            <li>
                    <p>
                        polomeru $\bf{r}$ podstavy kužeľa,
                    </p>
                </li>

                <li>
                    <p>
                        výšku $\bf{v}$ kužeľa,
                    </p>
                </li>

                <li>
                    <p>
                        veľkosť uhla $\bf{\alpha}$ , ktorý zvierajú povrchové priamky kužeľa s jeho osou,
                    </p>
                </li>
            </ol>
            ak viete, že obsah plášťa je $\bf{\frac{20}{3}\pi}$. (Pozrite si Príklad 4. z kapitoly 2.1)
            </p>
            </li>

            <li>
                <p>
                    Pozrite si Príklad 8. z kapitoly II.1 a vyriešte rovnicu:
                    $$\bf{\frac{d - x}{\sqrt{(d-x)^2 + b^2}} = 2 \cdot \frac{x}{\sqrt{x^2 + a^2}}}$$
                </p>

                <p>
                    Zvoľte si hodnoty parametrov $\bf{d = 7, a = 4, b = 3}$.
                </p>
            </li>

            <li>
                <p>
                    Pozrite si Príklad 9. z kapitoly II.1 a vyriešte rovnicu:
                    $$\bf{\bbox[yellow, 3px]{\frac{15000}{x-200} + \frac{33750}{x-100} + \frac{104000}{x} + \frac{75650}{x+100} + \frac{16800}{x+200} = 800}, x \gt 200}$$
                </p>
            </li>

            <li>
                <p>
                    Pomocou tzv. iteračnej metódy vyriešte rovnicu:
                    $$\bf{x^5 = 0.5x + 0.1}$$
                </p>
            </li>

            <li>
                <p>
                    Pozrite si Príklad 5. z kapitoly II.1 a vyriešte rovnice:

                    $$\bf{\bbox[cyan, 3px]{4x(2\sqrt{1-x^2} - x) = \frac{\pi}{2}}} \; \text{, resp}
                    \; \bf{\bbox[cyan, 3px]{4 \cdot \sin \alpha(2 \cdot \cos \alpha - \sin \alpha) = \frac{\pi}{2} } }$$
                </p>

                <p>
                    Treba dodať, že $\bf{x \in (0;1) \text{,} \; \alpha \in (0; \frac{\pi}{2})}$
                </p>
            </li>


            </ol>
        </div>

        <h3><mark>Poznámka 6.</mark></h3>
        <p>
            Pri riešení rovníc v predchádzajúcich úlohách použite niektorú z metód použitých pri riešení príkladov 2. a 3.
        </p>





    </section>

    <div class="pagination">
        <a href="A31_2.php">&laquo;</a>
        <a  href="A31_1.php">1</a>
        <a href="A31_2.php">2</a>
        <a  class="active"  href="A31_3.php">3</a>



        <a href="A31_1.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"bfaw9mda", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('bfaw9mda');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
