<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA32.html');
?>

<div class="item2">
    <h2>3.2 Sústavy lineárnych rovníc</h2>


    <section>
        <p>
            Medzi najrôznejšími druhmi rovníc hrajú významnú úlohu lineárne rovnice a ich sústavy. Uvedieme niekoľko
            príkladov, ktoré vedú k problému riešenia nejakej sústavy lineárnych rovníc.
        </p>


        <div class="priklad">
            <h3>Príklad 1.</h3>

            <p>
                Spočítajte $\bf{1^2 + 2^2 + 3^2 + 4^2 + ... + n^2}$
            </p>

            <h3>Riešenie:</h3>

            <p>
                Označme súčet štvorcov prvých $\bf{n}$ prirodzených čísel ako $\bf{S^2_n}$ a napíšme do prvého riadku tabuľky
                niekoľko členov tejto postupnosti:

                $$\begin{array}
                {:r:r:}
                \hdashline 1 && 5 && 14 && 30 && 55 && 91 && 140 && 204 && 285 && 385 \\
                \hdashline & 4 && 9 && 16 && 25 && 36 && 49 && 64 && 81 && 100 & \\
                \hdashline
                \end{array}$$
            </p>

            <p>
                Pre jednoduchosť sme v 2. riadku uviedli, čo treba k členu postupnosti pripočítať, aby vznikol ďalší člen.
                Teda v 2. riadku sú rozdiely čísel z 1. riadku. Vzorec pre postupnosť prvok 1. riadku nepoznáme, kým vzorec
                pre postupnosť prvkov 2. riadku je jasný - sú to štvorce prirodzených čísel. Skúsme tabuľku rozšíriť
                <b><sup><dfn title="Tento nápad poznal už G.W. Leibniz. Spomeňte si tiež na zošit Diferencie zo záveru
                                    kapitoly o úpravách výrazov.">[1]</dfn>
                    </sup></b>"
                o 3. riadok, tvorený rozdielmi prvkov z 2. riadku a ešte o 4. riadok, tvorený rozdielmi prvkov z 3. riadku:

                $$\begin{array}
                {:r:r:}
                \hdashline 1 && 5 && 14 && 30 && 55 && 91 && 140 && 204 && 285 && 385 \\
                \hdashline & 4 && 9 && 16 && 25 && 36 && 49 && 64 && 81 && 100 & \\
                \hdashline && 5 && 7 && 9 && 11 && 13 && 15 && 17 && 19 &&\\
                \hdashline &&& 2 && 2 && 2 && 2 && 2 && 2 && 2 &&&\\
                \hdashline
                \end{array}$$
            </p>


            <p>
                Po prezretí tabuľky môžeme konštatovať, že 4. riadok je konštantná funkcia, 3. riadok je lineárna funkcia,
                2. riadok je kvadratická funkcia a preto je zrejme 1. riadok kubická funkcia. Prečo môžeme vysloviť hypotézu:

                $$\bf{S^2_n = A n^3 + B n^2 + C n + D} \qquad (H)$$
            </p>

            <p>
                Neznáme koeficienty $a_i$ vypočítame tak, že do predpisu $(H)$ dosadíme za $n$ čísla $1$ až $4$ a výsledok
                porovnáme s prvými štyrmi členmi postupnosti. Dostaneme tak sústavu rovníc:

                $$\begin{array}
                {:r:r:}
                \hdashline & A+ && B+ && C+ & D= & 1\\
                \hdashline 8 & A+ & 4 & B+ & 2 & C+ & D= & 5\\
                \hdashline 27 & A+ & 9 & B+ & 3 & C+ & D= & 14\\
                \hdashline 64 & A+ & 16 & B+ & 4 & C+ & D= & 30\\
                \hdashline
                \end{array}\qquad(S)$$
            </p>
        </div>
        <br>
        <div class="priklad">
            <h3>Príklad 2.</h3>

            <p>
                Funkciu $\bf{y = \frac{10x^3 - 70x^2 + 150x - 96}{(x - 1)(x - 2)(x - 3)(x - 4)}} \qquad (1)$
            </p>

            <p>
                chceme napísať v tvare:

                $$\bf{y = \frac{A}{(x - 1)} + \frac{B}{(x - 2)} + \frac{C}{(x - 3)} + \frac{D}{x - 4}} \qquad (2)$$

                po sčítaní zlomkov vo výraze $(2)$ a porovnaní čitateľa s čitateľom výrazu $(1)$ sme dostali nasledovnú
                sústavu rovníc pre neznáme koeficienty $A$, $B$, $C$, $D$:

                $$\begin{array}
                {:r:r:}
                \hdashline & A+ && B+ && C+ && D= & 10\\
                \hdashline 9 & A+ & 8 & B+ & 7 & C+ & 6 & D= & 70\\
                \hdashline 26 & A+ & 19 & B+ & 14 & C+ & 11 & D= & 150\\
                \hdashline 24 & A+ & 12 & B+ & 8 & C+ & 6 & D= & 96\\
                \hdashline
                \end{array}\qquad(D)$$

            </p>

            <p>
                Vedeli by ste ju vyriešiť?
            </p>

            <p>
                Pravdepodobne nie. Ale iste by ste vedeli "vyriešiť" spamäti sústavu rovníc:

                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 2px] A &&&&&&& \bbox[yellow, 2px] = & \bbox[yellow, 2px] 1 \\
                \hdashline && \bbox[yellow, 2px] B &&&&& \bbox[yellow, 2px] = & \bbox[yellow, 2px] 2 & && \bbox[yellow, 2px]{(1)} \\
                \hdashline &&&& \bbox[yellow, 2px] C &&& \bbox[yellow, 2px] = & \bbox[yellow, 2px] 3 \\
                \hdashline &&&&&& \bbox[yellow, 2px] D & \bbox[yellow, 2px] = & \bbox[yellow, 2px] 4\\
                \hdashline
                \end{array}

            </p>

            <p>
                Takže jediným problémom pri riešení sústav lineárnych rovníc je, ako z danej sústavy $\bf{(D)}$ získať takú
                sústavu "typu" $\bf{(1)}$, ktorá má rovnaké riešenie ako sústava $\bf{(D)}$.
            </p>

            <p>
                Čím sa líšia tieto sústavy rovníc?

                \begin{array}
                {:c:c:}
                \hdashline A &&&&&&& = & 1 &&&&&&&& B &&&&& = & 2 \\
                \hdashline && B &&&&& = & 2 & && {(1)} &&& A &&&&&&& = & 1 &&& (2) \\
                \hdashline &&&& C &&& = & 3 &&&&&&&&&& C &&& = & 3 \\
                \hdashline &&&&&& D & = & 4 &&&&&&&&&&&& D & = & 4\\
                \hdashline
                \end{array}
            </p>

            <p>
                Zrejme majú rovnaké riešenia, pretože sústava rovníc je konjunkciou jednotlivých rovníc a tá je komutatívna.
                Preto môžeme sformulovať takúto ekvivalentnú úpravu sústav lineárnych rovníc:
            </p>

            <h3>U 1</h3>

            <p><b><mark style="background-color: yellow">
                        Výmena ľubovoľných dvoch rovníc sústavy je ekvivalentná úprava.
                    </mark></b></p>

            <p>
                Všimnime si teraz tieto sústavy rovníc:

                \begin{array}
                {:c:c:}
                \hdashline A &&&&&&& = & 1 &&&&&& A &&&&&&& = & 2 \\
                \hdashline && B &&&&& = & 2 & && {(1)} &&&&& 3 \cdot B &&&&& = & 3 \cdot 2 &&& (3) \\
                \hdashline &&&& C &&& = & 3 &&&&&&&&&& C &&& = & 3 \\
                \hdashline &&&&&& D & = & 4 &&&&&&&&&&&& D & = & 4\\
                \hdashline
                \end{array}

                Zrejme sú ekvivalentné, 1., 3. a 4. rovnicu majú rovnakú a 2. rovnica sústavy $(1)$ je ekvivalentná
                s 2. rovnicou sústavy $(3)$. Preto môžeme sformulovať ďalšiu úpravu:
            </p>

            <h3>U 2</h3>

            <p><b><mark style="background-color: yellow">
                        Vynásobenie ľubovoľnej rovnice sústavy ľubovoľným nenulovým číslom je ekvivalentná úprava.
                    </mark></b></p>

            <p>
                Zaujímavé je porovnanie týchto dvoch sústav lineárnych rovníc:

                \begin{array}
                {:c:c:}
                \hdashline A &&&&&&& = & 1 &&&&&& A &&&&&&& = & 2 \\
                \hdashline && B &&&&& = & 2 & && (1) &&& A & + & B &&&&& = & 1 + 2 &&& (4) \\
                \hdashline &&&& C &&& = & 3 &&&&&&&&&& C &&& = & 3 \\
                \hdashline &&&&&& D & = & 4 &&&&&&&&&&&& D & = & 4\\
                \hdashline
                \end{array}

                Sústava $(4)$ je zrejme dôsledkom sústavy $(1)$, pretože sústavy sa líšia len v 2. rovnici, pričom 2. rovnica
                sústavy $(4)$ je dôsledkom (súčtom) 1. a 2. rovnice sústavy $(1)$.
            </p>

            <p>
                Všimnime si postupnosť úprav:

                \begin{array}
                {:c:c:}
                \hdashline A &&&&&&& = & 1 &&&&&& -A &&&&&&& = & -1 \\
                \hdashline A & + & B &&&&& = & 1 + 2 & && (4) &&& A & + & B &&&&& = & 1 + 2 &&& (5) \\
                \hdashline &&&& C &&& = & 3 &&&&&&&&&& C &&& = & 3 \\
                \hdashline &&&&&& D & = & 4 &&&&&&&&&&&& D & = & 4\\
                \hdashline
                \end{array}

                \begin{array}
                {:c:c:}
                \hdashline -A &&&&&&& = & -1 &&&&&& A &&&&&&& = & 1 \\
                \hdashline && B &&&&& = & 2 & && (6) &&&&& B &&&&& = & 2 &&& (1) \\
                \hdashline &&&& C &&& = & 3 &&&&&&&&&& C &&& = & 3 \\
                \hdashline &&&&&& D & = & 4 &&&&&&&&&&&& D & = & 4\\
                \hdashline
                \end{array}
            </p>

            <p>
                Vidíme, že aj sústava $(1)$ je dôsledkom sústavy $(4)$ a preto sú obe sústavy ekvivalentné. Preto platí:
            </p>

            <h3>U 3</h3>

            <p><b><mark style="background-color: yellow">
                        Nahradenie ľubovoľnej rovnice sústavy súčtom tejto rovnice s ľubovoľnou rovnicou sústavy je
                        ekvivalentná úprava.
                    </mark></b></p>

            <p>
                Často budeme používať kombináciu úprav $(2)$ a $(3)$, ako to je zrejmé z nasledujúcej postupnosti úprav
                $\bf{(k \neq 0)}$.

                \begin{array}
                {:c:c:}
                \hdashline A &&&&&&& = & 1 &&&&&& A &&&&&&& = & 1 \\
                \hdashline && B &&&&& = & 2 & && (1) &&&&& k \cdot B &&&&& = & k \cdot 2 &&& (a) \\
                \hdashline &&&& C &&& = & 3 &&&&&&&&&& C &&& = & 3 \\
                \hdashline &&&&&& D & = & 4 &&&&&&&&&&&& D & = & 4\\
                \hdashline \\
                \hdashline A &&&&&&& = & 1 &&&&&& A &&&&&&& = & 1 \\
                \hdashline && k \cdot B &&&&& = & k \cdot 2 & && (b) &&&&& B &&&&& = & 2 &&& (c) \\
                \hdashline &&&& k \cdot B + C &&& = & k \cdot 2 + 3 &&&&&&&&&& k \cdot B + C &&& = & k \cdot 2 + 3 \\
                \hdashline &&&&&& D & = & 4 &&&&&&&&&&&& D & = & 4\\
                \hdashline
                \end{array}
            </p>

            <h3>U 4</h3>

            <p><b><mark style="background-color: yellow">
                        Nahradenie ľubovoľnej rovnice sústavy súčtom tejto rovnice s ľubovoľným násobkom inej rovnice sústavy je
                        ekvivalentná úprava.
                    </mark></b></p>

            <p>
                Vráťme sa k nášmu problému. Chceme vyriešiť sústavu:

                \begin{array}
                {:c:c:}
                \hdashline & A + && B + && C+ && D = & 10 \\
                \hdashline 9 & A + & 8 & B + & 7 & C+ & 6 & D = & 70 \\
                \hdashline 26 & A + & 19 & B + & 14 & C+ & 11 & D = & 150 \\
                \hdashline 24 & A + & 12 & B + & 8 & C+ & 6 & D = & 96 \\
                \hdashline
                \end{array}
            </p>

            <p>
                Skôr ako začneme sústavu riešiť, zjednodušíme jej zápis. Ak ponecháme len to, čo nesie informáciu, dostaneme
                tabuľku čísel, ktorá sa nazýva "rozšírená matica sústavy".

                \begin{pmatrix}
                1 & 1 & 1 & 1 & 10 \\
                9 & 8 & 7 & 6 & 70 \\
                26 & 19 & 14 & 11 & 150 \\
                24 & 12 & 8 & 6 & 96
                \end{pmatrix}
            </p>

            <p>
                Náš cieľ je získať z nej maticu tvaru:

                \begin{pmatrix}
                1 & 0 & 0 & 0 & b1 \\
                0 & 1 & 0 & 0 & b2 \\
                0 & 0 & 1 & 0 & b3 \\
                0 & 0 & 0 & 1 & b4
                \end{pmatrix}
            </p>

            <p>
                Pretože v 1. riadku 1.stĺpca už je číslo $1$ mohli sme hneď k 2. až 4. riadku pripočítať také násobky 1. riadku,
                aby sme "vyčistili" 1. stĺpec:

                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 3px]{1} & 1 & 1 & 1 & 10 & x(-9) &x(-26) & x(-24) \\
                \hdashline 9 & 8 & 7 & 6 & 70 & \downarrow &\downarrow & \downarrow \\
                \hdashline 26 & 19 & 14 & 11 & 150 &  & \downarrow & \downarrow \\
                \hdashline 24 & 12 & 8 & 6 & 96 & & & \downarrow \\
                \hdashline
                \end{array}
            </p>

            <p>
                Dostali sme:

                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 3px]{1} & 1 & 1 & 1 & 10\\
                \hdashline 0 & \bbox[cyan, 3px]{-1} & -2 & -3 & -20 \\
                \hdashline 0 & -7 & -12 & -15 & -110\\
                \hdashline 0 & -12 & -16 & -18 & -144\\
                \hdashline
                \end{array}

            </p>

            <p>
                Teraz sme 2. riadok vynásobili takým číslom, aby v 2. riadku 2. stĺpca bolo číslo 1:
                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 3px]{1} & 1 & 1 & 1 & 10\\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 2 & 3 & 20 \\
                \hdashline \bbox[yellow, 3px]{0} & -7 & -12 & -15 & -110\\
                \hdashline \bbox[yellow, 3px]{0} & -12 & -16 & -18 & -144\\
                \hdashline
                \end{array}
            </p>

            <p>
                K 1., 3. a 4. riadku sme pripočítali také násobky 2. riadku, aby sme „vyčistili“ 2. stĺpec:
                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 3px]{1} & 1 & 1 & 1 & 10 & \uparrow\\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 2 & 3 & 20 & \times (-1) & \times 7 & \times 12 \\
                \hdashline \bbox[yellow, 3px]{0} & -7 & -12 & -15 & -110 & & \downarrow & \downarrow\\
                \hdashline \bbox[yellow, 3px]{0} & -12 & -16 & -18 & -144 & & \downarrow\\
                \hdashline
                \end{array}
            </p>

            <p>
                Dostali sme:
                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 3px]{1} & \bbox[yellow, 3px]{0} & -1 & -2 & -10 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 2 & 3 & 20 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[cyan, 3px]{2} & 6 & 30 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & 8 & 18 & 96\\
                \hdashline
                \end{array}
            </p>                                                                                                                </p>

            <p>
                Teraz sme 3. riadok vynásobili takým číslom, aby v 3. riadku 3. stĺpca bolo číslo 1:
                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 3px]{1} & \bbox[yellow, 3px]{0} & -1 & -2 & -10 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 2 & 3 & 20 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 3 & 15 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & 8 & 18 & 96\\
                \hdashline
                \end{array}
            </p>

            <p>
                K 1., 2. a 4. riadku sme pripočítali také násobky 3. riadku, aby sme „vyčistili“ 3. stĺpec:
                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 3px]{1} & \bbox[yellow, 3px]{0} & -1 & -2 & -10 & \uparrow\\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 2 & 3 & 20 & \uparrow & \uparrow \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 3 & 15 & & \times 1 & \times (-2) & \times (-8)\\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & 8 & 18 & 96 & & \downarrow\\
                \hdashline
                \end{array}
            </p>

            <p>
                Dostali sme:
                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 3px]{1} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & 1 & 5 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & \bbox[yellow, 3px]{0} & -3 & -10 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 3 & 15 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[cyan, 3px]{-6} & -24 \\
                \hdashline
                \end{array}
            </p>

            <p>
                Teraz sme 4. riadok vynásobili takým číslom, aby v 4. riadku 4. stĺpca bolo číslo 1:
                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 3px]{1} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & 1 & 5 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & \bbox[yellow, 3px]{0} & -3 & -10 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 3 & 15 \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 4 \\
                \hdashline
                \end{array}
            </p>

            <p>
                K 1. až 3. riadku sme pripočítali také násobky 4. riadku, aby sme „vyčistili“ 4. stĺpec:
                \begin{array}
                {:c:c:}
                \hdashline \bbox[yellow, 3px]{1} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & 1 & 5 & \uparrow \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & \bbox[yellow, 3px]{0} & -3 & -10 & \uparrow & \uparrow \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 3 & 15 & \uparrow & \uparrow & \uparrow \\
                \hdashline \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{0} & \bbox[yellow, 3px]{1} & 4 & \times (-1) & \times 3 & \times (-3) \\
                \hdashline
                \end{array}
            </p>

            <p>
                Čím sme získali konečné riešenie:

                \begin{pmatrix}
                1 & 0 & 0 & 0 & 1 \\
                0 & 1 & 0 & 0 & 2 \\
                0 & 0 & 1 & 0 & 3 \\
                0 & 0 & 0 & 1 & 4
                \end{pmatrix}
            </p>

        </div>



    </section>

    <div class="pagination">
        <!--<a href="A31_4.php">&laquo;</a>-->
        <a class="active" href="A32_1.php">1</a>
        <a href="A32_2.php">2</a>
        <a  href="A32_3.php">3</a>
        <a href="A32_4.php">4</a>


        <a href="A32_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
