<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA33.html');
?>

<div class="item2">
    <h2>3.3 Sústavy lineárnych rovníc trochu inak.
        <b><sup><dfn title="Táto kapitola je určená najmä pre učiteľov, ale pre žiakov nie je zakázaná.">[1]</dfn>
            </sup></b></h2>


    <section>
        <p>
            Analogické úlohy získame, ak budeme „algebraizovať“ niektoré úlohy o lineárnych útvaroch v priestore:

        </p>


        <div class="priklad">
            <h3>Príklad 2.</h3>

            <p>
                Nech usporiadané trojice $\bf{(-2; 3; 4), \; (4; -1; 2)}$ a  $\bf{(1; 2; -1)}$
                sú riešeniami nejakej lineárnej rovnice s troma neznámymi.
            </p>

            <ol type="a">
                <li>
                    <p>
                        Nájdite aspoň dve ďalšie trojice, ktoré sú riešeniami tejto rovnice
                    </p>
                </li>

                <li>
                    <p>
                        Určte túto rovnicu
                    </p>
                </li>

                <li>
                    <p>
                        Nájdite všetky riešenia tejto rovnice a zapíšte ich „jedným vrzom“
                        s použitím dvoch parametrov.
                    </p>
                </li>
            </ol>

            <p>
                Pokúsili sme sa nakresliť celú situáciu na obr. 3D súr.
                <details class="detail">
                    <summary class="summary"><b>3D súr</b></summary><br>
                    <div class="center2" id="rdpcxnna"></div>
                </details>
            <div class="center2"><img src="photo/p55.png" alt="obrazky"></div>
            ale situácia je málo prehľadná, obrázok neposkytuje nápad na okamžité riešenie úlohy.
            Skúsme preto rýdzo algebricky vyriešiť problém $\bf{b}$.

            </p>

            <p><mark>
                    Hľadáme také čísla $\bf{a, b, c, d}$, aby usporiadané trojice $\bf{(-2; 3; 4), (4; -1; 2)}$
                    a $\bf{(1; 2; -1)}$  boli riešeniami rovnice $\bf{ax + by + cz + d = 0}$.
                </mark></p>

            <p>
                To ale znamená, že má platiť:
                $$\begin{align}
                \bf{-2 \cdot a + 3 \cdot b + 4 \cdot c + d = 0} \\
                \bf{4 \cdot a - 1 \cdot b + 2 \cdot c + d = 0} \\
                \bf{1 \cdot a + 2 \cdot b - 1 \cdot c + d = 0} \\

                \end{align}$$
            </p>

            <p>
                Sústavu sme vyriešili v 1. hárku zošitu Rovnica. Riešením je rovnica
                $\bf{\bbox[yellow, 3px]{{3x + 4y + 1z – 10 = 0}}$.

                <details class="detail">
                    <summary class="summary"><b>1. hárok zošitu Rovnica</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A3.10a" src="https://www.geogebra.org/material/iframe/id/cxebppnc/width/944/height/916/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="916px" style="border:0px;"> </iframe>
                    </div></details>
            </p>

            <p>
                Teraz ľahko vyriešime problém $\bf{c}$. a tým vlastne aj problém $\bf{a}$.
                Našu poslednú rovnicu proste vyriešime. Jednu neznámu vyjadríme pomocou zvyšných dvoch,
                (hodí sa na to $\bf{z}$) a zvyšné dve môžu nadobúdať ľubovoľné hodnoty, takže ak si
                zvolíme $\bf{x = u, \;  y = v}$ dostávame:

                $$\begin{array}{rr}
                \bf{x =} & & \bf{u} \\
                \bf{y =} & & & \bf{v} \\
                \bf{z = } & \bf{10} & \bf{-3u} & \bf{-4v} \\

                \end{array}$$
            </p>
        </div>

        <h3><mark>Poznámka </mark></h3>

        <p>
            Rovnakým spôsobom sme mohli vyriešiť problém $\bf{c.}$ aj v 1. príklade. Skúsme to:
        </p>

        <p>
            Hľadáme rovnicu typu: $\bf{ax + by +c = 0}$, ktorej riešeniami sú dvojice $\bf{(-1; \; 1)}$ a $\bf{(2; \; 2)}$.
        </p>

        <p>
            To znamená, že platí:
            $$\begin{array}{:c:c:}
            \hdashline \bbox[yellow, 3px]{\bf{-a}} & \bbox[yellow, 3px]{\bf{+}} & \bbox[yellow, 3px]{\bf{b}} & \bbox[yellow, 3px]{\bf{+}}
            & \bbox[yellow, 3px]{\bf{c}} & \bbox[yellow, 3px]{\bf{=}} & \bbox[yellow, 3px]{\bf{0}}\\
            \hdashline \bbox[yellow, 3px]{\bf{2a}} & \bbox[yellow, 3px]{\bf{+}} & \bbox[yellow, 3px]{\bf{2b}} & \bbox[yellow, 3px]{\bf{+}}
            & \bbox[yellow, 3px]{\bf{c}} & \bbox[yellow, 3px]{\bf{=}} & \bbox[yellow, 3px]{\bf{0}}\\ \hdashline
            \end{array}$$
        </p>

        <p>
            Schopnosť vedieť vyriešiť sústavu dvoch homogénnych lineárnych rovníc o troch neznámych budeme potrebovať
            viackrát (v Geometrii pri premene parametrických rovníc roviny na všeobecnú rovnicu, pri určovaní vektorového súčinu).
            Venujme preto trochu času riešeniu sústavy:

            $$\begin{array}{:c:c:}
            \hdashline\bf{a_1x} & \bf{+} & \bf{b_1y} & \bf{+} & \bf{c_1z} & \bf{=} & \bf{0} \\
            \hdashline\bf{a_2x} & \bf{+} & \bf{b_2y} & \bf{+} & \bf{c_2z} & \bf{=} & \bf{0} \\ \hdashline
            \end{array}$$

        </p>

        <p>
            Použijeme osvedčenú metódu „spadlo z neba“ (propagátorom a autorom názvu je G. Pólya) a uvedieme jedno
            riešenie. Je ním trojica $\bf{(b_1c_2 – b_2c_1; \; c_1a_2 – c_2a_1; a_1b_2 – a_2b_1)}$. Všetky ostatné
            riešenia sú jej násobkom. Vhodnou mnemotechnickou pomôckou na získanie tohto riešenia je tabuľka:

            $$\begin{array}{:c|c:c:}
            \hdashline\bf{a_1} & \bf{b_1} & \bf{c_1} & \bf{a_1} & \bf{b_1} \\
            \hdashline\bf{a_2} & \bf{b_2} & \bf{c_2} & \bf{a_2} & \bf{b_2} \\
            \hdashline & & \bbox[yellow, 3px]{ \bf{b_1c_2 - b2_c1}} & \bbox[yellow, 3px]{ \bf{c_1a_2 - c2_a1}} & \bbox[yellow, 3px]{ \bf{a_1b_2 - a2_b1}} \\ \hdashline
            \end{array}$$
        </p>

        <p>
            Podľa tejto schémy pre náš príklad dostávame:

            $$\begin{array}{:c|c:c:}
            \hdashline\bf{-1} & \bf{1} & \bf{1} & \bf{-1} & \bf{1} \\
            \hdashline\bf{2} & \bf{2} & \bf{1} & \bf{2} & \bf{2} \\
            \hdashline & & \bbox[yellow, 3px]{ \bf{-1}} & \bbox[yellow, 3px]{ \bf{3}} & \bbox[yellow, 3px]{ \bf{-4}} \\ \hdashline
            \end{array}$$
        </p>

        <p>
            Teda hľadanou rovnicou je napr. rovnica $\bf{-x + 3y = 4}$
        </p>

        <p>
            V zošite Rovnice 2 v 1. liste nájdete tento recept, a v 2. liste klasické riešenie sústavy rovníc
            pomocou úprav matice.

            <details class="detail">
                <summary class="summary"><b>Rovnice 2 - 1. list</b></summary><br>
                <div class="center2">
                    <iframe scrolling="no" title="A3.11a" src="https://www.geogebra.org/material/iframe/id/eaqxyqcd/width/1000/height/500/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1000px" height="500px" style="border:0px;"> </iframe>
                </div></details>

            <details class="detail">
                <summary class="summary"><b>Rovnice 2 - 2. list</b></summary><br>
                <div class="center2">
                    <iframe scrolling="no" title="A3.11b" src="https://www.geogebra.org/material/iframe/id/g9jaj5ht/width/944/height/600/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="600px" style="border:0px;"> </iframe>
                </div></details>
        </p>


    </section>
    <div class="pagination">
        <a href="A33_1.php">&laquo;</a>
        <a  href="A33_1.php">1</a>
        <a class="active" href="A33_2.php">2</a>
        <a  href="A33_3.php">3</a>
        <a href="A33_4.php">4</a>
        <a   href="A33_5.php">5</a>
        <a   href="A33_6.php">6</a>

        <a href="A33_3.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"rdpcxnna", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('rdpcxnna');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
