<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA33.html');
?>

<div class="item2">
    <h2>3.3 Sústavy lineárnych rovníc trochu inak.
        <b><sup><dfn title="Táto kapitola je určená najmä pre učiteľov, ale pre žiakov nie je zakázaná.">[1]</dfn>
            </sup></b></h2>


    <section>

        <div class="uloha">
            <h3>Úlohy</h3>
            <ol start="5">
                <li>
                    <p>
                        Nech $\bf{(3-2r + s; \; -7 + 3r + s; \; 3 - 2r +s)}$ sú všetky riešenia lineárnej rovnice
                        $(+)$ a nech $\bf{(2+7u+3v; \; 3-2u+2v; \; 2+7u)}$ sú všetky riešenia lineárnej
                        rovnice $(++)$. Určte riešenie sústavy rovníc $(+)$ a $(++)$.
                    </p>
                </li>
            </ol>



        </div>

        <p>
            Pri riešení sústav lineárnych rovníc mnohokrát nepotrebujeme poznať riešenie, ale len fakt, či
            riešenie existuje (a ak áno či je jediné), alebo neexistuje. V predchádzajúcej kapitole opisovaná
            „zotieracia„ metóda toto neumožňuje. Zvoľme preto inú cestu:
        </p>

        <div class="priklad">
            <h3>Príklad 5.</h3>

            <p>
                Vyriešte (v množine reálnych čísel) rovnicu: $\bf{ax = 5 \qquad (1)}$
            </p>

            <h3>Riešenie:</h3>

            <p>
                Máme vlastne vyriešiť všetky lineárne rovnice s jednou neznámou napísané naraz pomocou parametrov
                $\bf{a, b}$. O kvalite riešenia rozhoduje nenulovosť parametra $\bf{a}$. Ak bude $\bf{a \neq 0}$,
                tak bude mať rovnica $\bf{(1)}$ práve jedno riešenie $\bf{\bigg\{\frac{b}{a}\bigg\}}$.
                V prípade, že $\bf{a = 0}$ , rovnica buď nebude mať riešenie – to v prípade že $\bf{b \neq 0}$,
                alebo bude riešením každé reálne číslo, ak bude $\bf{b = 0}$.
            </p>

            <p>
                Vidíme, že parameter, ktorý rozhoduje o riešiteľnosti rovnice, ktorý <b><mark>determinuje</mark></b>
                kvalitu riešenia je parameter $\bf{a}$.
            </p>
        </div><br>

        <div class="priklad">
            <h3>Príklad 6.</h3>

            <p>
                Rozhodnite za akých podmienok bude mať sústava lineárnych rovníc
                $$\begin{array}{:c:c:}
                \hdashline \bf{a_{11}x_1} & \bf{+} & \bf{a_{12}x_2} & \bf{=} & \bf{b_1} & & \bf{(2)}\\
                \hdashline \bf{a_{21}x_1} & \bf{+} & \bf{a_{22}x_2} & \bf{=} & \bf{b_2}\\\hdashline
                \end{array}$$
                jediné riešenie.
            </p>

            <h3>Riešenie:</h3>

            <p>
                Pokúsme sa vhodnými číslami prenásobiť jednotlivé rovnice tak, aby po sčítaní vždy jedna z dvoch
                rovníc „vypadla“.

                $$\begin{array}{:r:c:l:}
                \hdashline \bbox[cyan, 3px]{\bf{a_{22}|}} & \bf{a_{11}x_1} & \bf{+} & \bf{a_{12}x_2} & \bf{=} & \bf{b_1} & \bbox[yellow, 3px]{\bf{|-a_{21}}} \\
                \hdashline \bbox[cyan, 3px]{\bf{-a_{21}|}} & \bf{a_{21}x_1} & \bf{+} & \bf{a_{22}x_2} & \bf{=} & \bf{b_2} & \bbox[yellow, 3px]{\bf{|a_{11}}} \\\hdashline
                \end{array}$$
            </p>

            <p>
                $$\begin{array}{ll}
                \text{Ak rovnicu vynásobíme číslami „zľava“,} && \text{Ak rovnicu vynásobíme číslami „sprava“,}\\
                \text{po sčítaní dostaneme:} && \text{po sčítaní dostaneme:}\\
                \bbox[cyan, 3px]{\bf{(a_{11}a_{22}-a_{21}a_{12})x1 = b_1a_{22} - b_2a_{12}}} &&
                \bbox[yellow, 3px]{\bf{(a_{11}a_{22}-a_{21}a_{12})x2 = a_{11}b_2 - a_{21}b_1}}
                \end{array}$$
            </p>

            <p>
                Vidíme, že o kvalite riešenia rozhoduje, resp. existenciu jediného riešenia <b>determinuje</b>
                výraz $\bf{a_{11}a_{22} - a_{21}a_{12}}$, ktorý budeme nazývať <b><mark>determinant</mark></b>
                sústavy $(2)$ a budeme ho označovať symbolom $\bf{\bbox[yellow, 3px]{D}}$. Pre jeho lepšie zapamätanie
                si (ale aj z iných dôvodov) používame jeho schematický zápis v tvare:
                $$\bf{D =
                \begin{vmatrix}
                a_{1,1} & a_{1,2}\\
                a_{2,1} & a_{2,2}\\
                \end{vmatrix}}
                $$

            </p>

            <p>
                Podobne označíme výrazy $\bf{b_1a_{22}-b_2a_{12} = D_1}$ a $\bf{a_{11}b_2-a_{21}b_1 = D_2}$, alebo :

                $$\begin{array}{cc}\bf{D_1 =
                \begin{vmatrix}
                b_1 & a_{1,2}\\
                b_2 & a_{2,2}\\
                \end{vmatrix}} &
                \bf{D_2 =
                \begin{vmatrix}
                a_{1,1} & b_1\\
                a_{2,1} & b_2\\
                \end{vmatrix}}
                \end{array}$$
            </p>

            <p>
                Ak $\bf{D \neq 0}$, tak sústava má jediné riešenie: $\bf{x_1=\frac{D_1}{D}, \; x_2 = \frac{D_2}{D} }$.
            </p>

            <p>
                Ak $\bf{D = 0}$ a aspoň jedno z čísel $\bf{D_1}$ a $\bf{D_2}$ je rôzne od nuly, tak sústava nemá riešenie.
            </p>

            <p>
                Ak $\bf{D = 0}$ a obe čísla $\bf{D_1}$ aj $\bf{D_2}$ sú rovné nule, tak sústava má nekonečne mnoho riešení.
            </p>
        </div>

    </section>
    <div class="pagination">
        <a href="A33_3.php">&laquo;</a>
        <a  href="A33_1.php">1</a>
        <a  href="A33_2.php">2</a>
        <a   href="A33_3.php">3</a>
        <a class="active" href="A33_4.php">4</a>
        <a   href="A33_5.php">5</a>
        <a   href="A33_6.php">6</a>


        <a href="A33_5.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ch48w9gu", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gzsefwhx","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ch48w9gu');
        applet2.inject('gzsefwhx');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
