<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA34.html');
?>

<div class="item2">
    <h2>3.4 Riešenie rovníc s parametrami</h2>


    <section>
        <p>
        <p>
        <p>
            Ako sme už v posledných príkladoch minulej kapitoly, v niektorých prípadoch zadanie problému obsahuje
            neurčitosti, niektoré vstupné údaje môžu byť premenlivé, alebo niekedy chceme "jedným vrzom" vyriešiť viacero
            podobných problémov, líšiacich sa len niektorými parametrami vstupných údajov. Pozrime si
        </p>
        </p>
        </p>


        <div class="priklad">
            <h3>Príklad 1.</h3>

            <p>
                Na obrázku vidíte kruhovú podložku s vonkajším priemerom $\pmb{D}$ a s kruhovým otvorom pre skrutku s priemerom
                $\pmb{d}$. Odseknutím dvoch rovnobežných kruhových odsekov chceme dosiahnuť, aby celková hmotnosť podložky
                bola 75% hmotnosti celej kruhovej podložky. Pritom dĺžka $\pmb{k}$ kritickej úsečky nesmie byť menšia ako
                $\pmb{\frac{d}{2}}$.
            <div class="center2"><img src="photo/p56.png" alt="obrazky"></div>

            </p>

            <p>
                Aká bude šírka $\pmb{x}$ takto odľahčenej podložky?
            </p>

            <p>
                O parametroch $\pmb{d, D}$ predpokladajte, že $\pmb{D \in \{5; 10; 15; 20; 25; 30\}, d \in N, d \geq 3,
                d \leq D/3}$
            </p>



            <p>
                Navrhujeme zvoliť ako premennú stredový uhol $\pmb{\varphi}$ (pozri pravý obrázok) a až v závere dopočítať
                hľadanú šírku $\pmb{x}$ odľahčenej podložky. Keďže objem podložky je úmerný plošnému obsahu, budeme hľadať
                taký uhol $\pmb{\varphi}$, pre ktorý bude obsah redukovanej podložky rovný 75% obsahu pôvodnej podložky.

            <div class="center2"><img src="photo/p57.png" alt="obrazky"></div>
            </p>

            <p>
                Pre obsah $\pmb{P}$ celej podložky platí: $\pmb{P = \frac{\pi (D^2 - d^2)}{4}}$, pre obsah $\pmb{O}$ kruhového
                odseku platí:

                $$\pmb{O = \frac{\varphi}{2 \pi} \frac{\pi D^2}{4} - \frac{1}{2} \frac{D^2}{4} sin \varphi =
                \frac{D^2(\varphi - sin \varphi)}{8}}$$

            <ol>keďže dva odseky majú byť rovné štvrtine pôvodného obsahu dostávame rovnicu:</ol>

            $$\pmb{\frac{\pi(D^2 - d^2)}{16} = \frac{D^2(\varphi - sin \varphi)}{4}}$$

            <ol>alebo po úprave</ol>

            $$\bbox[yellow, 5px]{\pmb{\varphi - sin \varphi = \frac{\pi(D^2 - d^2)}{4D^2}} \qquad(*)}$$
            </p>

            <p>
                Ak si uvedomíme, že $\pmb{cos \Bigl(\frac{\varphi}{2} \Bigr) = \frac{k + \frac{d}{2}}{\frac{D}{2}} =
                \frac{2k + d}{D}}$ dostáva obmedzujúca podmienka tvar:

                $$\bbox[yellow, 5px]{\pmb{cos \biggl ( \frac{\varphi}{2} \biggr ) \geq \frac{2d}{D}} \qquad (**)}$$
            </p>

            <p>
                Poznamenajme, že z kontextu úlohy vieme, že parametre $\pmb{D, d}$ sú prirodzené čísla (rozmery podložiek sú
                udávané v milimetroch), a šírku $\pmb{x}$ stačí určiť s presnosťou na desatiny.

            <div class="center2"><img src="photo/p58.png" alt="obrazky"></div>
            </p>

            <p>
                Na obrázku vidíte riešenie nášho príkladu pomocou softvéru Cabri II plus.
                <details class="detail">
                    <summary class="summary"><b>Otvorte si výkres Podložka.</b></summary><br>
                    <div class="center2" id="ywfqvnju"></div>
                </details>
                Výkres je interaktívny. Sami si môžete voliť hodnoty
                vstupných parametrov $\bf{D}$ a $\bf{d}$, GeoGebra nakreslí graf funkcie $\bf{y = x - \sin x}$
                (ten nezávisí od týchto parametrov) aj priamku $\bf{y = \frac{\pi(D^2 - d^2)}{4D^2}}$
                a určí súradnice ich priesečníka. Paralelne vykreslí podložku s aktuálnymi rozmermi
                vrátane vypočítanej hrúbky odľahčenej podložky. Užívateľ si musí sám skontrolovať
                splnenie podmienky riešiteľnosti, t. j. či platí:
                $$\bf{cos\bigg(\frac{x}{2}\bigg)\geq \frac{2d}{D} }$$
            </p>

            <p>
                Rovnica $(^*)$ sa dá riešiť aj pomocou Excelovského nástroja „Hľadanie riešenia“.
                Presnosť tohto nástroja je obmedzená, ale pre praktické účely to obyčajne postačuje.
                Pozrite si zošit Podložka. V 1. hárku v bunke C7 je pomocou „riešiteľa“ vyriešená
                rovnica $(^*)$, v bunke D7 je príslušná šírka $\bf{b}$ odľahčenej podložky a v bunke
                E7 je testovaná podmienka $(^{**})$.
                <details class="detail">
                    <summary class="summary"><b>Podložka - 1. hárok</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A3.12a" src="https://www.geogebra.org/material/iframe/id/z5yvh95k/width/944/height/500/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="500px" style="border:0px;"> </iframe>
                    </div></details>
            </p>

            <p>
                Pre praktické účely je niekedy vhodné uviesť všetky riešenia pre prípustné hodnoty
                parametrov v prehľadnej tabuľke. Pozrite si 2. hárok zošitu Podložka a doplňte tam
                uvedenú tabuľku (pomocou hárku 1.).
                <details class="detail">
                    <summary class="summary"><b>Podložka - 2. hárok</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A3.12b" src="https://www.geogebra.org/material/iframe/id/z4gxvy55/width/944/height/500/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="500px" style="border:0px;"> </iframe>                         </div></details>
            </p>
        </div>



    </section>

    <div class="pagination">
        <a href="A34_3.php">&laquo;</a>
        <a class="active" href="A34_1.php">1</a>
        <a href="A34_2.php">2</a>
        <a  href="A34_3.php">3</a>



        <a href="A34_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ywfqvnju", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ywfqvnju');

    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
