<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA34.html');
?>

<div class="item2">
    <h2>3.4 Riešenie rovníc s parametrami</h2>


    <section>
        <p>
            V niektorých prípadoch musíme pri riešení problémov s parametrom veľmi pozorne vybrať vhodný nástroj na
            riešenie problému. Pozrime si
        </p>
        <div class="priklad">
            <h3>Príklad 2.</h3>

            <p>
                Máme rovnicu :
                $$\bf{\frac{a}{(x+1)(x+2)} + \frac{4a+3}{(x+2)(x+3)} = \frac{1+2a}{(x+3)(x+1)}}$$

            </p>

            <p>
                Nájdite všetky reálne čísla $a$, pre ktoré táto rovnica nemá žiadny koreň ($x$ je neznáma).
            </p>

            <p>
            <div class="center2"><img src="photo/p59.png" alt="obrazky"></div>
            Keby sme si nakreslili grafy (pre konkrétnu hodnotu $\bf{a = 1}$) veľa by sme nezmúdreli.
            Máme dve možnosti:
            <ul>
                <li>
                    <p>
                        Použiť iný softvér
                    </p>
                </li>
                <li>
                    <p>
                        Pred riešením problému rovnicu „vhodne“ upraviť.
                    </p>
                </li>
            </ul>

            </p>



            <p>
                Skúsme Excel. Ak si pozriete hárok1 a budete sa pokúšať nájsť riešenie (pomocou
                nástroja „riešiteľ“) pre rôzne hodnoty parametra, zistíte, že tento nástroj má svoje
                hranice možností a nedáva riešenie.
                <details class="detail">
                    <summary class="summary"><b>hárok1</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A3.13" src="https://www.geogebra.org/material/iframe/id/hcvecbbh/width/1000/height/500/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1000px" height="500px" style="border:0px;"> </iframe>
                    </div></details>
            </p>

            <p>
                Zdá sa, že sa nevyhneme nepopulárnej činnosti - úprave našej rovnice. Po odstránení
                menovateľov vynásobením rovnice výrazom $\bf{(x + 1)(x + 2)(x + 3)}$ a po drobnej
                úprave dostávame rovnicu:

                $$\bf{(3a+2)x = - (3a+1) \qquad (^*)}$$
            </p>

            <p>
                Aby bola ekvivalentná s našou pôvodnou rovnicou, musí byť $\bf{x \in R \backslash \{-1; \; -2; \; -3\}}$,
                čím chceme povedať, že čísla $\bf{-1, -2}$ a $\bf{-3}$ nemôžu byť riešením.
            </p>

            <p>
                Pre $\bf{-\frac{2}{3} }$ rovnica $(^*)$ očividne riešenie nemá, pre ostatné hodnoty
                parametra $\bf{a}$ máme:

                $$\bf{-\frac{3a+1}{3a+2} }$$
            </p>

            <p>
                Preto, ak výraz $\bf{\frac{3a+1}{3a+2}}$, alebo po úprave $\bf{1 - \frac{1}{3a+2}}$
                nadobudne hodnotu $\bf{2}$, alebo $\bf{3}$, rovnica nebude mať riešenie. To bude
                práve vtedy, keď bude $\bf{a \in \bigl\{-1; -\frac{5}{6}\bigr\}}$ . Hodnotu $\bf{1}$
                výraz nikdy nenadobudne (Pozri Excel, alebo Parameter ).
                <details class="detail">
                    <summary class="summary"><b>Excel</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A3.13" src="https://www.geogebra.org/material/iframe/id/hcvecbbh/width/1000/height/500/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1000px" height="500px" style="border:0px;"> </iframe>
                    </div></details>

                <details class="detail">
                    <summary class="summary"><b>Parameter</b></summary><br>
                    <div class="center2" id="u5qtzemw"></div>
                </details>
            </p>

        </div>

        <h3><mark style="background-color:cyan">Poznámka</mark></h3>
        <p><mark style="background-color:cyan">
                Z tohto plynie mravné ponaučenie. Vedieť upravovať výrazy a poznať ekvivalentné úpravy
                rovníc sa hodí aj vtedy, keď máme po ruke výpočtovú techniku.
            </mark></p>

        <p>
            V predchádzajúcej kapitole sme narazili na jednu zaujímavú sústavu lineárnych rovníc s
            parametrom. Vyriešme preto:
        </p>

        <div class="priklad">
            <h3>Príklad 3.</h3>
            <p>
                Vyriešte sústavu troch lineárnych rovníc o troch neznámych s parametrom $c$.
                \begin{array}
                \bf{1 \cdot x} & \bf{+} & \bf{3 \cdot y} & \bf{+} & \bf{7 \cdot z} & \bf{=} & \bf{107}\\
                \bf{1 \cdot x} & \bf{+} & \bf{4 \cdot y} & \bf{+} & \bf{10 \cdot z} & \bf{=} & \bf{148}\\
                \bf{2 \cdot x} & \bf{+} & \bf{3 \cdot y} & \bf{+} & \bf{5 \cdot z} & \bf{=} & \bf{c}\\
                \end{array}
            </p>
            <h3>Riešenie:</h3>
            <p>
                Otvorte si zošit Parameter2. Namiesto parametru $\bf{c}$ sme vložili konkrétnu
                hodnotu $100$ a riešením sústavy sme získali maticu:

                \begin{array}{:c:c:}
                \hdashline\bf{1} & \bf{0} & \bf{-2} & \bf{-16} \\ \hdashline
                \bf{0} & \bf{1} & \bf{3} & \bf{41} \\ \hdashline
                \bf{0} & \bf{0} & \bf{0} & \bf{9} \\ \hdashline
                \end{array}

                <details class="detail">
                    <summary class="summary"><b>Parameter2</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A3.14b" src="https://www.geogebra.org/material/iframe/id/rarxqctr/width/944/height/916/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="916px" style="border:0px;"> </iframe>
                    </div></details>

            </p>

            <p>
                Čo svedčí o tom, že sústava nemá riešenie, lebo posledná rovnica má tvar:
                $$\bf{0 \cdot x + 0 \cdot y + 0 \cdot z = 9}$$
            </p>

            <p>
                Výsledok nám naznačuje, že sústava buď nebude mať riešenie, alebo pre niektorú hodnotu
                parametra $\bf{c}$ bude mať nekonečne mnoho riešení. Preto použijeme nástroj
                „riešiteľ“ pre bunku D25 a nastavíme cieľovú hodnotu 0 (vtedy bude mať sústava
                nekonečne mnoho riešení). Menená bunka bude D5. „Riešiteľ“ nájde riešenie D5 = 91.
                Pre túto hodnotu parametra $\bf{c}$ bude mať výsledná sústava tvar:
                \begin{array}{:c:c:}
                \hdashline\bf{1} & \bf{0} & \bf{-2} & \bf{-16} \\ \hdashline
                \bf{0} & \bf{1} & \bf{3} & \bf{41} \\ \hdashline
                \end{array}
            </p>

            <p>
                Čiže riešenia majú tvar:
                $$\bf{x = 2t - 16,\; y = -3t + 41,\; z = t}$$
            </p>

        </div>



    </section>

    <div class="pagination">
        <a href="A34_1.php">&laquo;</a>
        <a  href="A34_1.php">1</a>
        <a class="active" href="A34_2.php">2</a>
        <a  href="A34_3.php">3</a>



        <a href="A34_3.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"u5qtzemw", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('u5qtzemw');

    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
