<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA34.html');
?>

<div class="item2">
    <h2>3.4 Riešenie rovníc s parametrami</h2>


    <section>
        <p>
            Na ukážku vyriešme aj niekoľko „školských“ príkladov typu „debna“.
        </p>
        <div class="priklad">
            <h3>Príklad 4.</h3>

            <p>
                Vyriešte rovnicu s parametrom $\bf{a}$:
                $$\bf{\sqrt{a - \sqrt{a^2-x^2}} = x}$$

            </p>

            <h3>Riešenie:</h3>
            <p>
                Skúsme v GeoGebre nakresliť graf $\bf{y = \sqrt{a-\sqrt{a^2-x^2}-x}}$ (závislý na
                parametri $\bf{a}$), meniť hodnoty parametra $\bf{a}$ a pozorovať priesečníky grafu
                s osou $\bf{x}$.
                <details class="detail">
                    <summary class="summary"><b>GeoGebra</b></summary><br>
                    <div class="center2" id="nycymeyw">
                    </div></details>
            </p>

            <p>
                Tento spôsob nám umožní pre každú konkrétnu hodnotu parametra nájsť riešenia rovnice
                (s vyhovujúcou presnosťou), umožní aj realizovať „kvalitatívnu“ diskusiu riešiteľnosti
                (t. j. zistiť pre aké hodnoty parametra existujú, resp. neexistujú riešenia, aj zistiť
                ich počet), ale nám neumožňuje určiť akou funkciou parametra sú príslušné riešenia.
                Pre väčšinu reálnych problémov takéto riešenie vyhovuje.
            </p>

        </div><br>



        <div class="priklad">
            <h3>Príklad 5.</h3>
            <p>
                Vyriešte rovnicu s parametrom $\bf{k \in R: \bigg|\sqrt{x^2+x+3}-3\bigg| + |x-2| = k \cdot x + 3 }$.
            </p>

            <h3>Riešenie:</h3>
            <p>
            <div class="center2"><img src="photo/p60.png" alt="obrazky"></div>
            Pomocou GeoGebry sme zostrojili graf (červený) ľavej strany (ktorý nie je závislý na
            parametri).
            <details class="detail">
                <summary class="summary"><b>GeoGebra</b></summary><br>
                <div class="center2" id="n4erry6k">
                </div></details>
            Pravá strana je pomocou parametra $\bf{k}$ vyjadrená množina všetkých
            priamok, ktoré prechádzajú bodom $\bf{[0; 3]}$. GeoGebra poskytuje možnosť pre
            aktuálnu polohu priamky určiť súradnice priesečníkov grafu ľavej strany s priamkou.
            Príklad uvádzame ako výstrahu. Pri pozorovaní situácie pre $\bf{k = 2}$.
            <div class="center2"><img src="photo/p61.png" alt="obrazky"></div>
            nedokážeme rozhodnúť či existuje jediné riešenie (je pravá časť červeného grafu
            polpriamka?). Rovnaká neistota by nastala v situácii pre $\bf{k = -2}$ .

            </p>


            <p>

                <details class="detail">
                    <summary class="summary"><b>Skúsime ešte EXCEL. </b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A3.15" src="https://www.geogebra.org/material/iframe/id/wapnyvjg/width/944/height/916/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="916px" style="border:0px;"> </iframe>
                    </div></details>
                Po experimentovaní s hodnotou parametru $\bf{k}$ v blízkosti čísiel
                $\bf{\pm 2}$ môžeme konštatovať len toľko, že pre tieto hodnoty parametru buď riešenie
                neexistuje, alebo je príliš veľké (v absolútnej hodnote).
            </p>

            <p>
                Omylu sa možno vyhneme použitím lepšieho softvéru, ktorý umožňuje väčší „odstup“,
                čiže globálnejší pohľad na graf (pozri G12). Ak si súbor otvoríte, môžete si voliť
                hodnotu parametra $\bf{k}$ a softvér vám ponúka hľadané korene. Môžete si tiež meniť
                tvar grafu podľa Vašich požiadaviek. Pre kritické hodnoty $\bf{k = \pm 2}$ softvér
                udáva jediný koreň.
                <details class="detail">
                    <summary class="summary"><b>G12</b></summary><br>
                    <div class="center2" id="qezbaxum">
                    </div></details>
            </p>

            <p>
                Zdá sa, že bude rozumné vyriešiť konkrétne rovnice pre hodnoty parametru $\bf{k = \pm 2}$.
            </p>

            <p>
                Pre $\bf{k = 2}$ dostávame $\bf{\bigg\{\sqrt{x^2+x+3}-1\bigg\}+|x-2|=2\cdot x + 3 }$.
                Pretože hľadáme koreň v intervale $\bf{( 2 ; \infty )}$, kde sú výrazy v oboch
                absolútnych hodnotách kladné, rovnica má tvar: $\bf{\sqrt{x^2+x+3} = x + 8 }$
                čo po ekvivalentnej úprave umocnením dáva $\bf{x+3 = 16x+64}$.
            </p>

            <p>
                Posledná rovnica očividne v intervale $\bf{( 2 ; \infty )}$ nemá riešenie.
                (Podobne si doriešte rovnicu pre $k = - 2$ )
            </p>

        </div>

        <h3><mark>Poznámka:</mark></h3>
        <p><mark>
                Používanie prostriedkov výpočtovej techniky treba vždy kombinovať so zdravým rozumom.
                Bez schopnosti vhodne používať ekvivalentné úpravy rovníc a bez primeranej zručnosti
                s úpravou výrazov nám bude výpočtová technika málo platná.
            </mark></p>

        <div class="uloha">
            <h3>Úlohy</h3>
            <p>
                Vyriešte nasledovné rovnice s parametrami:
                <ol>
                    <li>
            <p>
                $bf{\frac{\sqrt{x} - 1 }{\sqrt{x} + 1 } = \frac{a-1}{a+1}}$
            </p>
            </li>
            <li>
                <p>
                    $\bf{x + \sqrt{x^2+2p^2} = 2p}$
                </p>
            </li>
            <li>
                <p>
                    $\bf{x + \sqrt{x^2-p^2} = 2p}$
                </p>
            </li>
            <li>
                <p>
                    $\bf{\sqrt{a- \sqrt{x^2+a^2}} = x}$
                </p>
            </li>
            </ol>
            </p>
        </div>



    </section>

    <div class="pagination">
        <a href="A34_2.php">&laquo;</a>
        <a  href="A34_1.php">1</a>
        <a  href="A34_2.php">2</a>
        <a  class="active" href="A34_3.php">3</a>



        <a href="A34_1.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"qezbaxum", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"nycymeyw","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"n4erry6k","width":"1400", "height":"600"};
    var applet3 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('qezbaxum');
        applet2.inject('nycymeyw');
        applet3.inject('n4erry6k');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
