<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA35.html');
?>

<div class="item2">
    <h2>3.5 Nerovnosti a nerovnice</h2>


    <section>
        <h3><mark>Poznámka 2.</mark></h3>
        <p>
            Väčšina reálnych problémov vedie na riešenie nerovníc, ktoré sa ani po vhodných ekvivalentných
            úpravách nedajú previesť na nerovnicu, ktorú vieme „presne“ vyriešiť pomocou známeho konečného algoritmu.
            Preto, podobne ako pri riešení rovníc budeme dávať prednosť vhodným približným metódam, používaniu grafov a pod.
        </p>

        <div class="priklad">
            <h3>Príklad 4.</h3>
            <p>
                Vyriešme nerovnicu $\bf{2\sqrt[4]{x-2} - x + 1 \leq 0}$
            </p>

            <p>
                Najprv sa zorientujeme pohľadom na graf funkcie $\bf{y = 2 \sqrt[4]{x-2}-x+1}$
            <div class="center2"><img src="photo/p64.png" alt="obrazky"></div>
            </p>

            <p>
                Z grafu vidíme, že riešením bude zjednotenie intervalov: $\bf{\langle 2; \; a \rangle \cup \langle b; \; \infty )}$,
                kde $\bf{a,b}$ sú riešeniami rovnice $\bf{y = 2 \sqrt[4]{x-2}-x+1 = 0}$.
            </p>

            <p>
                Pohľad na graf G14 a použitie voľby Find roots dáva dva nulové body:
                $$\bf{a = 2.08737083,\; b = 3}$$
                <details class="detail">
                    <summary class="summary"><b>G14.</b></summary><br>
                    <div class="center2" id="s6h4jwtw">
                    </div></details>

            </p>


        </div>

        <p>
            Používanie výpočtovej techniky nám umožňuje riešiť aj nerovnice s parametrom.
        </p>
        <div class="priklad">
            <h3>Príklad 5.</h3>
            <p>
                Vyriešme nerovnicu $\bf{2\sqrt[4]{x-2}-x-q \geq 0 }$ s reálnym parametrom $\bf{q}$.
            </p>
            <h3>Riešenie:</h3>
            <p>
                Využili sme možnosti softvéru GeoGebra (otvorte si G15) a nakreslili graf funkcie
                $\bf{2\sqrt[4]{x-2}-x-q}$. Softvér umožňuje (digitálne) meniť hodnotu parametra. Na obrázku
                vidíte situáciu pre $\bf{q = -0.8095}$ Vtedy softvér dáva dva nulové body funkcie
                $\bf{x_1 = 2.38955841 a x_2 = 2.40422112}$
                <details class="detail">
                    <summary class="summary"><b>G15.</b></summary><br>
                    <div class="center2" id="kkm59few">
                    </div></details>
            <div class="center2"><img src="photo/p65.png" alt="obrazky"></div>
            </p>

            <p>
                Aby sme mohli plynulo meniť hodnotu parametra, použijeme Cabri výkres Nerovnice 2.
                <details class="detail">
                    <summary class="summary"><b>Nerovnice 2</b></summary><br>
                    <div class="center2" id="m342m6ub">
                    </div></details>
            <div class="center2"><img src="photo/p66.png" alt="obrazky"></div>
            </p>

            <p>
                Ak budete manipulovať s hodnotou $q$, zistíte že hraničná hodnota pre parameter $\bf{q}$ je
                približne  $\bf{- 0.8095}$. Pre menšie $\bf{q}$ riešenie nebude existovať, pre $\bf{q}$ niekde
                v blízkosti tejto hodnoty bude existovať jediné riešenie a potom pre klesajúce $\bf{q}$ bude
                riešením interval $\bf{\langle a; \; b \rangle}$, resp. pre $\bf{q \leq - 2}$ interval
                $\bf{\langle 2; \; b \rangle}$, kde $\bf{a, b}$ sú priesečníky priamky $\bf{y = x + q}$
                s grafom funkcie $\bf{2\sqrt[4]{x-2}}$
            </p>
        </div><br>

        <div class="uloha">
            <ol start="5">
                <li>
                    <p>
                        Vyriešte nerovnicu s parametrom: $\bf{x + \sqrt{x^2 - p} \geq p}$
                    </p>
                </li>

                <li>
                    <p>
                        Vyriešte nerovnicu s parametrom: $\bf{p \cdot x + (p+1) \cdot x \ geq 0 }$
                        <details class="detail">
                            <summary class="summary"><b>(Pozrite si Nerovnice 2a)</b></summary><br>
                            <div class="center2" id="dtshwcrb">
                            </div></details>
                    </p>
                </li>
            </ol>
        </div>
    </section>

    <div class="pagination">
        <a href="A35_2.php">&laquo;</a>
        <a  href="A35_1.php">1</a>
        <a  href="A35_2.php">2</a>
        <a class="active"  href="A35_3.php">3</a>

        <a href="A35_1.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"s6h4jwtw", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"kkm59few","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"m342m6ub","width":"1400", "height":"600"};
    var applet3 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"dtshwcrb","width":"1400", "height":"600"};
    var applet4 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('s6h4jwtw');
        applet2.inject('kkm59few');
        applet3.inject('m342m6ub');
        applet4.inject('dtshwcrb');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
