<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA41.html');
?>

<div class="item2">
    <h2>4.1 Polynomické funkcie</h2>


    <section>
        <p>
            Nedostatkom vyučovania pojmov funkcia, funkčná závislosť, je malý súbor príkladov funkcií
            <b><sup><dfn title="tzv. separovaných modelov">[1]
                    </dfn></sup></b>, pomocou ktorých tento pojem vysvetľujeme. Druhou chybou je neprirodzene rýchle, priam
            násilné spájanie pojmu funkcia s jej grafom a zanedbávanie inej prezentácie funkcie než funkčným predpisom
            a grafom. Už grécki matematici poznali rôzne druhy kriviek, definovaných nejakou ich vlastnosťou (kružnica,
            parabola, elipsa, hyperbola, ...) alebo vzniknuvších nejakým pohyom (pozri cabri výkres Cykloida). Matematici
            tiež poznali rôzne "relácie" medzi veličinami, ktoré vyjadrovali väčšinou pomocou tabuliek, ako napríklad
            v našom označovaní funkcie logaritmus a rôzne goniometrické funkcie. Tieto dva druhy objektov bolo možné dať
            do súvislosti, až keď sa vďaka <b>René Decartesovi</b> začala používať súradnicová sústava.
            <!--<details class="detail">
            <summary class="summary"><b>Cykloida</b></summary><br>
            <div class="center2" id=""></div>
            </details>-->
        </p>

        <p>
            Uveďme niekoľko netradičných príkladov funkčných závislostí, ktorých sledovanie a skúmanie umožňuje Cabri
            geometria.
        </p>

        <div class="priklad">
            <h3>Príklad 1.</h3>

            <p>
                Je to klasický problém, aké najdlhšie brvno sa dá premiestniť lomenou chodbou, ktorej ramená majú rôznu šírku.
                Na výkrese Funkcie 01 sledujte závislosť dĺžky úsečky XY od polohy bodu X.
                <details class="detail">
                    <summary class="summary"><b>Funkcie 01</b></summary><br>
                    <div class="center2" id="r4kkf2tg"></div>
                </details>

            </p>
        </div><br>

        <div class="priklad">
            <h3>Príklad 2.</h3>

            <p>
                Prednosťou použitia Cabri geometrie je to, že sa môžeme zaoberať aj takými závislosťami, ktorých matematické
                vyjadrenie je pre nás ťažko prístupné a môžeme sa sústrediť na pochopenie toho, čo je to (funkčná) závislosť,
                čo je to graf funkcie, prečo k tomu potrebujeme súradnicovú sústavu, ako je to napríklad na výkrese Funkcie 02.
                <details class="detail">
                    <summary class="summary"><b>Funkcie 02</b></summary><br>
                    <div class="center2" id="bza4bqwp"></div>
                </details>
            </p>
        </div><br>


        <div class="priklad">
            <h3>Príklad 3.</h3>

            <p>
                Určte závislosť obsahu trojuholníka $\pmb{ABC}$ so stranami $\pmb{BC = a, AC = b}$ od veľkosti uhla
                $\pmb{\gamma}$.
            </p>

            <p>
                Riešenie si pozrite v Cabri výkrese Funkcie 03. Vo výkrese sme použili schopnosť Cabri určiť obsah narysovaného
                mnohouholníka. Veľkosť uhla $\pmb{\gamma}$. a obsah trojuholníka $P$ sú na obrázku v rôznych mierkach.
                <!-- <details class="detail">
                 <summary class="summary"><b>Funkcie 03</b></summary><br>
                 <div class="center2" id=""></div>
                 </details>-->
            </p>
        </div><br>

        <div class="uloha">
            <h3>Úlohy</h3>

            <p>
                <ol>
                    <li>
            <p>
                Do jednotkového štvorca $\pmb{ABCD}$ je vpísaný štvorec $\pmb{KLMN}$ (bod $\pmb{K}$ je ľubovoľným bodom úsečky
                $\pmb{AB}$). Bod $\pmb{O}$ je priesečníkom úsečky $\pmb{LN}$ a priamky rovnobežnej s $\pmb{AD}$, idúcej cez bod
                $\pmb{K}$ (pozri obrázok vľavo). Veľkosť úsečky $\pmb{KO}$ závisí od polohy bodu $\pmb{K}$. Rôzne polohy bodu
                $K$ vytvoria akúsi krivku (na obrázku je červená).
            <div class="center2"><img src="photo/p67.png" alt="obrazky"></div>

            <ol type="a">
                <li>
                    <p>
                        Čo vyjadruje dĺžka úsečky $KO$?
                    </p>
                </li>

                <li>
                    <p>
                        Označme ako $\pmb{x}$ dĺžku úsečky $\pmb{AK}$ a dĺžku úsečky $\pmb{KO}$ ako $\pmb{y}$. Vyjadrite
                        $\pmb{y}$ ako funkciu $\pmb{x}$.
                    </p>
                </li>
            </ol>
            </p>

            <p>
                <details class="detail">
                    <summary class="summary"><b>(Pozrite si Cabri výkres Funkcie 04.)</b></summary><br>
                    <div class="center2" id="ejwu8tym"></div>
                </details>
            </p>
            </li>
            </ol>
            </p>
        </div>




    </section>

    <div class="pagination">
        <a href="A41_4.php">&laquo;</a>
        <a class="active" href="A41_1.php">1</a>
        <a href="A41_2.php">2</a>
        <a  href="A41_3.php">3</a>
        <a href="A41_4.php">4</a>
        <a href="A41_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"r4kkf2tg","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"bza4bqwp", "width":"1400", "height":"600"};
    var applet3 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"","width":"1400", "height":"600"};
    var applet4 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"ejwu8tym","width":"1400", "height":"600"};
    var applet5 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('');
        applet2.inject('r4kkf2tg');
        applet3.inject('bza4bqwp');
        applet4.inject('');
        applet5.inject('ejwu8tym');

    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
