<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA41.html');
?>

<div class="item2">
    <h2>4.1 Polynomické funkcie</h2>


    <section>
        <p>
            Pomocou podobných príkladov možno od skúmania konkrétnej závislosti dôjsť až k jej matematickému
            vyjadreniu, t. j. k funkcii.
        </p>
        <h3>Lineárne funkcie</h3>

        <div class="priklad">
            <h3>Príklad 4.</h3>

            <p>
                Žiaci dostali za úlohu doniesť príklady rôznych funkčných závislostí z bežného života. Zväčša
                nosili rôzne cenníky, napr. mobilných operátorov, prehľad z dennej tlače o minimálnych cenách
                základných potravín v jednotlivých sieťach predajní a pod. Najviac ma zaujal letáčik elektrární,
                ktorý obsahoval nasledovnú tabuľku:
                \begin{array}{|c|c|}
                \hline\text{Sadzba} & \text{Paušál Sk/mes} & \text{24h tarifa Sk/kWh} & \text{Nízka tarifa Sk/kWh}\\ \hline
                D1 & 8 & 5.4 & - & - \\ \hline
                D2 & 170 & 3.85 & - & - \\ \hline
                D12 & 133 & - & 5.4 & 2.05 \\ \hline
                D22 & 295 & - & 3.85 & 3.05 \\ \hline
                \end{array}
            </p>

            <p>
                Tabuľka obsahuje všetku potrebnú informáciu, ale v „skrytej“ podobe. Neumožňuje bezprostredne
                odpovedať na zásadnú otázku – ktorá sadzba je pre mňa najvýhodnejšia pri danej mesačnej spotrebe.
            </p>

            <p>
                K tomu bude dobré informáciu zakódovanú v tabuľke odkryť – nejakým prehľadným spôsobom znázorniť
                závislosť mesačnej platby (pri zvolenej sadzbe) na množstve spotrebovanej energie.
            </p>

            <p>
                Prvé dve sadzby (závislosť mesačnej platby od mesačnej spotreby) sú lineárne funkcie, ktorých
                graf sme pomocou Cabri zakreslili na výkrese Funkcie 05.
                <!--<details class="detail">
                <summary class="summary"><b>Funkcie 05</b></summary><br>
                <div class="center2" id=""></div>
                </details>-->
            </p>

            <p>
                Paušál platíme aj keď nič nespotrebujeme, preto sme na os y naniesli hodnoty $\bf{8}$ a $\bf{170}$.
                Tieto body sme posúvali – ak minieme o $\bf{10}\; kWh$ viac (posun doprava o $\bf{10}$), tak sa
                mi platba zväčší v prípade sadzby $\bf{D1}$ o $54$, v prípade sadzby $\bf{D2}$ o $38,5\; Sk$
                (posun hore o $\bf{54}$, resp. o $\bf{38,5}$). Prednosťou Cabri je možnosť voliť vhodnú mierku
                na jednotlivých súradnicových osiach.
            </p>

            <p>
                Graf poskytuje dobrý celkový pohľad, ale málo informuje o detailoch. Tie nám lepšie poskytne
                <a href="excel/A4.01.xlsx" download="A4.01.xlsx">
                    tabuľka 01
                </a>.

            </p>

            <p>
                Z tabuľky vidieť, že pri spotrebe väčšej ako $104\; kWh$ je sadzba D2 vhodnejšia ako sadzba D1.
            </p>

            <p>
                Komplikovanejšie je to s ďalšími sadzbami. Tu v závislosti od podielu spotreby vo vyššej tarife
                z celkovej dennej spotreby (označme ho $p$) priemerná platba za $1\; kWh$ bude:
                \begin{align}
                \bf{p \cdot 5.4 + (1-p) \cdot 2.05} \; \text{v sadzbe D12, resp.}\\
                \bf{p \cdot 3.85 + (1-p) \cdot 2.05} \; \text{v sadzbe D22.}
                \end{align}
            </p>

            <p>
                Grafy  závislosti mesačnej platby od množstva spotrebovanej energie vo všetkých sadzbách
                (pri danom $p$, ktoré môžeme meniť) poskytuje Cabri výkres Funkcie 06.
                <details class="detail">
                    <summary class="summary"><b>Funkcie 06</b></summary><br>
                    <div class="center2" id="myav5n6z"></div>
                </details>
            </p>

            <p>
                Upozornenie. Vo výkrese sú grafy lineárnych funkcií, ktorých definičným oborom je celá množina
                reálnych čísel. Ale z kontextu úlohy je zrejmé, že spotreba energie v KWh musí byť nezáporné číslo.
                Toto (správne určenie oboru premennej) musíme mať na pamäti pri riešení každého problému.
            </p>

            <p>
                Napriek možnosti interaktívnej voľby parametra $\bf{p}$ a veľkosti jednotky na súradných osiach,
                je rozlíšenie jednotlivých grafov stále nepohodlné a výhodnejšia je
                <a href="excel/A4.02.xlsx" download="A4.02.xlsx">
                    tabuľka 02
                </a>.

                V tabuľkách sme pomocou podmieneného formátovania farebne zvýraznili tú sadzbu, ktorá je pri
                danej spotrebe najvýhodnejšia.
            </p>

        </div>

        <h3>Kvadratické funkcie.</h3>
        <p>
            Pojem kvadratickej funkcie si priblížime na týchto príkladoch:
        </p>
        <div class="priklad">
            <h3>Príklad 5.</h3>
            <p>
                Pán Konček vlastní záhradu. Je pri potoku, má tvar obdĺžnika s rozmermi $30$ krát $35$ metrov a je v nej
                aj studňa.
            <div class="center2"><img src="photo/p68.png" alt="obrazky"></div>

            </p>

            <p>
                Pán Konček sa rozhodol záhradu rozdeliť medzi svojich dvoch vnukov tak, že časť z ktorej je bližšie k
                studni bude patriť Andrejkovi a časť z ktorej je bližšie k potoku bude patriť Maťkovi. Sú tu dva problémy:
                <br>ako vyzerá deliaca čiara?<br>
                kto dostal väčšiu časť záhrady?
            </p>

            <p>

                <details class="detail">
                    <summary class="summary"><b>Použime program GeoGebra, a nakreslíme si záhradu.</b></summary><br>
                    <div class="center2" id="dpukdmra"></div>
                </details>
            </p>

            <p>
                Osádzanie kolov priamo v záhrade pomocou merania vzdialenosti je nepohodlné a namáhavé, skúsme si deliacu
                čiaru nakresliť najprv na výkrese hranica.
                <details class="detail">
                    <summary class="summary"><b>hranica</b></summary><br>
                    <div class="center2" id="kguxzfqb"></div>
                </details>
            </p>

            <p>
                Krivku, časťou ktorej je deliaca čiara, matematici volajú parabola, alebo presnejšie:
                <b>Množina bodov v rovine, ktoré majú rovnakú vzdialenosť od daného bodu F a od danej priamky (ktorá
                    neprechádza bodom F) d voláme parabola. Bod F sa volá ohnisko paraboly a priamka d riadiaca priamka paraboly.</b>
            </p>

            <p>
                Ako vidíme na obrázku, parabola je súmerná podľa priamky idúcej cez ohnisko kolmo na riadiacu priamku.
                Túto priamku voláme os paraboly. Bod na osi voláme vrchol paraboly.
                <details class="detail">
                    <summary class="summary"><b>parabola</b></summary><br>
                    <div class="center2" id="gnxxuyrw"></div>
                </details>
            </p>

            <p>
                Prvý problém s deliacou čiarou je vyriešený. Vieme bod po bode zostrojiť našej potrebe primeraný počet
                bodov paraboly, tam napr. zatĺcť koly a použitím drôteného pletiva zostrojiť plot.
            </p>

            <p>
                Na riešenie druhého problému budeme potrebovať matematické vyjadrenie paraboly, t. j. nejaké kritérium,
                pomocou ktorého zistíme ktorý bod roviny parabole patrí a ktorý nie. K tomu si vhodne zvolíme súradnicovú sústavu.

                <details class="detail">
                    <summary class="summary"><b>Pozrime si výkres: rovnica</b></summary><br>
                    <div class="center2" id="cehrthh5"></div>
                </details>
            </p>

            <p>
                Experimentovanie v tomto výkrese je poučné:
            </p>

            <p>
                Ak si nastavíte vzdialenosť ohniska od riadiacej priamky rovnú $\bf{0,5}$ (polparameter $\bf{p}$ bude
                mať hodnotu $\bf{0,25}$), tak v súradnicovej sústave so začiatkom vo vrchole paraboly a s osou $y$
                totožnou s jej osou, je závislosť medzi súradnicami bodov paraboly vyjadrená vzťahom: $\bf{y = x^2}$
            </p>

            <p>
                Voľte postupne za hodnoty polparametra $p$ čísla $\bf{0,1; 0,25; 0,5; 1; 2}$ a v každej voľbe meňte hodnoty
                premennej $\bf{x}$ od $\bf{-1}$ do $1$ s krokom po jednej desatine.
                <details class="detail">
                    <summary class="summary"><b>Výsledky porovnávajte s tabuľkou.</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="A4.03" src="https://www.geogebra.org/material/iframe/id/krmvhm7x/width/944/height/916/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="916px" style="border:0px;"> </iframe>

                    </div></details>
                V nej je prehľadne vyjadrená závislosť medzi súradnicami $x$ a $y$ bodov paraboly v závislosti na hodnote
                polparametra $p$.
            </p>

            <p>
                Z uvedenej tabuľky plynie, že je oprávnená hypotéza:
            </p>

            <p>
                <b>Ak vzdialenosť medzi ohniskom a riadiacou priamkou paraboly je 2p, tak parabola má v súradnicovej
                    sústave so začiatkom vo svojom vrchole a s osou y totožnou so svojou osou rovnicu:</b> $\bf{y=x^2/4p}$
            </p>
        </div>
    </section>

    <div class="pagination">
        <a href="A41_1.php">&laquo;</a>
        <a  href="A41_1.php">1</a>
        <a class="active" href="A41_2.php">2</a>
        <a  href="A41_3.php">3</a>
        <a href="A41_4.php">4</a>


        <a href="A41_3.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"myav5n6z","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"dpukdmra", "width":"1400", "height":"600"};
    var applet3 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"kguxzfqb","width":"1400", "height":"600"};
    var applet4 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"gnxxuyrw", "width":"1400", "height":"600"};
    var applet5 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"cehrthh5","width":"1400", "height":"600"};
    var applet6 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('');
        applet2.inject('myav5n6z');
        applet3.inject('dpukdmra');
        applet4.inject('kguxzfqb');
        applet5.inject('gnxxuyrw');
        applet6.inject('cehrthh5');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
