<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA42.html');
?>

<div class="item2">
    <h2>4.2 Rozprávka o čísle e</h2>
    <section>
        <div class="priklad">
            <h3>Príklad 1.</h3>
            <p>
                Pomocou (D) dokážeme, že z prvej rovnosti v (exp) vyplýva prvá rovnosť v (ln).
            </p>

            <p>
                Podľa (D) $\bf{ln(u \cdot v) =  ln(u) + ln(v) \iff e^{ln(u) + ln(v)} = u \cdot v }$. Vďaka (exp) môžeme písať:
                $\bf{e^{ln(u)+ln(v)} = e^{ln(u)} \cdot e^{ln(v)}}$ čo sa podľa (D) rovná $\bf{u \cdot v}$.
            </p>
        </div><br>

        <div class="uloha">
            <h3>Úlohy</h3>
            <ol>
                <li>
                    <p>
                        Podobne ako v predchádzajúcom príklade dokážte druhú rovnosť vo vzťahu (ln).
                    </p>
                </li>

                <li>
                    <p>
                        Ktorá funkcia je inverzná k funkcii $\bf{y = \sqrt{x}}$?
                    </p>
                </li>

                <li>
                    <p>
                        Ktorá funkcia je inverzná k funkcii $\bf{y = 3x + 2}$?

                        <details class="detail">
                            <summary class="summary"><b>(pozrite si INV1)</b></summary><br>
                            <div class="center2" id="nabvf9du"></div>
                        </details>
                    </p>
                </li>

                <li>
                    <p>
                        Ktorá funkcia je inverzná k funkcii $\bf{y = \frac{2x-1}{x+2} }$?
                        <details class="detail">
                            <summary class="summary"><b>(pozrite si INV2)</b></summary><br>
                            <div class="center2" id="easkhpm3"></div>
                        </details>
                    </p>
                </li>

                <li>
                    <p>
                        <mark style="background-color:red">Prémia. Na obrázku vidíte priesečník grafov funkcií
                            $\bf{y = ln(x)}$ a $\bf{y = (1-x)^{0.3}}$.</mark>
                    <div class="center2"><img src="photo/p76.png" alt="vrypy na kostiach"></div>
                    </p>

                    <p>
                        Otvorte si Cabri výkres Exp04 a pokúste sa vysloviť hypotézu pre ktoré $\bf{q\in (0;1)}$
                        majú grafy funkcií $\bf{y = ln(x)}$ a $\bf{y = (1-x)^q}$ spoločný bod rôzny od bodu $[1;0]$.
                        <details class="detail">
                            <summary class="summary"><b>Exp04</b></summary><br>
                            <div class="center2" id="hhu8swhg"></div>
                        </details>
                    </p>
                </li>
            </ol>
        </div>

        <h3><mark>Poznámka historická</mark></h3>
        <p>
            Keď autor tejto čítanky chodil do strednej školy, boli schopnosti narábať s logaritmami, s logaritmickými tabuľkami
            a s <b>logaritmickým pravítkom</b> kľúčovými schopnosťami a ich neznalosť sa netolerovala. Dôležité bolo napr.
            poznať vzťah medzi logaritmami pri rôznych základoch a schopnosť riešiť špeciálne zostavené exponenciálne
            a logaritmické rovnice. Nebudeme pokračovať v takejto drezúre, ale uvedieme niekoľko príkladov a úloh,
            ktoré nás donútia zamyslieť sa nad exponenciálnymi a logaritmickými funkciami.
        </p>

        <div class="priklad">
            <h3>Príklad 2.</h3>
            <p>
                Určte bez použitia funkcie $\bf{y = ln(x)}$ hodnotu $\bf{ln(2)}$ s presnosťou na $8$ desatinných miest.
            </p>

            <p>
                Prvý odhad získame pohľadom na funkciu $\bf{y = (1,001^{1000})^x}$ v zošite
                <a href="excel/A4.08.xlsx" download="A4.08.xlsx">
                    e04
                </a>.


                Tam vidíme:

                \begin{array}{:c:c:}\hdashline
                0,693 &	1,9990133 &\color{gray}	1,99901334398633\\ \hdashline
                0,694 &	2,0010124 & \color{gray}	2,00101235733032 \\ \hdashline
                \end{array}
            </p>

            <p>
                Čiže $\bf{ln(2)}$ je medzi $\bf{0,693}$ a $\bf{0,694}$. Zjemnenie kroku na $\bf{0,0001}$ dá odhad:
                \begin{array}{:c:c:}\hdashline
                0,6931 &	1,99983634 &\color{gray}	1,99983634019676\\ \hdashline
                0,6932 &	2,00003632 & \color{gray}	2,00003632383078 \\ \hdashline
                \end{array}
            </p>

            <p>
                Čiže $\bf{ln(2)}$ je medzi $\bf{0,6931}$ a $\bf{0,6932}$.
            </p>

            <p>
                Lepšie bude použiť postup podobný pri odhade $\bf{\sqrt{2}}$. Pozrite si 2. hárok zošitu
                <a href="excel/A4.08.xlsx" download="A4.08.xlsx">
                    e04
                </a>.

                Postupným zjemňovaním kroku dostávame približný odhad: $\bf{ln(2) ≈ 0,69314718}$.
            </p>
        </div>


    </section>

    <div class="pagination">
        <a href="A42_2.php">&laquo;</a>
        <a  href="A42_1.php">1</a>
        <a href="A42_2.php">2</a>
        <a class="active"  href="A42_3.php">3</a>
        <a href="A42_4.php">4</a>
        <a   href="A42_5.php">5</a>


        <a href="A42_4.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"nabvf9du", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"easkhpm3","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"hhu8swhg","width":"1400", "height":"600"};
    var applet3 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('nabvf9du');
        applet2.inject('easkhpm3');
        applet3.inject('hhu8swhg');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
