<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA43.html');
?>

<div class="item2">
    <h2>Goniometrické funkcie</h2>


    <section>
        <p>
            Pri definovaní goniometrických funkcií máme dva problémy:
        </p>

        <ul>
            <li>
                <p>
                    Zo základnej školy sme si doniesli predstavu, že funkcie <b>sínus, kosínus, tangens</b>, priraďujú uhlu
                    v pravouhlom trojuholníku nejaké kladné číslo (pomer príslušných strán v danom trojuholníku) a teraz ich
                    máme chápať ako predpisy, ktoré ľubovoľnému (reálnemu) číslu priraďujú nejaké (reálne) číslo.
                </p>
            </li>

            <li>
                <p>
                    Uhol doteraz pre nás znamenal <b>"časť roviny ohraničenej dvoma polpriamkami so spoločným začiatkom"</b>
                    ale teraz ho máme chápať ako niečo čím sa meria veľkosť otočenia.
                </p>
            </li>
        </ul>
        <p>
            Ak si myslíte, že druhý problém nie je Váš problém, tak vyriešte nasledovné dve úlohy:
        </p>

        <div class="uloha">

            <h3>Úlohy</h3>
            <ol>

                <li><p>
                        Uvažujme orientovaný uhol, ktorého prvým ramenom je malá hodinová ručička a druhým ramenom veľká ručička. Aká
                        je jeho veľkosť v čase $\pmb{t}$ hodín? ($\pmb{t \in R}$)
                    </p></li>

                <li><p>
                        Ktorý orientovaný uhol má tu vlastnosť, že jeho trojnásobok má veľkosť $\pmb{270°}$?
                    </p></li>
            </ol>

        </div>

        <p>
            Ak ste nevedeli vyriešiť 1. úlohu a ak si mylne myslíte, že 2. úloha má jediné riešenie (uhol s veľkosťou
            $\pmb{90°}$), tak venujte pozornosť nasledujúcemu textu.
        </p>

        <p>
            Vieme, že <b>orientovaný uhol je usporiadaná dvojica polpriamok so spoločným začiatkom</b>. Tieto polpriamky
            voláme <b>ramená</b> a ich spoločný začiatok <b>vrchol orientovaného uhla</b>. Pokúsme sa osvetliť si pojmy
            <b>veľkosť orientovaného uhla</b> a <b>sčitovanie orientovaných uhlov</b> na nasledujúcich príkladoch:
        </p>

        <div class="priklad">
            <h3>Príklad 1. (Kotúľanie kružnice po priamke)</h3>

            <p>
                Predstavme si starú chlapčenskú <b><sup><dfn title="Autor sa takto zabával asi v roku 1946.">[1]</dfn></sup></b>
                hru - kotúľanie obruče z vozového kolesa po ceste. Ak budeme abstrahovať od nepodstatných detailov,
                je to v podstate kotúľanie kružnice po priamke.
            <div class="center2"><img src="photo/p79.png" alt="vrypy na kostiach"></div>
            </p>

            <p>
                Priamkou nech je os $\pmb{x}$, jednotkovú kružnicu so stredom $S$ umiestnime tak, aby sa bodom $O$ dotýkala osi
                $\pmb{x}$ v bode $\pmb{0}$. Ak $\pmb{SO}$ je 1. rameno a $\pmb{SA}$ je 2. rameno orientovaného uhla
                $\pmb{\alpha}$, potom pri "kotúľaní" kružnice po osi $\pmb{x}$ bude bod $\pmb{A}$ opisovať krivku (volá sa
                cykloida), ktorá pretne os $\pmb{x}$ v bode $\pmb{a}$, pre ktorý platí, že dĺžka oblúka od $\pmb{O}$ po
                $\pmb{A}$ sa rovná dĺžke úsečky $\pmb{0a}$. Keby sme v kotúľaní pokračovali (na obe strany), bod $\pmb{A}$ by
                sa dotkol osi $\pmb{x}$ v ďalších bodoch, ako to vidíme na obrázku vľavo:
            </p>

            <p>
                Celú situáciu sme znázornili na obrázku na nasledujúcej strane, Vy sa môžete v Cabri výkrese Kotúľanie s celou
                situáciou pohrať. Môžete meniť základnú veľkosť uhla, t.j. polohu bodu $\pmb{A}$ na jednotkovej kružnici, a
                môžete si vybrať, koľký odtlačok bodu $\pmb{A}$ na osi $\pmb{x}$ chcete vidieť.
                <!--<details class="detail">
                <summary class="summary"><b>Kotúľanie</b></summary><br>
                <div class="center2" id=""></div>
                </details>-->

            <div class="center2"><img src="photo/p80.png" alt="vrypy na kostiach"></div>
            </p>


            <p>
                Prvý odtlačok bodu $\bf{A}$ je v čísle $\bf{1,5708}$, (to bude <b>základná veľkosť</b> uhla $\bf{\alpha}$),
                ďalší v bode $\bf{1,5708 + 2\pi = 7,8540}$, atď. Môžeme konštatovať, že všetkými odtlačkami bodu
                $A$ na číselnej osi t. j. všetkými veľkosťami uhlu $\bf{\alpha}$ budú čísla $\bf{1,5708 + k \cdot 2\pi}$,
                kde $\bf{k}$ je ľubovoľné celé číslo.
            </p>

        </div>

    </section>

    <div class="pagination">
        <a href="A43_7.php">&laquo;</a>
        <a class="active" href="A43_1.php">1</a>
        <a href="A43_2.php">2</a>
        <a  href="A43_3.php">3</a>
        <a href="A43_4.php">4</a>
        <a  href="A43_5.php">5</a>
        <a  href="A43_6.php">6</a>
        <a   href="A43_7.php">7</a>

        <a href="A43_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);


    window.onload = function() {
        applet1.inject('');

    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
