<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA43.html');
?>

<div class="item2">
    <h2>Goniometrické funkcie</h2>


    <section>
        <p>
            V predchádzajúcom príklade sme sa naučili ako reálnemu číslu $\bf{x}$ priradiť orientovaný uhol, ktorého
            jednou veľkosťou je práve toto číslo. Zužitkujme tieto poznatky o namotávaní na oživenie školskej definície
            goniometrických funkcií sínus a kosínus:
        <div class="center2"><img src="photo/p86.png" alt="obrazok"></div>
        </p>

        <p>
            Dané číslo $\bf{x}$ zobrazíme na pomocnej číselnej osi (ležiacej na priamke $\bf{x = 1)}$
        </p>

        <p>
            Toto číslo namotáme na jednotkovú kružnicu so stredom v začiatku súradnicovej sústavy.
        </p>

        <p>
            Namotaný bod $\bf{X}$ leží na 2. ramene orientovaného uhla $\bf{1OX}$, ktorého jednou veľkosťou je číslo $\bf{x}$.
        </p>

        <p>
            Namotaný bod $\bf{X}$ má súradnice $\bf{[\cos x; \sin x]}$.
        </p>

        <p>
            Ilustráciu tejto definície, aj definície funkcie kosínus si môžete pozrieť na Cabri výkresoch:
            <!--<details class="detail">
            <summary class="summary"><b>Definícia sínusu</b></summary><br>
            <div class="center2" id=""></div>
            </details>

            <details class="detail">
            <summary class="summary"><b>Definícia kosínusu</b></summary><br>
            <div class="center2" id=""></div>
            </details>-->

        </p>

        <p>
            Dúfam, že oba cabri výkresy vám pomohli porozumieť stredoškolskej definícii funkcií sínus a kosínus.
        </p>

        <h3><mark>Poznámka 1.</mark></h3>
        <p>
            Slová <b>„toto číslo namotáme na jednotkovú kružnicu so stredom v začiatku súradnicovej sústavy“</b> sú
            rovnako presné, či rovnako nepresné ako slová <b>„zostrojíme orientovaný uhol, ktorého jednou veľkosťou
                je dané číslo“</b>. Korektná definícia goniometrických funkcií je možná len:
            <ul>
                <li>
        <p>
            pomocou ich funkcionálnych vlastností (pozri napr. Jarník: „Úvod do počtu diferenciálneho“).
            Túto možnosť využijeme v závere kapitoly na zostrojenie tabuliek funkcií sínus a kosínus,
        </p>
        </li>

        <li>
            <p>
                pomocou súčtu nekonečných radov:
                $$\bf{\cos x = 1 - \frac{x^2}{2!}+ \frac{x^4}{6!}-\frac{x^6}{6!}+...+(-1)^k \frac{x^{2k}}{(2k)!}} \qquad(c)$$
                $$\bf{\sin x = x - \frac{x^3}{3!}+ \frac{x^5}{5!}-\frac{x^7}{7!}+...+(-1)^{k+1} \frac{x^{2k-1}}{(2k-1)!}} \qquad(s)$$

            </p>
        </li>
        </ul>
        </p>

        <p>
            Ak v oboch radoch použijeme len niekoľko sčítancov, chyba o ktorú sa budeme líšiť od celkového súčtu
            bude menšia ako absolútna hodnota posledného použitého člena. To nám dáva návod, ako napr. s presnosťou
            na  5 desatinných miest ručne vypočítať:
            $$\bf{\sin 0.5 = \frac{1}{2}-\frac{1}{48}+\frac{1}{3840}-\frac{1}{645120} = \frac{322560-13440+168-1}{645120} = \frac{309287}{645120} ≈ 0.47943}$$
        </p>

        <h3><mark>Poznámka 2.</mark></h3>
        <p>
            Rovnosti (c) a (s) majú aj inú interpretáciu. Ak budeme postupne uvažovať funkcie:
            \begin{array}{ll}
            \bf{y = x} & & \text{na obr. modrá}\\
            \bf{y = x - \frac{x^3}{3!}} & & \text{na obr. tyrkysová}\\
            \bf{y = x - \frac{x^3}{3!} + \frac{x^5}{5!}} && \text{na obr. zelená}\\
            \bf{y = x - \frac{x^3}{3!} + \frac{x^5}{5!} - \frac{x^7}{7!}} && \text{na obr. červená}
            \end{array}
            ktoré získame, ak z radu (s) postupne použijeme čoraz viac členov, tieto budú v čoraz väčšej vzdialenosti
            od nuly dostatočne presne aproximovať funkciu $\bf{y = \sin x}$  (na obr. čierna).
        <div class="center2"><img src="photo/p87.png" alt="obrazok"></div>
        </p>

        <p>
            Podobný obrázok pre aproximáciu funkcie kosínus nájdete v Cabri výkrese  kosínus.
            <details class="detail">
                <summary class="summary"><b>kosínus</b></summary><br>
                <div class="center2" id="bgyjsume"></div>
            </details>
        </p>


    </section>

    <div class="pagination">
        <a href="A43_3.php">&laquo;</a>
        <a  href="A43_1.php">1</a>
        <a  href="A43_2.php">2</a>
        <a  href="A43_3.php">3</a>
        <a class="active" href="A43_4.php">4</a>
        <a  href="A43_5.php">5</a>
        <a  href="A43_6.php">6</a>
        <a   href="A43_7.php">7</a>


        <a href="A43_5.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"bgyjsume","width":"1400", "height":"600"};
    var applet3 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('');
        applet2.inject('');
        applet3.inject('bgyjsume');

    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
