<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA43.html');
?>

<div class="item2">
    <h2>Goniometrické funkcie</h2>


    <section>
        <h3>Vlastnosti funkcií sínus a kosínus. </h3>
        <p>
            Z faktu, že bod $\bf{[\cos x ; \sin x]}$ je bodom jednotkovej kružnice, vyplýva ich prvá vlastnosť:
            $$\bf{\forall x \in R: \cos^2x + sin^2x = 1 \qquad(^3)}$$
        </p>

        <p>
            Užitočnú informáciu môže dať pohľad na dva nasledujúce obrázky. Na oboch obrázkoch je zobrazený bod
            jednotkovej kružnice, ktorého súradnice sú $\bf{[a; b]}$, do ktorého sa namotá reálne číslo $\bf{\alpha}$
            a jeho obrazy v súmernostiach podľa jednotlivých súradnicových osí aj podľa osí kvadrantov. V prvom obrázku
            sú body označené svojimi súradnicami a v druhom sme vyznačili, ktoré reálne čísla sa do nich namotali:
        <div class="center2"><img src="photo/p88.png" alt="obrazok"></div>
        </p>

        <p>
            Ak teraz porovnáme oba obrázky a uvedomíme si, že $\bf{a = \cos \alpha, \; b = \sin \alpha}$ dostaneme týchto
            sedem dvojíc identít:
            \begin{array}{ll}
            \bf{\cos(\pi / 2 - x) = \sin x} & \bf{\sin(\pi / 2 - x) = \cos x}\\
            \bf{\cos(\pi / 2 + x) = - \sin x} & \bf{\sin(\pi / 2 + x) = \cos x}\\
            \bf{\cos(\pi - x) = - \cos x} & \bf{\sin(\pi - x) = \sin x}\\
            \bf{\cos(\pi + x) = - \cos x} & \bf{\sin(\pi + x) = - \sin x}\\
            \bf{\cos(3\pi / 2 - x) = - \sin x} & \bf{\sin(3\pi / 2 - x) = -\cos x}\\
            \bf{\cos(3\pi / 2 + x) = \sin x} & \bf{\sin(3\pi / 2 + x) = -\cos x}\\
            \bf{\cos(-x) = - \cos x} & \bf{\sin(- x) = -\sin x}\\
            \end{array}
        </p>

        <p>
            Najzaujímavejšie dvojice sú v prvom a v poslednom riadku.
        </p>

        <p>
            Dobre si všimnite nasledujúci obrázok:
        <div class="center2"><img src="photo/p89.png" alt="obrazok"></div>
        </p>

        <p>
            Z definície sčitovania bodov na kružnici vyplýva, že dĺžka úsečky spájajúcej body do ktorých sa namotajú čísla
            $\bf{a, b}$ je rovná dĺžke úsečky spájajúcej body, do ktorých sa namotajú čísla $\bf{0, b – a}$.
            Ak pomocou Pytagorovej vety vypočítame dĺžky týchto úsečiek a výsledky dáme do rovnosti postupne dostaneme:
            $$\bf{[\cos(b-a)-1]^2 + [\sin(b-a)-0]^2 = (\cos a - \cos b)^2 + (\sin a - \sin b)^2}$$
            $$\bf{\bbox[yellow, 3px]{\cos(b-a) = (\cos a)(\cos b) + (\sin a)(\sin b)}}$$
        </p>

        <p>
            Tomuto vzťahu a podobným vyjadreniam pre $\bf{\cos(a + b), \sin(a + b), \sin(a – b)}$ hovoríme <b>súčtové vzorce</b>.
            Tieto hrajú vážnu úlohu pri úpravách výrazov obsahujúcich goniometrické funkcie. Bez existencie výpočtovej
            techniky bola mimoriadne dôležitá schopnosť upravovať tzv. goniometrické výrazy. Bez toho bolo temer nemožné
            riešiť úlohy. V súčasnosti miesto tejto schopnosti sa stáva dôležitejšou schopnosť vedieť pri riešení problémov
            vhodne používať výpočtovú techniku.
        </p>

        <h3><mark>Poznámka o funkciách tangens a kotangens</mark></h3>
        <p>
            Funkcie tangens a kotangens sú definovaná (pre prípustné hodnoty premennej $\bf{x}$):
            $$\bf{tg x = \frac{\sin x}{\cos x} \qquad cotg x = \frac{\cos x}{\sin x} }$$
        </p>

        <p>

            <!--<details class="detail">
            <summary class="summary"><b>Graf funkcie tangens zhotovený podľa definície  si môžete pozrieť v cabri výkrese tangens.</b></summary><br>
            <div class="center2" id=""></div>
            </details>-->
        </p>

    </section>

    <div class="pagination">
        <a href="A43_4.php">&laquo;</a>
        <a  href="A43_1.php">1</a>
        <a  href="A43_2.php">2</a>
        <a  href="A43_3.php">3</a>
        <a  href="A43_4.php">4</a>
        <a class="active"  href="A43_5.php">5</a>
        <a  href="A43_6.php">6</a>
        <a   href="A43_7.php">7</a>


        <a href="A43_5.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('');

    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
