<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA43.html');
?>

<div class="item2">
    <h2>Goniometrické funkcie</h2>


    <section>
        <h3><mark>Poznámka o grafoch goniometrických funkcií </mark></h3>
        <p>
            Už sme spomínali v kapitole o polynomických funkciách, že existujú viaceré matematické i didaktické softvéry,
            ktoré umožňujú presne a rýchlo nakresliť graf žiadanej funkcie. Pomocou Cabri však môžeme pochopiť podstatu
            pojmu funkcia a kresliť grafy parametrických súborov funkcií.
        </p>

        <p>
            S pomocou ponúk „výraz“ a „použi výraz“ (ktorá sú súčasťou CABRI II plus) môžeme nakresliť graf ľubovoľnej
            goniometrickej funkcie. Pomocou kalkulačky môžeme nakresliť aj graf funkcie závislej na parametroch. Tieto
            parametre môžeme určiť ako meniteľné číselné hodnoty ako to je v Cabri výkrese Graf 1.
            <details class="detail">
                <summary class="summary"><b>Graf 1</b></summary><br>
                <div class="center2" id="kgatg3mc"></div>
            </details>
            Ak budete v tomto
            výkrese meniť hodnoty parametrov, graf funkcie sa Vám bude priebežne meniť a vy môžete sledovať vplyv tohto
            parametra na priebeh funkcie.
        </p>

        <p>
            Parametre bolo možné zadať aj ako dĺžky úsečiek či súradnice bodov ktoré môžeme meniť pohybom myši,
            ako je to vo výkrese Graf 2.
            <details class="detail">
                <summary class="summary"><b>Graf 2</b></summary><br>
                <div class="center2" id="j4g7cqse"></div>
            </details>
        </p>

        <p>
            Nepripomína vám posúvanie parametrov vo výkrese Graf 2 niečo ako prácu s mixážnym pultom?
        </p>

        <div class="uloha">
            <h3>Úlohy</h3>
            <ol start="4">
                <li>
                    <p>
                        4.Koľkokrát sa budú hodinové ručičky v čase od $0$ hodín po $12$ hodín prekrývať? Použite
                        riešenie 1. úlohy a uveďte všetky časy, kedy sa tak stane.
                    </p>
                </li>

                <li>
                    <p>
                        V operácii sčitovania bodov na kružnici má rovnica $\bf{n \cdot X = A}$ práve $n$ riešení.
                        Aký obrazec tvoria tieto riešenia ?
                    </p>
                </li>

                <li>
                    <p>
                        Na obrázkoch v ukážkach „kotúľania a namotávania sú nakreslené krivky, ktoré vznikajú
                        pohybom daných bodov. Skúste nájsť ich matematické vyjadrenie.
                    </p>
                </li>

                <li>
                    <p>
                        Vyjadrite s presnosťou na 6 desatinných miest $\bf{\cos 0.5}$.
                    </p>
                </li>
            </ol>
        </div>

        <h3><mark>Poznámka o riešení goniometrických rovníc. </mark></h3>
        <p>
            Svoj názor na riešenie rovníc všetkých druhov sme vyjadrili v Poznámke 5. v kapitole III.1 Riešenie rovníc.
            Môžeme iba pridať jednu významnú metódu riešenia rovníc: <b>„Pri riešení rovníc sa netreba držať žiadnej metódy“.</b>
        </p>

        <div class="priklad">
            <h3>Príklad 5.</h3>
            <p>
                Vyriešte rovnicu: $\bf{tg x = tg(x + 10^\circ) \cdot tg(x+20^\circ)\cdot tg(x+30^\circ) \qquad (^4)} $
            </p>

            <h3>Riešenie.</h3>
            <p>
                Rovnicu „vynulujeme“ a nahradíme stupne radiánovou mierou:
                $$\bf{tg\bigg(x + \frac{\pi}{18}\bigg) \cdot tg\bigg(x+\frac{\pi}{9}\bigg) \cdot tg\bigg(x+\frac{\pi}{6}\bigg)-tgx = 0}$$
            </p>

            <p>
                Nakreslíme si graf funkcie ľavej strany v DeadLine:
            <div class="center2"><img src="photo/p90.png" alt="obrazok"></div>
            </p>

            <p>
                Funkcia je zrejme periodická s dĺžkou periódy $\pi$.
                <details class="detail">
                    <summary class="summary"><b>Otvorte si G19.</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="G19" src="https://www.geogebra.org/material/iframe/id/pud8mynt/width/1280/height/609/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1280px" height="609px" style="border:0px;"> </iframe>
                    </div></details>

                Vhodnou voľbou rozmerov zobrazenej oblasti a použitím možnosti Find roots sme dostali čitateľný obrázok a
                približné hodnoty štyroch koreňov v rámci jednej periódy (v intervale $\bf{\langle 0 ; \pi \rangle }$).
                Pre 3. a 4. koreň sa zdá byť dobrou hypotézou že sú to korene  $\bf{x1}$ a $\bf{x2}$ posunuté o $\bf{90^\circ}$.
                Že je to správna hypotéza sa môžete presvedčiť sami.
            </p>
        </div><br>

        <div class="priklad">
            <h3>Príklad 6.</h3>
            <p>
                Vyriešte rovnicu $\bf{(\sin x)^2 = \sin(x^2), \; x \in \langle 0; \pi \rangle}$
            </p>

            <h3>Riešenie.</h3>
            <p>
                Korene by sme našli podobným spôsobom ako v predošlom príklade. Najprv z celkového pohľadu na graf funkcie
                $\bf{y = (\sin x)^2 - \sin(x^2), \; x \in \langle 0; \pi \rangle}$ by sme odhadli všetky (štyri) korene a
                potom by ich získali použitím ponuky „Find roots“ s presnosťou na 8 desatinných miest.
            <div class="center2"><img src="photo/p91.png" alt="obrazok"></div>
            </p>

            <p>
                Situácia by sa však zmenila, keby bol oborom premennej väčší interval, napr. $\bf{x \in \langle 0 ; 4\pi \rangle}$.
                Tu by nás pohľad na graf v danom rozsahu premennej asi nepríjemne prekvapil:
            <div class="center2"><img src="photo/p92.png" alt="obrazok"></div>
            </p>

            <p>
                Nami doteraz ponúkaný spôsob riešenia by bol prinajmenšom zdĺhavý.
            </p>

            <p>
                Otvorte si G20, skúste zmeniť hranice zobrazenej oblasti a zistíte, že akákoľvek výpočtová technika má
                svoje hranice, za ktoré sa môže dostať len mysliaci človek.
                <details class="detail">
                    <summary class="summary"><b>G20.</b></summary><br>
                    <div class="center2">
                        <iframe scrolling="no" title="G20" src="https://www.geogebra.org/material/iframe/id/rsmsb9tp/width/1280/height/609/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1280px" height="609px" style="border:0px;"> </iframe>
                    </div></details>
            </p>

        </div>

        <h3><mark>Poznámka.</mark></h3>
        <p>
            Podobné problémy, aké sme mali s funkciou $\bf{y = (\sin x)^2 - \sin(x^2)}$ pre veľké hodnoty premennej, by
            vznikli s funkciou $\bf{y = \sin(\frac{1}{x})}$ v blízkosti nuly. Otvorte si G21 a presvedčte sa o tom aká
            bude márna Vaša snaha sledovať priebeh tejto funkcie v blízkosti nuly.
            <details class="detail">
                <summary class="summary"><b>Otvorte si G21.</b></summary><br>
                <div class="center2">
                    <iframe scrolling="no" title="G21" src="https://www.geogebra.org/material/iframe/id/mqayedkc/width/1280/height/609/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1280px" height="609px" style="border:0px;"> </iframe>
                </div></details>
        </p>
    </section>

    <div class="pagination">
        <a href="A43_5.php">&laquo;</a>
        <a  href="A43_1.php">1</a>
        <a  href="A43_2.php">2</a>
        <a  href="A43_3.php">3</a>
        <a  href="A43_4.php">4</a>
        <a   href="A43_5.php">5</a>
        <a class="active" href="A43_6.php">6</a>
        <a   href="A43_7.php">7</a>


        <a href="A43_7.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"kgatg3mc", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"j4g7cqse","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('kgatg3mc');
        applet2.inject('j4g7cqse');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
