<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA43.html');
?>

<div class="item2">
    <h2>Goniometrické funkcie</h2>


    <section>
        <h3>Funkcie inverzné ku goniometrickým funkciám</h3>
        <p>
            Spomínate si na dvojicu funkcií $\bf{y = e^x}$ a $\bf{y = ln x}$ z predchádzajúcej kapitoly? Podobne ako je
            logaritmická funkcia inverzná ku funkcii exponenciálnej, je možné vytvoriť aj funkcie inverzné ku funkciám
            sínus, kosínus a tangens.

        </p>

        <p>
            Musíme si však dať pozor. Na obrázku vidíte červený graf súmerný s modrým podľa osi 1. kvadrantu. Kým modrá
            krivka je grafom funkcie, červená nie je. (Lebo pre niektoré x nadobúda viacero hodnôt, čo je v rozpore s
            definíciou pojmu funkcia.) Preto inverzná funkcia bude existovať len k takej funkcii, ktorá nadobúda každú
            hodnotu najviac raz. Také funkcie sa volajú <b>prosté</b>. Ak funkcia nie je prostá, inverzná funkcia môže
            existovať len k takej jej časti, ktorá prostá je. Preto nebudeme robiť inverzné funkcie k <b>celým</b>
            funkciám sínus, kosínus a tangens, ale len k ich častiam.
        <div class="center2"><img src="photo/p93.png" alt="obrazok"></div>

        $$\bf{\bbox[yellow, 3px]{y = \sin x, \; x \in \langle - \frac{\pi}{2}; \frac{\pi}{2} \rangle }, \;
        y = \cos x,\; x \in \langle 0; \pi \rangle ,\; y = tg x, \; x \in \langle - \frac{\pi}{2}; \frac{\pi}{2}\rangle}$$
        </p>

        <p>
            Na obrázku vidíte graf funkcie inverznej k funkcii $\bf{\bbox[yellow, 3px]{y = \cos x, \; x \in \langle 0; \pi \rangle}}$.
        <div class="center2"><img src="photo/p94.png" alt="obrazok"></div>
        </p>

        <p>
            Tento obrázok si môžete pozrieť v živej podobe vo výkrese Arccos. Grafy funkcie arkus sínus nájdete vo výkrese
            Arcsin  a graf funkcie arkus tangens si urobte pomocou cabri sami.
            <details class="detail">
                <summary class="summary"><b>Arccos</b></summary><br>
                <div class="center2" id="znhxxbcr"></div>
            </details>

            <details class="detail">
                <summary class="summary"><b>Arcsin</b></summary><br>
                <div class="center2" id="kkab35u6"></div>
            </details>
        </p>

        <h3>Dodatok.</h3>
        <h3>Tabuľky hodnôt goniometrických funkcií.</h3>
        <p>
            Definícia funkcií sínus a kosínus (pozri napr. Jarník: Úvod do počtu diferenciálního) neobsahuje návod, či
            algoritmus na výpočet ich hodnôt, iba ich funkcionálnu charakteristiku. Sínus a kosínus sú podľa tejto
            definície také <mark style="background-color:lime">spojité</mark> funkcie $\bf{f(x), g(x)}$, pre ktoré platí:

            <ul>
                <li>
        <p>
            $\bf{\forall a \in R: f(a+b) = f(a) \cdot g(b) + g(a) \cdot f(b) \; \land \; g(a+b)=g(a)\cdot g(b)-f(a)\cdot f(b)}$
        </p>
        </li>

        <li>
            <p>
                $\bf{f(0) = 0,\; g(0) = 1}$
            </p>
        </li>

        <li>
            <p>
                $\bf{\forall x \in R: g(x) = \sqrt{1-f^2(x)}}$
            </p>
        </li>

        </ul>
        </p>

        <p>
            Dajú sa len z týchto vlastností vypočítať hodnoty týchto funkcií napr. v intervale $\bf{\langle 0; \frac{\pi}{4} \rangle}$?
        </p>

        <p>
            Asi nerozumiete slovu „spojité“. Zatiaľ nám stačí, keď zmysel slov „spojitá funkcia“, budeme chápať tak, že
            to znamená, že malej zmene hodnoty premennej odpovedá malá zmena funkčnej hodnoty. Keďže $\bf{f(0) = 0}$,
            vyložíme si tento fakt tak, že aj pre dostatočné malé $\bf{\delta}$ bude platiť $\bf{f(\delta) ≈ \delta.
        </p>

        <p>
            Naše tabuľky zhotovíme pre $\bf{x \in \langle 0; \frac{\pi}{4}\rangle}$, s krokom (stepom) $\delta = 1$ minúta.
            V radiánovej miere $\bf{\delta = 0.000290888}$. Budeme teda predpokladať, že:
            $$\bf{\sin (\delta) ≈ \delta = 0.000290888 \; a \; \cos(\delta) ≈ \sqrt{1-\delta^2} = 0.999999958 }$$
            ak použijeme počiatočné podmienky $\bf{\sin 0 = 0 ,  \cos 0 = 1}$ a rekurentné vzťahy:
            $$\bf{\sin(x+\delta) = \sin x \cdot \sqrt{1-\delta^2} + \cos x \cdot \delta}$$
            $$\bf{\cos(x+\delta) = \cos x \cdot \sqrt{1-\delta^2} - \sin x \cdot delta }$$
            a budeme pokračovať až po $\bf{\frac{\pi}{4}}$ , dostaneme
            <a href="excel/A4.10.xlsx" download="A4.10.xlsx">
                tabuľky funkcií sínus a kosínus
            </a>.

        </p>

        <p>
            Keď si otvoríte tento zošit, uvidíte že sme pre kontrolu v stĺpcoch G a H uviedli hodnoty týchto funkcií,
            ktoré ponúka EXCEL. Nami vypočítané hodnoty sme uviedli len na toľko desatinných miest, aby sa nelíšili od
            oficiálnych tabuliek.
        </p>
    </section>

    <div class="pagination">
        <a href="A43_6.php">&laquo;</a>
        <a  href="A43_1.php">1</a>
        <a  href="A43_2.php">2</a>
        <a  href="A43_3.php">3</a>
        <a  href="A43_4.php">4</a>
        <a   href="A43_5.php">5</a>
        <a  href="A43_6.php">6</a>
        <a  class="active"  href="A43_7.php">7</a>


        <a href="A43_1.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"znhxxbcr", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"kkab35u6","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('znhxxbcr');
        applet2.inject('kkab35u6');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
