<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA44.html');
?>

<div class="item2">
    <h2>Goniometrické funkcie</h2>


    <section>
        <h3>Úlohy z kapitoly 4.1</h3>

        <ol>
            <li>
                <p>
                    Zrejme platí:

                    $$\pmb{y = |KO| = x + |QO|, |AN| = x + |PN|, \frac{|QO|}{PN} = \frac{1 - x}{1} \Rightarrow}$$
                    $$\pmb{|QO| = (1 - 2x)(1 - x) \Rightarrow}$$
                    $$\pmb{|KO| = y = 2x^2 - 2x + 1 = |KN|^2}$$
                </p>

                <p>
                    Dĺžka úsečky $\pmb{KO}$ teda vyjadruje obsah štvorca $KLMN$.
                </p>

                <p>
                    <details class="detail">
                        <summary class="summary"><b>Pozrite si Cabri výkres Funkcie 04.</b></summary><br>
                        <div class="center2" id="ejwu8tym"></div>
                    </details>

                <div class="center2"><img src="photo/p95.png" alt="obrazok"></div>
                </p>

            </li>

            <li>
                <p>
                    Po experimentovaní s PL01 a PL02 iste viete, že:
                    <details class="detail">
                        <summary class="summary"><b>PL01</b></summary><br>
                        <div class="center2" id="vnctcddf"></div>
                    </details>

                    <details class="detail">
                        <summary class="summary"><b>PL02</b></summary><br>
                        <div class="center2" id="fwxjdamc"></div>
                    </details>

                </p>

                <ul>
                    <li>
                        <p>
                            Paraboly $\pmb{y = a \cdot x^2 + b \cdot x + c}$ a $\pmb{y = p \cdot x^2 + q \cdot x + r}$ sú
                            zhodné (majú rovnaký tvar) práve vtedy, keď $\bbox[yellow, 4px]{\pmb{a = p}}$ .
                        </p>
                    </li>

                    <li>
                        <p>
                            Paraboly $\pmb{y = a \cdot x^2 + b \cdot x + c}$ a $\pmb{y = u \cdot (x - v)^2 + w}$ sú totožné
                            (splývajú) práve vtedy, keď $\bbox[yellow, 4px]{\pmb{u = a, v = - \frac{b}{2a},
                            w = \frac{4ac - b^2}{4a}}}$ .
                        </p>
                    </li>
                </ul>
            </li>

            <li>
                <p>
                    Z výkresu Odraz plynie, že dotyčnica paraboly v bode M je osou uhla $\pmb{FMQ}$. Keďže pre svetelné lúče
                    platí, že uhol odrazu je rovný uhlu dopadu a dotyčnica v blízkosti bodu M nahrádza parabolu, lúče
                    vychádzajúce z ohniska sa odrážajú v smere rovnobežnom s osou paraboly.
                    <details class="detail">
                        <summary class="summary"><b>Odraz</b></summary><br>
                        <div class="center2" id="jsgg4dpm"></div>
                    </details>

                </p>
            </li>

            <li>
                <p>
                    Z experimentu vo výkrese Graf3, ale aj z úvahy $\pmb{y = \frac{ax + b}{x + c} =
                    a + \frac{b - ac}{x + c}}$ plynie, že táto funkcia:

                </p>

                <ul>
                    <li>
                        <p>
                            Nie je definovaná pre $\pmb{x = - c}$.
                        </p>
                    </li>

                    <li>
                        <p>
                            Ak $\pmb{b - ac \neq 0}$, tak nikdy nenadobudne hodnotu $\pmb{a}$. <br>
                            Ak $\pmb{b - ac = 0}$, tak je to funkcia $\pmb{y = a, x \neq - c}$.
                        </p>
                    </li>

                    <li>
                        <p>
                            Pre $\pmb{k = b - ac}$ je jej graf zhodný (má rovnaký tvar) s grafom funkcie
                            $\pmb{y = \frac{k}{x}}$.
                        </p>
                    </li>
                </ul>
                <details class="detail">
                    <summary class="summary"><b>Graf3</b></summary><br>
                    <div class="center2" id="wbffrxma"></div>
                </details>
            </li>

            <li>
                <p>
                    Z faktu, že graf funkcie prechádza piatimi bodmi, dostaneme päť rovníc typu $\pmb{y_i = f(x_i)}$. To
                    stačí na jednoznačné určenie piatich neznámych koeficientov. Preto hľadaná funkcia bude polynóm 4.
                    stupňa: $\pmb{a_4x^4 + a_3x^3 + a_2x^2 + a_1x + a_0}$. Koeficienty $\pmb{a_i}$ sú riešeniami sústavy
                    rovníc, ktorú nájdete aj s riešením v 1. hárku zošitu Funkcie1.
                    <details class="detail">
                        <summary class="summary"><b>Funkcie1 - 1. hárok</b></summary><br>
                        <div class="center2">
                            <iframe scrolling="no" title="A4.11a" src="https://www.geogebra.org/material/iframe/id/bzdydugm/width/944/height/916/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="916px" style="border:0px;"> </iframe>                           </div></details>

                    <details class="detail">
                        <summary class="summary"><b>Hľadaný graf nájdete v G22.</b></summary><br>
                        <div class="center2">
                            <iframe scrolling="no" title="G22" src="https://www.geogebra.org/material/iframe/id/stumhnhd/width/1280/height/609/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="1280px" height="609px" style="border:0px;"> </iframe>
                        </div></details>

                </p>
            </li>

            <li>
                <p>
                    Z toho, že graf funkcie $\pmb{y = \frac{ax + b}{x + c}}$ prechádza bodmi $\pmb{A[1;4],\: B[2;3],\:
                    C[3; 2]}$ dostávame sústavu rovníc:

                    $$\pmb{a + b - 4c = 4}$$
                    $$\pmb{2a + b - 3c = 6}$$
                    $$\pmb{3a + b - 2c = 6},$$
                    ktorá nemá riešenie. Taká linerárna lomená funkcia neexistuje. (Všimnite si, že body $\pmb{A, B, C}$)
                    ležia na jednej priamke.
                </p>
            </li>

            <li>
                <p>
                    Hľadaná funkcia má zrejme tvar $\bf{y = a|x+3| + b|x+1| + c|x-2| + dx +e}$.
                </p>

                <p>
                    Koeficienty $\bf{a, b, c, d, e}$ sú riešeniami sústavy lineárnych rovníc, ktorú spolu s jej
                    riešením nájdete v 2. hárku zošitu  Funkcie1.
                    <details class="detail">
                        <summary class="summary"><b>Funkcie1 - 2. hárok</b></summary><br>
                        <div class="center2">
                            <iframe scrolling="no" title="A4.11b" src="https://www.geogebra.org/material/iframe/id/zmwbqb9m/width/944/height/916/border/888888/sfsb/true/smb/false/stb/false/stbh/false/ai/false/asb/false/sri/false/rc/false/ld/false/sdz/false/ctl/false" width="944px" height="916px" style="border:0px;"> </iframe>                           </div></details>

                    <details class="detail">
                        <summary class="summary"><b>Graf nájdete v Cabri výkrese GF2.</b></summary><br>
                        <div class="center2" id="hvupxwtw"></div>
                    </details>

                <div class="center2"><img src="photo/p96.png" alt="obrazok"></div>
                </p>
            </li>


        </ol>

    </section>

    <div class="pagination">
        <a href="A44_2.php">&laquo;</a>
        <a class="active" href="A44_1.php">1</a>
        <a href="A44_2.php">2</a>

        <a href="A44_2.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"ejwu8tym", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"vnctcddf","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"fwxjdamc", "width":"1400", "height":"600"};
    var applet3 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"jsgg4dpm","width":"1400", "height":"600"};
    var applet4 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"wbffrxma", "width":"1400", "height":"600"};
    var applet5 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"hvupxwtw","width":"1400", "height":"600"};
    var applet6 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('ejwu8tym');
        applet2.inject('vnctcddf');
        applet3.inject('fwxjdamc');
        applet4.inject('jsgg4dpm');
        applet5.inject('wbffrxma');
        applet6.inject('hvupxwtw');

    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
