<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA51.html');
?>

<div class="item2">
    <h2>5.1 Limitné <b><sup><dfn title='Od latinského "limes" = hranica.'>[1]
                </dfn></sup></b> procesy a postupnosti </h2>


    <section>
        <p>
            Väčšina činností, ktoré súvisia s meraním resp. určovaním nejakej hodnoty skúmanej veličiny má povahu
            <b>procesu</b>, ktorý by teoreticky mohol neobmedzene pokračovať, ale ktorý obvykle ukončujeme ak dosiahneme
            prijateľný výsledok. Prijateľným myslíme, že výsledok rešpektuje presnosť vyplývajúcu z kontextu úlohy. Príklady
            takýchto procesov sme už uviedli v predchádzajúcich kapitolách (pri skúmaní dĺžky uhlopriečky štvorca, pri
            približnom výpočte odmocnín, pri výpočte hodnoty $\pmb{ln \: 2}$). Ukážeme ďalšie príklady:
        </p>

        <div class="priklad">
            <h3>Príklad 1.</h3>

            <p>
                Častým limitným procesom je určovanie hmotnosti - váženie. Na obrázku vidíme váhy. Hmotnosť váženého telesa
                je $4.8282$ jednotiek
                <b><sup><dfn title="Prepáčte označenie rozmeru jednotky hmotnosti. Cabri odmeralo obsah nakresleného n-uholníka
    a navyše Cabri píše cm, miesto cm^2.">[2]</dfn></sup></b>, závažia majú hmotnosť $4.83$ jednotiek. Proces merania sme
                ukončili, pretože pridávaním menších závaží ako jedna stotina jednotky nedokážeme pozorovať zmenu výchylky
                ramien váh. Pokračovať v procese môžeme, ak zvýšime citlivosť váh. Môžeme to sledovať dynamicky v Cabri výkrese
                Váhy. Odvážte tam položené teleso s presnosťou na 10 desatiných miest. Keď skončíte, tak pomocou ikony
                "skry - ukáž" si odkryte skutočnú hmotnosť váženého telesa. Túto môžete meničom zmeniť a proces váženia
                opakovať.
            <div class="center2"><img src="photo/p97.png" alt="obrazok"></div>
            <details class="detail">
                <summary class="summary"><b>Váhy</b></summary><br>
                <div class="center2" id="a9ukqajb"></div>
            </details>
            </p>

        </div><br>

        <div class="priklad">
            <h3>Príklad 2.</h3>
            <p>
                Dôležitým "limitným procesom" je meranie dĺžky obvodu kružnice
                <b><sup><dfn title='Už od čias Grékov nazývaný "Rektifikácia kružnice".'>[3]</dfn></sup></b>
                . Ak sa pozriete na obrázok, na ktorom sú pravidelné n-uholníky vpísané do jednotkovej
                kružnice, iste vás napadne, že s rastúcim $\pmb{n}$ sa obvod týchto pravidelných n-uholníkov bude čím ďalej
                tým viac približovať k obvodu kružnice.

            <div class="center2"><img src="photo/p98.png" alt="obrazok"></div>
            </p>

            <p>
                V Cabri výkrese Rektifikácia sme vypočítali a do tabuľky zapísali niektoré hodnoty $\pmb{O(n)}$.

                $$\begin{array}
                {|c|c|}
                \hline n & 3 & 4 & 5 & 6 & 7 & 30\\
                \hline O(n) & 5.1962 & 5.6569 & 5.8779 & 6.0000 & 6.0744 & 6.2717\\
                \hline
                \end{array}$$


            </p>

            <p>
                Ako vidíte, tento spôsob približného určenia čísla $\bf{2\pi}$ (priame meranie dĺžky obvodu) nie je výhodný.
                Nie každý pravidelný n-uholník vieme zostrojiť (Cabri to dokáže cca do $n = 30$), meranie je nepresné a proces
                je „lenivý“, pomaly sa približuje k cieľu.
            </p>

            <p>
                O niečo lepší spôsob by bol nájdenie nejakého rekurentného vzťahu medzi obvodmi vpísaných n-uholníkov.
                Pozrite si obrázok, pomocou ktorého vypočítame  $\bf{O(2n)}$ pomocou $\bf{O(n)}$:
            <div class="center2"><img src="photo/p99.png" alt="obrazok"></div>
            </p>

            <p>
                Zrejme platia vzťahy:
                $$\bf{x = \sqrt{1-\frac{d^2_n}{4}} \qquad d_{2n} = \sqrt{(1-x)^2 + \frac{d^2_n}{4}}} \qquad (^4)$$
                Z týchto vzťahov po úprave dostávame:
                $$\bf{d_{2n} = \sqrt{2-\sqrt{4-d_n^2}}}$$
            </p>

            <p>
                Proces môžeme začať od pravidelného šesťuholníka, pretože vieme, že $\bf{d_6 = 1}$.
            </p>

            <p>
                Na postupný výpočet obvodov vpísaných n-uholníkov sme použili EXCEL (otvorte si zošit Rektifikácia). Proces
                sme ukončili po dvanástich krokoch. Potom začína byť problém s tým, že násobíme príliš malé číslo $\bf{d_n}$
                príliš veľkým číslom $\bf{n}$, čo spôsobuje nepresnosti. Pre porovnanie sme uviedli aj približnú hodnotu
                čísla $\bf{2\pi}$.
            </p>
        </div>
    </section>

    <div class="pagination">
        <a href="A51_1.php">&laquo;</a>
        <a class="active" href="A51_1.php">1</a>
        <!--<a href="A51_2.php">2</a>
        <a  href="A51_3.php">3</a>
         <a href="A51_4.php">4</a>
          <a  href="A51_5.php">5</a>
         <a  href="A51_6.php">6</a>
         <a   href="A51_7.php">7</a>-->

        <a href="A51_1.php">&raquo;</a>
    </div>

</div>
</div>
<script>
    parameters={"material_id":"a9ukqajb", "width":"1400", "height":"600"};
    var applet1 = new GGBApplet(parameters, '5.0', views);

    parameters={"material_id":"","width":"1400", "height":"600"};
    var applet2 = new GGBApplet(parameters, '5.0', views);

    window.onload = function() {
        applet1.inject('a9ukqajb');
        applet2.inject('');
    };

</script>

</body>
<?php
include('footer.html')
?>
</html>
