<?php
include('function.php');
hlavicka('Matematická čítanka');
include('navigationA54.html');
?>

<div class="item2">
    <h2>5.4 Niekoľko optimalizačných príkladov</h2>


    <section>
        <p>
            V tejto kapitole zužitkujeme to, čo sme sa dozvedeli v predchádzajúcich kapitolách a pomocou vhodných
            technológií vyriešime niekoľko príkladov.
        </p>


        <div class="priklad">
            <h3>Príklad 1. Fermatov princíp</h3>

            <p>
                Chceme sa dostať čo najrýchlejšie z bodu $\pmb{A}$ do bodu $\pmb{B}$. Pritom naša rýchlosť v rovine ohraničenej
                priamkou $\pmb{x}$ s vnútorným bodom $\pmb{A}$ je $\pmb{v_a}$ a v opačnej polrovine je naša rýchlosť
                $\pmb{v_b}$. Úlohou je nájsť takú polohu bodou $\pmb{M}$ aby sme dráhu $\pmb{AM + MB}$ prešli v čo najkratšom
                čase. Môžeme si to predstaviť tak, že polrovina obsahujúca bod $\pmb{A}$ je voda a my plávame rýchlosťou
                $\pmb{3 \: km/hod.}$ a opačná polrovina je piesočná pláž, kde "bežíme" rýchlosťou $\pmb{5 \: km/hod.}$ Pritom
                kolmá vzdialenosť bodu $\pmb{A}$ od brehu (od priamky $\pmb{x}$) nech je $4$ km od bodu $\pmb{B \: }3 \: km$
                a nech $d = 11 \: km$.

            </p>

            <h3>Riešenie:</h3>
            <p>
                Pozrime si obrázok<b><sup><dfn title="Ignorujte, že Cabri meria čas v centimetroch. Kalkulačka vydelila
vzdialenosť AM bezrozmernou hodnotou v(A), vzdialenosť MB hodnotou v(B) a podiely sčítala. Na obrázku nie je graf
funkcie y = t(M), ale pre lepšie rozlíšenie je tam graf funkcie y = k*10^t(M).">[1]
                        </dfn></sup></b>:

            <div class="center2"><img src="photo/p104.png" alt="obrazok"></div>
            </p>

            <p>
                Otvorte si Cabri výkres Svetlo, zmeňte hodnoty $\pmb{v_a, v_b}$, prípadne aj $\pmb{OA, PB}$ a $\pmb{OP}$ a
                pohybom bodu $\pmb{M}$ nájdite takú jeho polohu, v ktorej je hodnota $\pmb{t(M)}$ minimálna. Potom porovnajte
                podiel $\pmb{sin \alpha : sin \beta}$ s podielom $\pmb{v_a : v_b}$.
            </p>

            <p>
                Problém si môžete ozrejmiť aj v Excelovskom zošite Svetlo. Urobili sme tam tabuľku funkcie
                $\bbox[yellow, 5px]{t(x) = \frac{\sqrt{OA^2 + x^2}}{v(A)} + \frac{\sqrt{(OP - x)^2 + PB^2}}{v(B)}}$ a v stĺpci
                $E$ sme vypočítali podiel $\pmb{sin \alpha : sin \beta}$.


            </p>

            <p>
                Pomocou funkcie Minimum sme našli minimálnu hodnotu $\pmb{t(min)}$ (pozri bunku $F3$). Prehľadávaním tabuľky
                nájdite riadok, v ktorom nadobúda $\pmb{t(x)}$ minimálnu hodnotu a všimnite si príslušnú hodnotu podielu
                $\pmb{sin \alpha : sin \beta}$.
            </p>

            <p>
                Aj v Exceli môžete meniť hodnoty $\bf{v_a , v_b}$ , prípadne aj $\bf{OA, PB}$ a $\bf{OP}$. Myslím si, že po pár
                experimentoch v Cabri a Exceli budete súhlasiť s hypotézou, že
                $$\bbox[yellow,3px]{\text{Optimálne poloha bodu M, pre ktorú cesta z bodu A do bodu B trvá najkratší čas
                je tá, pre ktorú platí:} \; \bf{\frac{\sin \alpha}{\sin \beta}=\frac{v_a}{v_b} }}.$$
            </p>
        </div>
    </section>

    <div class="pagination">
        <a href="A54_1.php">&laquo;</a>
        <a class="active" href="A54_1.php">1</a>
        <!--<a href="A52_2.php">2</a>
        <a  href="A52_3.php">3</a>
         <a href="A52_4.php">4</a>
          <a  href="A52_5.php">5</a>
         <a  href="A52_6.php">6</a>
         <a   href="A52_7.php">7</a>-->

        <a href="A54_1.php">&raquo;</a>
    </div>

</div>
</div>


</body>
<?php
include('footer.html')
?>
</html>
