import tensorflow as tf
from tensorflow.keras.applications import ResNet50
from tensorflow.keras import layers, models
from tensorflow.keras.preprocessing.image import ImageDataGenerator

# === PARAMETRE ===
IMG_SIZE = (244, 244)
BATCH_SIZE = 32
EPOCHS = 5
DATASET_PATH = "dataset"

# === PRÍPRAVA DÁT ===
datagen = ImageDataGenerator(
    rescale=1./255,
    validation_split=0.2
)

train_generator = datagen.flow_from_directory(
    DATASET_PATH,
    target_size=IMG_SIZE,
    batch_size=BATCH_SIZE,
    class_mode='categorical',
    subset='training'
)

val_generator = datagen.flow_from_directory(
    DATASET_PATH,
    target_size=IMG_SIZE,
    batch_size=BATCH_SIZE,
    class_mode='categorical',
    subset='validation'
)

base_model = ResNet50(weights='imagenet', include_top=False, input_shape=(244, 244, 3))
base_model.trainable = False

x = layers.GlobalAveragePooling2D()(base_model.output)
x = layers.Dense(128, activation='relu')(x)
output = layers.Dense(10, activation='softmax')(x)

model = models.Model(inputs=base_model.input, outputs=output)

model.compile(optimizer='adam', 
              loss='categorical_crossentropy', 
              metrics=['accuracy'])

print("Trénujem model...")
model.fit(
    train_generator,
    epochs=EPOCHS,
    batch_size=BATCH_SIZE)

print("Vyhodnocujem model...")
loss, acc = model.evaluate(val_generator, verbose=2)
print(f"ResNet50 - Presnosť: {acc:.4f}")
