

--AUTOR: Marek Jaroš


drop table if exists zakaznici cascade;
create table zakaznici
(
    zakaznik_id serial primary key,
    meno varchar,
    priezvisko varchar,
    datum_narodenia timestamp,
    kredity numeric,
    body integer
);

drop table if exists cenniky cascade;
create table cenniky
(
    --cennik_id integer primary key not null default nextval('cenniky_increment'),
    cennik_id serial primary key,
    detske numeric,
    studentske numeric,
    normalne numeric,
    seniorske numeric
);

drop table if exists akcie cascade;
create table akcie
(
    --akcia_id integer primary key not null default nextval('akcie_increment'),
    akcia_id serial primary key,
    nazov varchar,
    datum timestamp,
    cennik_id serial references cenniky,
    typ varchar,
    stav varchar
);

drop table if exists sektory cascade;
create table sektory
(
    sektor_id serial primary key,
    oznacenie varchar
);

drop table if exists miesta cascade;
create table miesta
(
    miesto_id serial primary key,
    miesto integer,
    rad integer,
    sektor_id integer references sektory on delete cascade
);

drop table if exists priradene_sektory cascade;
create table priradene_sektory
(
    akcia_id integer references akcie on delete cascade,
    sektor_id integer references sektory
);

drop table if exists listky cascade;
create table listky
(
    listok_id serial primary key,
    zakaznik_id integer references zakaznici,
    akcia_id integer references akcie,
    miesto_id integer references miesta,
    cena numeric,
    typ varchar,
    stav varchar,
    cas timestamp
);

CREATE INDEX IF NOT EXISTS zakaznici_zakaznik_id_index ON zakaznici (zakaznik_id);

CREATE INDEX IF NOT EXISTS listky_miesto_id_index ON listky (miesto_id, akcia_id);
CREATE INDEX IF NOT EXISTS listky_listok_id_index ON listky (listok_id); --(listok_id, akcia_id)

CREATE INDEX IF NOT EXISTS sektory_sektor_id_index ON sektory (sektor_id);
CREATE INDEX IF NOT EXISTS miesta_sektor_id_index ON miesta (sektor_id, rad);
--CREATE INDEX IF NOT EXISTS miesta_rad_index ON miesta (rad);

    /*
drop table if exists zaznamy cascade;
create table zaznamy
(
    zakaznik_id integer references zakaznici,
    listok_id integer references listky,
    cena numeric
);
    */

