/**
 * Author:  Marek Jaros
 * Created: 3. April 2019
 */

-- Najprv zmazeme vsetky data. Mohli by sme to robit rucne cez DELETE po jednej tabulke.
-- Museli by sme ale brat do uvahy zavislosti medzi tabulkami. Takto to za nas spravi TRUNCATE.

truncate table akcie, cenniky, listky, miesta, sektory, zakaznici cascade;
truncate table priradene_sektory cascade;

---- pomocne tabulky na generovanie dat

-- tabulka s cislami (z nej cerpam nahodne cisla)
drop table if exists random_numbers cascade;
create table random_numbers
(
    number integer
);

insert into random_numbers select generate_series(1, 50000);
/*
create or replace function make_random_numbers(n integer) returns void language plpgsql as
$body$
begin
    for nmb in 1..n loop
        insert into random_numbers (number) values (nmb);
    end loop;
end;
$body$

do $$ begin
    perform make_random_numbers(50000);
end $$;
*/
-- first names

drop table if exists male_first_names cascade;
create table male_first_names
(
	first_name varchar
);

insert into male_first_names (first_name)
values	('Adam'), ('Andrej'), ('Branislav'), ('Boris'), ('Cyril'),
		  ('Daniel'), ('Dávid'), ('Dominik'), ('Erik'), ('Emil'),
		  ('František'), ('Filip'), ('Gustáv'), ('Gábor'), ('Hugo'),
		  ('Ivan'), ('Igor'), ('Jaroslav'), ('Ján'), ('Kevin'),
		  ('Karol'), ('Lukáš'), ('Libor'), ('Marek'), ('Marko'),
		  ('Milan'), ('Otakar'), ('Oto'), ('Peter'), ('Patrik'),
		  ('Rastislav'), ('Rudo'), ('Stanislav'), ('Tibor'), ('Xavier'),
		  ('Arpád'), ('Bruno'), ('Cecil'), ('Dalibor'), ('Enrike'),
		  ('Gregor'), ('Juraj'), ('Ladislav'), ('Oskar'), ('Štefan');


drop table if exists female_first_names cascade;
create table female_first_names
(
	first_name varchar
);

insert into female_first_names (first_name)
values	('Aneta'), ('Radka'), ('Helenka'), ('Kika'), ('Martina'),
		  ('Daniela'), ('Monika'), ('Dominika'), ('Erika'), ('Emília'),
		  ('Tamara'), ('Karin'), ('Veronika'), ('Tereza'), ('Lucia'),
		  ('Ivana'), ('Petra'), ('Jaroslava'), ('Jana'), ('Rozália');

-- last names

drop table if exists male_last_names cascade;
create table male_last_names
(
	last_name varchar
);

insert into male_last_names (last_name)
values	('Adámik'), ('Šoltéz'), ('Tábori'), ('Jaroš'), ('Šimko'),
		  ('Glenda'), ('Jánošík'), ('Višnovský'), ('Petrovický'), ('Hossa'),
		  ('Kotman'), ('Vlkovič'), ('Gyarfaš'), ('Valentovič'), ('Slimák'),
		  ('Horecký'), ('Blaho'), ('Siska'), ('Babic'), ('Hrušecký'),
		  ('Ferko'), ('Vazal'), ('Veselý'), ('Smutný'), ('Krásny'),
		  ('Pekný'), ('Lehocký'), ('Malý'), ('Veľký'), ('Usmiaty'),
		  ('Beznohý'), ('Bezstarostný'), ('Mokrý'), ('Suchý'), ('Dnešný'),
		  ('Fľakatý'), ('Krátkonohý'), ('Csiba'), ('Chyba'), ('Omyl');


drop table if exists female_last_names cascade;
create table female_last_names
(
	last_name varchar
);

insert into female_last_names (last_name)
values	('Adámiková'), ('Šoltézová'), ('Táboriová'), ('Jarošová'), ('Šimková'),
		  ('Glendová'), ('Jánošíková'), ('Višnovská'), ('Petrovická'), ('Hossová'),
		  ('Kotmanová'), ('Vlkovičová'), ('Gyarfašová'), ('Valentovičová'), ('Slimáková'),
		  ('Horecká'), ('Blahová'), ('Sisková'), ('Babicová'), ('Hrušecká');

-- birth days

drop table if exists birth_days cascade;
create table birth_days
(
    birth_day date
);

insert into birth_days (birth_day)
values	(to_date('1989-04-05', 'yyyy-mm-dd')), (to_date('1998-01-07', 'yyyy-mm-dd')), (to_date('1962-11-01', 'yyyy-mm-dd')),
    (to_date('1983-03-25', 'yyyy-mm-dd')), (to_date('1991-01-15', 'yyyy-mm-dd')), (to_date('2000-10-10', 'yyyy-mm-dd')),
    (to_date('1969-10-28', 'yyyy-mm-dd')), (to_date('1995-05-11', 'yyyy-mm-dd')), (to_date('1945-12-24', 'yyyy-mm-dd')),
    (to_date('1999-09-09', 'yyyy-mm-dd')), (to_date('1973-12-04', 'yyyy-mm-dd')), (to_date('1989-05-04', 'yyyy-mm-dd')),
    (to_date('1992-06-18', 'yyyy-mm-dd')), (to_date('1989-11-17', 'yyyy-mm-dd')), (to_date('1976-11-04', 'yyyy-mm-dd')),
	(to_date('1975-10-09', 'yyyy-mm-dd')), (to_date('1977-07-15', 'yyyy-mm-dd')), (to_date('1962-12-25', 'yyyy-mm-dd')),
	(to_date('1976-06-05', 'yyyy-mm-dd')), (to_date('1977-07-07', 'yyyy-mm-dd'));

-- city names

drop table if exists team_names cascade;
create table team_names
(
    team_name varchar
);

insert into team_names (team_name)
values	('New York Rangers'), ('Los Angeles Kings'), ('Chicago Blackhawks'), ('Houston Problems'), ('Philadelphia Flyers'),
	('Las Vegas Knights'), ('San Antonio Giants'), ('San Diego'), ('Dallas Cowboys'), ('San Jose Sharks'),
	('Austin Club'), ('Jacksonville Wizzards'), ('San Francisco Islanders'), ('Indianapolis'), ('Columbus Jackets'),
	('Fort Worth Hockey Club'), ('Charlotte Club'), ('Detroit Red Wings'), ('El Paso Chihuahuas'), ('Seattle Seahawks');

---- hlavne tabulky

-- zakaznici

create or replace function random_male_first_name() returns varchar language sql as
$$
    select first_name from male_first_names tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_female_first_name() returns varchar language sql as
$$
    select first_name from female_first_names tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_male_last_name() returns varchar language sql as
$$
    select last_name from male_last_names tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_female_last_name() returns varchar language sql as
$$
    select last_name from female_last_names tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_birth_day() returns date language sql as
$$
    select birth_day from birth_days tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_team_name() returns varchar language sql as
$$
    select team_name from team_names tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_user_id() returns integer language sql as
$$
    select zakaznik_id from zakaznici tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_akcia_id() returns integer language sql as
$$
    select akcia_id from akcie tablesample system_rows(10) order by random() limit 1
$$;

--create or replace function random_number(number integer) returns integer
create or replace function get_cennik_id(id integer) returns integer language sql as
$$
    select cennik_id from akcie where akcia_id = id;
$$;

create or replace function get_adult_price(id integer) returns numeric language sql as
$$
    select normalne from cenniky where cennik_id = id;
$$;

create or replace function get_random_number_from_random_numbers(min integer, max integer) returns integer language sql as
$$
    select number from random_numbers where number >= min AND number <= max order by random() limit 1;
$$;

create or replace function get_total_count_of_seats() returns bigint language sql as
$$
    select count(*) from miesta;
$$;

create or replace function random_date(fromDate date, toDate date) returns date language sql as
$$
    select floor(random()*(toDate-fromDate))::integer + fromDate
$$;

create or replace function random_date_for_ticket(eventTimeStamp timestamp) returns timestamp language sql as
$$
    select eventTimeStamp - '60 days'::interval;
$$;

create or replace function get_event_date(eventId integer) returns timestamp language sql as
$$
    select datum from akcie where akcia_id = eventId;
$$;

create or replace function get_ticket_state(eventDate timestamp) returns varchar language plpgsql as
$body$
declare
    state varchar;
begin
    if eventDate < current_timestamp then
        state := 'P';       --ak je akcia uz skoncena, listky su 'P' pouzite
    else
        if 1 = get_random_number_from_random_numbers(0,2) then
            state := 'R';   --ak je akcia este neskoncena, listky su bud 'R' alebo 'N'
        else
            state := 'N';
        end if;
    end if;
    return state;
end;
$body$;

create or replace function create_tickets(pocet_akcii integer) returns void language plpgsql as
$body$
declare
    akcia integer;
    cennik integer;
    zakaznik integer;
    miesto integer;
    cena_listka numeric;
    pocet_miest_na_stadione integer;
    datum_listka timestamp;
    datum_akcie timestamp;
begin
    -- for akcia in select akcia_id from akcie loop
    pocet_miest_na_stadione = get_total_count_of_seats();
    for akcia in select akcia_id from akcie order by random() limit pocet_akcii loop
        cennik = get_cennik_id(akcia);
        cena_listka = get_adult_price(cennik);
        datum_akcie = get_event_date(akcia);
        for miesto in select number from random_numbers where number < pocet_miest_na_stadione order by random() limit get_random_number_from_random_numbers(1000, 3000) loop
            zakaznik = random_user_id();
            datum_listka = random_date_for_ticket(datum_akcie);
            insert into listky (zakaznik_id, akcia_id, miesto_id, cena, typ, stav, cas) values
                (zakaznik, akcia, miesto, cena_listka, 'N', /*get_ticket_state(datum_akcie)*/ 'P' , datum_listka);
        end loop;
    end loop;
end;
$body$;

create or replace function create_places(rows integer, places integer) returns void language plpgsql as
$body$
declare
    s integer;
    --rows integer := ;
    --places integer := 30;
begin
    for s in select sektor_id FROM sektory loop
        for r in 1..rows loop
            for p in 1..places loop
                insert into miesta (miesto, rad, sektor_id) values (p, r, s);
            end loop;
        end loop;
    end loop;
end;
$body$;

create or replace function alloc_sectors(event_count integer, count integer) returns void language plpgsql as
$body$
begin
    for event in 1..event_count loop
        for sector in 1..count loop
            insert into priradene_sektory (akcia_id, sektor_id) values (event, sector);
        end loop;
    end loop;
end;
$body$;


-- cenniky

insert into cenniky (detske, studentske, normalne, seniorske)
select	get_random_number_from_random_numbers(0, 100),
		get_random_number_from_random_numbers(100, 200),
        get_random_number_from_random_numbers(200, 300),
        get_random_number_from_random_numbers(100, 200)
from generate_series(1, 100) as seq(i);


-- zakaznici

--admin ucet
insert into zakaznici (meno, priezvisko, datum_narodenia, kredity, body) VALUES ('Admin', 'Ucet', '1990-10-10', 0, 0);


insert into zakaznici (meno, priezvisko, datum_narodenia, kredity, body)
select	random_male_first_name(),
        random_male_last_name(),
        random_birth_day(), 
        random() * 1000,
		round(random() * 1000)
from generate_series(1, 200000) as seq(i);

insert into zakaznici (meno, priezvisko, datum_narodenia, kredity, body)
select	random_female_first_name(),
		random_female_last_name(),
		random_birth_day(),
		random() * 1000,
		round(random() * 1000)
from generate_series(1, 100000) as seq(i);

--sektory
insert into sektory(oznacenie)
select 'PLACEHOLDER'
from generate_series(1, 20);

-- akcie
insert into akcie (nazov, datum, cennik_id, typ, stav)
select random_team_name() || ' vs. ' || random_team_name(),
	   to_timestamp('2019-01-01 10:00:00', 'yyyy-mm-dd hh24:mi:ss') + (trunc(round(random() * 720)) * '1 day'::interval),
       round(random() * 99) + 1,
       'G',
       'N'  --dafualtne
from generate_series(1, 20) as seq(i);

do $$ begin
    perform alloc_sectors(20, 20);
end $$;

-- vytvaranie miest na stadione
do $$ begin
	perform create_places(15, 35);
end $$;

-- listky
do $$ begin
    perform create_tickets(20);
end $$;



-- zaver; upratovanie

drop table random_numbers, male_first_names, male_last_names, female_first_names, female_last_names, team_names cascade;

--drop function make_random_numbers(n integer);
drop function random_male_first_name();
drop function random_male_last_name();
drop function random_female_first_name();
drop function random_female_last_name();
drop function random_birth_day();
drop function random_team_name();
drop function get_cennik_id(id integer);
drop function get_adult_price(id integer);

drop function create_tickets(pocet_akcii integer);
drop function create_places(rows integer, places integer);
