import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class AccountMenu implements Menu{
    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    Customer customer;
    int customerId;

    public AccountMenu(int id) throws SQLException {
        customerId = id;
        customer = Customer.findById(id);   //je dobre, inac by uz predtym[Main] hodilo chybu
    }

    public Customer getCustomer() { return customer; }

    @Override
    public boolean showMenu() throws IOException {
        System.out.println("===============================");
        System.out.println("|        ACCOUNT MENU         |");
        System.out.println("+=============================+");
        System.out.println("| 1. Show all events          |");
        System.out.println("| 2. Show upcoming events     |");
        System.out.println("| 3. Show a event             |");
        System.out.println("|                             |");
        System.out.println("| 4. Make a reservation       |");
        System.out.println("| 5. Pay reserved tickets     |");
        System.out.println("| 6. History of your tickets  |");
        System.out.println("| 7. Use your ticket          |");
        System.out.println("|                             |");
        System.out.println("| 10. Add credit              |");
        System.out.println("| 11. Show 'My Profile'       |");
        System.out.println("| 12. Edit 'My Profile'       |");
        System.out.println("|                             |");
        System.out.println("| 0. Exit application         |");
        System.out.println("===============================");
        System.out.println();

        return makeAChoice();
    }

    @Override
    public boolean makeAChoice() throws IOException {
        System.out.print("Your option > ");
        String option = br.readLine().strip();

        try {
            boolean result; //nadaval, ak bol pri '0' len return, preto takto
            switch (option) {
                case "1":   EventMenu.showAllEvents(); result = true; break;
                case "2":   EventMenu.showUpcomingEvents(); result = true; break;
                case "3":   EventMenu.showEvent(); result = true; break;
                case "4":   makeAReservation(); result = true; break;
                case "5":   customer.payTickets(); result = true; break;
                case "6":   showTickets(); result = true; break;
                case "7":   customer.useTicket(); result = true; break;
                case "10":  addCredit(); result = true; break;
                case "11":  Printer.print(customer); result = true; break;
                case "12":  customer.editCustomer(); result = true; break;
                case "0":   result = false; break;
                default:    System.out.println("Unknown option ..."); result = true; break;
            }

            return result;
            //} catch(SQLException | IOException | InterruptedException e) {
        } catch(IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void addCredit() throws SQLException, IOException {
        try {
            DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
            DbContext.getConnection().setAutoCommit(false);

            customer.addCredit();
            reloadCustomer();
        }
        catch(SQLException e){
            DbContext.getConnection().rollback();
            throw e;
        }
        finally{
            DbContext.getConnection().setAutoCommit(true);
        }
    }

    public void makeAReservation() throws SQLException, IOException {
        try {
            System.out.println("You are making a reservation ...");

            System.out.print("Enter a event's ID> ");
            int eventId = Integer.parseInt(br.readLine().strip());

            Event event = Event.findById(eventId);

            if (event != null) {
                customer.selectTickets(event);  //stav N davat kupenym!
            } else {
                System.out.println("No such event with ID = " + eventId + ".");
            }
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format for event's ID. Try again later.");
        }
        catch(SQLException | IOException e){
            System.out.println("Ooops. Something went wrong. Try again later.");
        }
    }

    public void showTickets() throws SQLException {
        try {
            System.out.println("Your ticket history:");
            System.out.println("Which tickets do you want to show?");
            System.out.println("R - reserved, N - buyed, not used, U - buyed, used");

            String state = br.readLine().strip().toLowerCase();

            customer.showTickets(state);
        }
        catch(IOException e){
            System.out.println("Ooops. Something went wrong. Try again later.");
        }
    }

    public void reloadCustomer() throws SQLException {
        customer = Customer.findById(customerId);
    }

    //zakladne funkcie

    @Override
    public void mainloop() throws IOException {
        try{
            while(showMenu());
        }
        catch(Exception e){
            //throw new Error("Something wrong happend ...");
            throw e;
        }
    }
}
