import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;

public class AdminMenu implements Menu {
    @Override
    public boolean showMenu() throws IOException {
        System.out.println("===============================");
        System.out.println("|         ADMIN MENU          |");
        System.out.println("+=============================+");
        System.out.println("| 1. Show customer menu       |");
        System.out.println("| 2. Show price list menu     |");
        System.out.println("| 3. Show event menu          |");
        System.out.println("|                             |");
        System.out.println("| 4. Sell tickets             |");
        System.out.println("| 5. Pay reserved tickets     |");
        System.out.println("|                             |");
        System.out.println("| 0. Exit application         |");
        System.out.println("===============================");
        System.out.println();

        return makeAChoice();
    }

    @Override
    public boolean makeAChoice() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        System.out.print("Your option > ");
        String option = br.readLine().strip();

        try {
            boolean result; //nadaval, ak bol pri '0' len return, preto takto
            switch (option) {
                case "1":   showCustomerMenu(); result = true; break;
                case "2":   showPriceListMenu(); result = true; break;
                case "3":   showEventMenu(); result = true; break;
                case "4":   sellTickets(); result = true; break;
                case "5":   payReservedTickets(); result = true; break;
                case "0":   exit(); result = false; break;
                default:    System.out.println("Unknown option ..."); result = true; break;
            }

            return result;
            //} catch(SQLException | IOException | InterruptedException e) {
        } catch(IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void showCustomerMenu() throws IOException {
        CustomerMenu menu = new CustomerMenu();
        menu.mainloop();
    }

    public void showPriceListMenu() throws IOException {
        PriceListMenu menu = new PriceListMenu();
        menu.mainloop();
    }

    public void showEventMenu() throws IOException {
        EventMenu menu = new EventMenu();
        menu.mainloop();
    }

    public void sellTickets() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        Customer customer = new Customer(); //ucet s ID = null a nekonecne penazi
        try{
            System.out.println("Select event's ID > ");
            int eventId = Integer.parseInt(br.readLine().strip());

            Event event = Event.findById(eventId);
            if(event != null){
                customer.selectTickets(event);
                customer.payTickets(true);

                //vsetky co nezaplatil, sa zmazu
                for(Ticket ticket: Ticket.findTicketsByCustomerIdWithState(customer.getId(), "R")){
                    ticket.delete();
                }
            }
            else{
                System.out.println("Wrong event'ID. Event not found.");
            }
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format. Try again.");
        }
        catch(SQLException | IOException e){
            System.out.println("Ooops, something went wrong. Try again later");
        }
    }

    public void payReservedTickets() {
        try{
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

            System.out.println("Select customer's ID > ");
            int customerId = Integer.parseInt(br.readLine().strip());

            Customer customer = Customer.findById(customerId);

            if(customer != null){
                customer.payTickets(true);
            }
            else{
                System.out.println("Wrong customer's ID. Customer not found.");
            }
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format. Try again.");
        }
        catch (SQLException | IOException e) {
            System.out.println("Ooops, something went wrong. Try again later.");
        }
    }

    public void showMenu(Menu menu) throws IOException {
        menu.mainloop();
    }

    //zakladne funkcie
    @Override
    public void mainloop() throws IOException {
        try{
            while(showMenu());
        }
        catch(Exception e){
            //throw new Error("Something wrong happend ...");
            throw e;
        }
    }

    public void exit() throws SQLException {
        DbContext.clear();
        System.exit(0);
    }
}
