import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;

public class CustomerMenu implements Menu{

    @Override
    public boolean showMenu() throws IOException {
        System.out.println("===============================");
        System.out.println("|        CUSTOMER MENU        |");
        System.out.println("+=============================+");
        System.out.println("| 1. Show all customers       |");
        System.out.println("| 2. Show a customer          |");
        System.out.println("| 3. Add new customer         |");
        System.out.println("| 4. Add credit to a customer |");
        System.out.println("| 5. Edit a customer          |");
        System.out.println("| 6. Delete a customer        |");
        System.out.println("|                             |");
        System.out.println("| 0. Back to main menu        |");
        System.out.println("===============================");
        System.out.println();

        return makeAChoice();
    }

    @Override
    public boolean makeAChoice() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        System.out.print("Your option > ");
        String option = br.readLine().strip();

        try {
            boolean result = true; //nadaval, ak bol pri '0' len return, preto takto
            switch (option) {
                case "1":   showAllCustomers(); result = true; break;
                case "2":   showCustumer(); result = true; break;
                case "3":   addNewCustomer(); result = true; break;
                case "4":   addCreditToCustomer(); result = true; break;
                case "5":   editCustomer(); result = true; break;
                case "6":   deleteCustomer(); result = true; break;
                case "0":   result = false; break;
                default:    System.out.println("Unknown option ..."); result = true; break;
            }

            return result;
        //} catch(SQLException | IOException | InterruptedException e) {
        } catch(SQLException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void showAllCustomers() throws SQLException {
        int count = 0;
        ArrayList<Customer> customers = Customer.findAll();
        for(Customer customer: customers){
            Printer.print(customer);
            System.out.println((++count != customers.size() ? "+-- -- -- - - --- - - -- -- --+" : "\nTotal count of shown users: " + count));
        }
    }

    public void showCustumer() throws SQLException, IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        System.out.println("Enter a customer's ID> ");
        int customerId = Integer.valueOf(br.readLine().strip());

        Customer customer = Customer.findById(customerId);

        if(customer != null){
            Printer.print(customer);
        }
        else{
            System.out.println("No such customer with ID = " + customerId + ".");
        }
    }

    public void addNewCustomer() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        //SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd");
        Customer customer = new Customer();

        //vytvaranie noveho zakaznika
        try {
            System.out.println("You are adding new customer ...");
            System.out.println("First name > ");
            customer.setFirstName(br.readLine().strip());
            System.out.println("Last name > ");
            customer.setLastName(br.readLine().strip());
            System.out.println("Birth day (yyyy-MM-dd) > ");
            customer.setBirthDate(LocalDate.parse(br.readLine().strip()));
            System.out.println("Want add some credit? [Y/N] > ");
            if (br.readLine().strip().toLowerCase().equals("y")) {
                System.out.println("Select amount > ");
                customer.setCredits(new BigDecimal(br.readLine().strip()));
            } else {
                customer.setCredits(new BigDecimal(0));
            }
            customer.setPoints(0);

            customer.insert();

            System.out.println();
            System.out.println("Customer has been succesfully added!");
            System.out.println("Customer's id is: " + customer.getId());
        }
        catch(DateTimeParseException e){
            System.out.println("Wrong date format! Try again later.");
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format! Try again later.");
        }
    }

    public void addCreditToCustomer() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        try {
            System.out.println("You are adding credit to a customer ...");
            System.out.println("Enter a customer's ID> ");
            int customerId = Integer.valueOf(br.readLine().strip());

            Customer customer = Customer.findById(customerId);

            if (customer != null) {
                customer.addCredit();
            } else {
                System.out.println("No such customer with ID = " + customerId + ".");
            }
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format for customer's ID. Try again later.");
        }
    }

    public void editCustomer() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        try {
            System.out.println("You are editing a customer ...");
            System.out.println("Enter a customer's ID> ");
            int customerId = Integer.valueOf(br.readLine().strip());

            Customer customer = Customer.findById(customerId);

            if (customer != null) {
                Printer.print(customer);
                System.out.println("+-- -- -- - - --- - - -- -- --+");
                customer.editCustomer();

                System.out.println("The customer has been succesfully updated");
            } else {
                System.out.println("No such customer with ID = " + customerId + ".");
            }
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format for customer's ID! Try again later.");
        }
    }

    public void deleteCustomer() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        try {
            System.out.println("You are deleting a customer ...");
            System.out.println("Enter a customer's ID> ");
            int customerId = Integer.valueOf(br.readLine().strip());

            Customer customer = Customer.findById(customerId);

            if (customer != null) {
                customer.delete();
                System.out.println("The customer has been succesfully deleted");
            } else {
                System.out.println("No such customer with ID = " + customerId + ".");
            }
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format for customer's ID! Try again later.");
        }
    }

    @Override
    public void mainloop() throws IOException {
        try{
            while(showMenu());
        }
        catch(Exception e){
            throw new Error("Something wrong happend ...");
        }
    }
}
