import java.sql.Connection;
import java.sql.SQLException;

public class DbContext {
    private static Connection connection;

    public static void setConnection(Connection connection){
        if(connection == null){
            throw new NullPointerException("connection nie je nastavene (null)");
        }

        DbContext.connection = connection;
    }

    public static Connection getConnection() {
        if (connection == null) {
            throw new IllegalStateException("Nemoze vratit connection, nakolko nie je nastavene");
        }

        return connection;
    }

    public static void clear() throws SQLException {
        connection.close();
        connection = null;
    }

}