import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;

public class EventMenu implements Menu {
    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    @Override
    public boolean showMenu() throws IOException {
        System.out.println("===============================");
        System.out.println("|         EVENT MENU          |");
        System.out.println("+=============================+");
        System.out.println("| 1. Show all events          |");
        System.out.println("| 2. Show upcoming events     |");
        System.out.println("| 3. Show a event             |");
        System.out.println("| 4. Add new event            |");
        System.out.println("| 5. Edit a event             |");
        System.out.println("| 6. Delete a event           |");
        System.out.println("|                             |");
        System.out.println("| 7. Show event stats         |");
        System.out.println("|                             |");
        System.out.println("| 0. Back to main menu        |");
        System.out.println("===============================");
        System.out.println();

        return makeAChoice();
    }

    @Override
    public boolean makeAChoice() throws IOException {
        System.out.print("Your option > ");
        String option = br.readLine().strip();

        try {
            boolean result = true; //nadaval, ak bol pri '0' len return, preto takto
            switch (option) {
                case "1":   showAllEvents(); result = true; break;
                case "2":   showUpcomingEvents(); result = true; break;
                case "3":   showEvent(); result = true; break;
                case "4":   addNewEvent(); result = true; break;
                case "5":   editEvent(); result = true; break;
                case "6":   deleteEvent(); result = true; break;
                case "7":   stats(); result = true; break;       //TEST iba!!!
                case "0":   result = false; break;
                default:    System.out.println("Unknown option ..."); result = true; break;
            }

            return result;
            //} catch(SQLException | IOException | InterruptedException e) {
        } catch(IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void stats() throws SQLException, IOException {
        System.out.print("Enter a event's ID> ");
        int eventId = Integer.valueOf(br.readLine().strip());

        Event event = Event.findById(eventId);

        if(event != null){
            System.out.println("Total count of available places: " + event.totalPlacesCounter());
            System.out.println("Total count of sell tickets: " + event.sellTicketsCounter());
            System.out.println("Total price earned: " + event.totalPrice());
            double percentage = (double) event.sellTicketsCounter() / (double) event.totalPlacesCounter() * 100;
            System.out.println("Arena usage: " +  percentage);
        }
        else {
            System.out.println("No such event with ID = " + eventId + ".");
        }
    }

    public static void showAllEvents() throws SQLException {
        int count = 0;
        ArrayList<Event> events = Event.findAll();
        for(Event event: events){
            Printer.print(event);
            System.out.println((++count != events.size() ? "\n" : "\nTotal count of shown price lists: " + count));
        }
    }

    public static void showUpcomingEvents() throws SQLException, IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        System.out.println("How many upcoming events you want show? >");
        int count = Integer.parseInt(br.readLine().strip());

        ArrayList<Event> events = Event.findEventOrderByTime(count);
        for(Event event: events){
            Printer.printInline(event);
        }
    }

    public static void showEvent() throws IOException, SQLException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        System.out.println("Enter a event's ID> ");
        int eventId = Integer.valueOf(br.readLine().strip());

        Event event = Event.findById(eventId);

        if(event != null){
            Printer.print(event);
        }
        else{
            System.out.println("No such event with ID = " + eventId + ".");
        }
    }

    public void addNewEvent() throws IOException, SQLException {
        Event event = new Event();

        //vytvaranie noveho eventu
        try {
            boolean creatingNewPriceList = false;

            System.out.println("You are adding new event ...");
            System.out.println("Do you want to create a new price list for event? [Y/N] > ");
            if (br.readLine().strip().toLowerCase().equals("y")) {
                creatingNewPriceList = true;
                event.setPriceListId(new PriceListMenu().addNewPriceList());
                System.out.println("Back to creating a new price list ...");
            }

            System.out.println("Event name > ");
            event.setName(br.readLine().strip());

            boolean isSetTime = false;
            Timestamp time = null;
            while(!isSetTime){
                System.out.println("Event day (YYYY-MM-DD HH:MM:SS) > ");
                time = Timestamp.valueOf(br.readLine().strip());
                if(1 != time.compareTo(new Timestamp(System.currentTimeMillis()))){
                    System.out.println("You cannot set time in past. Please, try again.");
                }
                else{
                    isSetTime = true;
                }
            }
            event.setEventDate(time);

            System.out.println("Set event type (G - regular game, P - play-off game, E - event)");
            event.setType(br.readLine().strip());

            if (!creatingNewPriceList) {
                System.out.println("Price list's id for event > ");
                event.setPriceListId(Integer.valueOf(br.readLine().strip()));
            }

            boolean setingSectors = true;
            int sectorsCount = Place.totalCountOfSectorsOnStadium();
            System.out.println("Stadium have " + sectorsCount + " sectors");
            System.out.println("Write '2-5' for adding sectors <2,5> or write '1,4,9' for adding sectors {1,4,9}");
            while (setingSectors) {
                try {
                    System.out.println("Set sectors for event > ");
                    event.setSectors(event.makeSectorsFromString(br.readLine().strip(), sectorsCount)); //makeSectors vracia pole sectorov a to sa potom priradi
                    setingSectors = false;
                }
                catch(IllegalArgumentException e){
                    System.out.println(e.getMessage());
                    System.out.println("Try again.");
                }
            }

            event.insert();
            event.setSectorsOnStadium();

            System.out.println();
            System.out.println("Event has been succesfully added!");
            System.out.println("Event's id is: " + event.getId());
        }
        catch (Exception e){
            System.out.println("Something went wrong. Please, try again.");
        }
    }

    public void editEvent() throws IOException, SQLException {
        System.out.println("You are editing a event ...");
        System.out.println("Enter a event's ID> ");
        int eventId = Integer.valueOf(br.readLine().strip());

        Event event = Event.findById(eventId);

        if(event == null){
            System.out.println("No such event with ID = " + eventId + ".");
        }
        else{
            Printer.print(event);

            System.out.println("+-- -- -- - - --- - - -- -- --+");
            boolean creatingNewPriceList = false;
            System.out.println("You are editing new event ...");
            System.out.println("Do you want to create a new price list for event? [Y/N]");
            if(br.readLine().strip().toLowerCase().equals("y")){
                creatingNewPriceList = true;
                event.setId(new PriceListMenu().addNewPriceList());
                System.out.println("Back to editing a new price list ...");
            }
            System.out.println("New event name > ");
            event.setName(br.readLine().strip());
            System.out.println("New event day (YYYY-MM-DD HH:MM:SS) > ");
            event.setEventDate(Timestamp.valueOf(br.readLine().strip()));
            System.out.println("Set event type (G - regular game, P - play-off game, E - event)");
            event.setType(br.readLine().strip());
            if(!creatingNewPriceList){
                System.out.println("New price list's id for event > ");
                event.setId(Integer.valueOf(br.readLine().strip()));
            }

            event.update();

            System.out.println("The event has been succesfully updated");
        }
    }

    public void deleteEvent() throws IOException, SQLException {
        System.out.println("You are deleting a event ...");
        System.out.println("Enter a event's ID> ");
        int eventId = Integer.valueOf(br.readLine().strip());

        Event event = Event.findById(eventId);

        if(event == null){
            System.out.println("No such event with ID = " + eventId + ".");
        }
        else{
            event.delete();     //cascade delete zmaze aj zaznam z priradene_cenniky
            //event.deleteSectorsOnStadium();

            System.out.println("The event has been succesfully deleted");
        }
    }

    @Override
    public void mainloop() throws IOException {
        try{
            while(showMenu());
        }
        catch(Exception e){
            //throw new Error("Something wrong happend ...");
            throw e;
        }
    }
}
