import org.postgresql.ds.PGSimpleDataSource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;


/**
 * @author Marek Jaroš
 *
 * <p>
 *     Hlavna
 * </p>
 */
public class Main {

    /**
     *<p>
     *     Funkcia sluzi na prihlasenie sa do konta uzivatela.
     *</p>
     * @return ID uzivatela, na ktoreho sa pouzivatel prihlasil [Admin = 1]
     */
    public static int loginIntoAccount(){
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

        System.out.println("[ADMIN] = 1");
        System.out.println("Enter your login id > ");

        while(true) {
            try {
                int id = Integer.parseInt(br.readLine().strip());

                Customer customer = Customer.findById(id);
                if(customer == null){
                    System.out.println("User with id = " + id + " doesn't exist. Try again");
                    continue;
                }

                System.out.println("Successfully logged in as " + customer.getFirstName());
                return id;
            }
            catch (NumberFormatException e){
                System.out.println("Cannot parse into integer. Try again.");
            }
            catch(SQLException | IOException e){
                System.out.println("Something went wrong. Try again later.");
            }
        }
    }

    /**
     *<p>
     *     Spusta cely program.
     *</p>
     * @throws SQLException
     */
    public static void main(String[] args) throws SQLException {
        try{
            PGSimpleDataSource dataSource = new PGSimpleDataSource();

            dataSource.setServerName("db.dai.fmph.uniba.sk");
            dataSource.setPortNumber(5432);
            dataSource.setDatabaseName("playground");
            dataSource.setUser("jaros20@uniba.sk");
            dataSource.setPassword("mm123456");

            try (Connection connection = dataSource.getConnection()) {
                DbContext.setConnection(connection);

                int id = loginIntoAccount();

                if (id == 1) {
                    AdminMenu adminMenu = new AdminMenu();
                    adminMenu.mainloop();
                } else {
                    AccountMenu accountMenu = new AccountMenu(id);
                    accountMenu.mainloop();
                }
            }
        }
        catch (SQLException | IOException e){
            System.out.println("Something went wrong. Try again later.");
        }
        finally {
            DbContext.clear();
        }
    }
}