import javax.management.BadAttributeValueExpException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class Place {
    int id;
    int place;
    int row;
    int sectorId;

    //get funkcie
    public int getId() {
        return id;
    }

    public int getPlace() {
        return place;
    }

    public int getRow() {
        return row;
    }

    public int getSectorId() {
        return sectorId;
    }

    //set funkcie
    public void setId(int id) {
        this.id = id;
    }

    public void setPlace(int place) {
        this.place = place;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setSectorId(int sectorId) {
        this.sectorId = sectorId;
    }


    //hladacie funkcie

    public static Place makePlaceFromResultSet(ResultSet r) throws SQLException {
        Place place = new Place();

        place.setId(r.getInt("miesto_id"));
        place.setPlace(r.getInt("miesto"));
        place.setRow(r.getInt("rad"));
        place.setSectorId(r.getInt("sektor_id"));

        return place;
    }

    public static Place findById(int placeId) throws SQLException {
        String sql = "SELECT * FROM miesta WHERE miesto_id = ?";
        try (PreparedStatement s = DbContext.getConnection().prepareStatement(sql)) {
            s.setInt(1, placeId);

            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    Place place = makePlaceFromResultSet(r);

                    if (r.next()) {
                        throw new RuntimeException("More than one place with id = " + placeId);
                    }

                    return place;
                }
                return null;    //miesto so zadanym id nenajdene
            }
        }
    }

    public static Place findIdByValues(int _place, int row, int sectorId) throws SQLException {
        String sql = "SELECT * FROM miesta WHERE sektor_id = ? AND rad = ? AND miesto = ?";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            s.setInt(1, sectorId);
            s.setInt(2, row);
            s.setInt(3, _place);

            try(ResultSet r = s.executeQuery()){
                if (r.next()) {
                    Place place = makePlaceFromResultSet(r);

                    if (r.next()) {
                        throw new RuntimeException("More than one place found with values sector = " + sectorId +
                                " row = " + row + " place = " + _place);
                    }

                    return place;
                }
                return null;    //miesto so zadanymi values nenajdene
            }
        }
    }

    public static ArrayList<ArrayList<Place>> findBySectorId(int sectorId) throws SQLException {
        int row = 1;
        ArrayList<ArrayList<Place>> result = new ArrayList<>();

        while (true) {
            String sql = "SELECT * FROM miesta WHERE sektor_id = ? AND rad = ? ORDER BY miesto";
            try (PreparedStatement s = DbContext.getConnection().prepareStatement(sql)) {
                s.setInt(1, sectorId);
                s.setInt(2, row);

                try (ResultSet r = s.executeQuery()) {
                    ArrayList<Place> rowPlaces = new ArrayList<>();

                    while (r.next()) {
                        rowPlaces.add(makePlaceFromResultSet(r));
                    }

                    if (rowPlaces.size() != 0) {
                        result.add(rowPlaces);
                        row++;
                    } else {
                        return result;
                    }
                }
            }
        }
    }

    public boolean isPlaceFree(int eventId) throws SQLException {   //, int sectorId, int place, int row
        //SELECT * FROM listky l
        //WHERE l.akcia_id = 444 AND
        //      l.miesto_id = (SELECT miesto_id FROM miesta m WHERE m.miesto_id = 1 AND m.rad = 1 AND m.sektor_id = 1)
        String sql = "SELECT * FROM listky l WHERE l.akcia_id = ? AND l.miesto_id = " +
                "(SELECT miesto_id FROM miesta m WHERE m.miesto = ? AND m.rad = ? AND m.sektor_id = ?)";
        try (PreparedStatement s = DbContext.getConnection().prepareStatement(sql)) {
            s.setInt(1, eventId);
            s.setInt(2, place);
            s.setInt(3, row);
            s.setInt(4, sectorId);

            try (ResultSet r = s.executeQuery()) {
                //nasiel sa zaznam, miesto nie je volne -> false
                //nenasiel sa zaznam, miesto je volne   -> true
                //treba riesit, ze ich je viac? Je to ale mozne, aby bolo na jedno miesta dva listky?
                return !r.next();
            }
        }
    }

    public boolean hasCustomerRevervationForEvent(int customerId, int eventId) throws SQLException {
        String sql = "SELECT * FROM listky WHERE zakaznik_id = ? AND akcia_id = ? AND miesto_id = ? AND stav = ?";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            s.setInt(1, customerId);
            s.setInt(2, eventId);
            s.setInt(3, id);
            s.setString(4, "R");

            try (ResultSet r = s.executeQuery()) {
                //nasiel sa zaznam, miesto nie je volne -> false
                //nenasiel sa zaznam, miesto je volne   -> true
                //treba riesit, ze ich je viac? Je to ale mozne, aby bolo na jedno miesta dva listky?
                return r.next();
            }
        }
    }

    public static int totalCountOfSectorsOnStadium() throws SQLException {
        String sql = "SELECT count(*) AS countOfSectors FROM sektory";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            try(ResultSet r = s.executeQuery()){
                if(r.next()){
                    return r.getInt("countOfSectors");
                }
            }
        }

        return -1;
    }
}
