import java.math.BigDecimal;
import java.sql.*;
import java.util.ArrayList;

public class PriceList {
    int id;
    BigDecimal childPrice;
    BigDecimal studentPrice;
    BigDecimal normalPrice;
    BigDecimal seniorPrice;

    //get funkcie
    public int getId() { return id; }

    public BigDecimal getStudentPrice() { return studentPrice; }

    public BigDecimal getChildPrice() { return childPrice; }

    public BigDecimal getNormalPrice() { return normalPrice; }

    public BigDecimal getSeniorPrice() { return seniorPrice; }

    public BigDecimal getPriceByType(String type){
        //spolieha sa, ze vzdy dostane spravny typ!
        switch(type.toLowerCase()){
            case "d":   return getChildPrice();
            case "st":  return getStudentPrice();
            case "n":   return getNormalPrice();
            case "se":  return getSeniorPrice();
        }

        return getNormalPrice();
    }

    //set funkcie
    public void setId(int id) { this.id = id; }

    public void setStudentPrice(BigDecimal studentPrice) { this.studentPrice = studentPrice; }

    public void setChildPrice(BigDecimal childPrice) { this.childPrice = childPrice; }

    public void setNormalPrice(BigDecimal normalPrice) { this.normalPrice = normalPrice; }

    public void setSeniorPrice(BigDecimal seniorPrice) { this.seniorPrice = seniorPrice; }

    //ostatne funkcie
    public void insert() throws SQLException {
        String sql = "INSERT INTO cenniky (detske, studentske, normalne, seniorske) VALUES (?, ?, ?, ?)";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql, Statement.RETURN_GENERATED_KEYS)){
            s.setBigDecimal(1, childPrice);
            s.setBigDecimal(2, studentPrice);
            s.setBigDecimal(3, normalPrice);
            s.setBigDecimal(4, seniorPrice);

            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()) {
                r.next();
                id = r.getInt("cennik_id");
            }
        }
    }

    public void update() throws SQLException {
        String sql = "UPDATE cenniky SET detske = ?, studentske = ?, normalne = ?, seniorske = ? WHERE cennik_id = ?";
        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            s.setBigDecimal(1, childPrice);
            s.setBigDecimal(2, studentPrice);
            s.setBigDecimal(3, normalPrice);
            s.setBigDecimal(4, seniorPrice);
            s.setInt(5, id);

            s.executeUpdate();
        }
        catch(SQLException e){
            DbContext.getConnection().rollback();
            throw e;
        }
        finally {
            DbContext.getConnection().setAutoCommit(true);
        }
    }

    public void delete() throws SQLException {
        String sql = "DELETE FROM cenniky WHERE cennik_id = ?";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            s.setInt(1, id);

            s.executeUpdate();
        }
    }

    //hladacie funkcie
    public static PriceList makePriceListFromResultSet(ResultSet r) throws SQLException {
        PriceList priceList = new PriceList();

        priceList.setId(r.getInt("cennik_id"));
        priceList.setChildPrice(r.getBigDecimal("detske"));
        priceList.setStudentPrice(r.getBigDecimal("studentske"));
        priceList.setNormalPrice(r.getBigDecimal("normalne"));
        priceList.setSeniorPrice(r.getBigDecimal("seniorske"));

        return priceList;
    }

    public static PriceList findById(int priceListId) throws SQLException {
        String sql = "SELECT * FROM cenniky WHERE cennik_id = ?";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            s.setInt(1, priceListId);

            try(ResultSet r = s.executeQuery()){
                if(r.next()){
                    PriceList priceList = makePriceListFromResultSet(r);

                    if(r.next()){
                        throw new RuntimeException("More than price list with id = " + priceListId);
                    }

                    return priceList;
                }
                else{
                    return null;    //cennik so zadanym ID nenajdeny
                }
            }
        }
    }

    public static ArrayList<PriceList> findAll() throws SQLException {
        String sql = "SELECT * FROM cenniky";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            try(ResultSet r = s.executeQuery()){
                ArrayList<PriceList> result = new ArrayList<>();

                while(r.next()){
                    result.add(makePriceListFromResultSet(r));
                }

                return result;
            }
        }
    }

}
